/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    adc_ex05_soc_continuous_bitfield_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/*
 * Include Files
 */
#include "adc_ex05_board.h"

/*
 * @brief Board Configurations
 *
 * Initializes the rest of the modules.
 * Call this function in your application if you wish to do all module
 * initialization.
 * If you wish to not use some of the initializations, instead of the
 * Board_init use the individual Module_inits.
 */
void Board_init()
{
	myADC0_init();

}

void myADC0_init()
{
	/*
	 * @brief ADC Initialization:
	 * 		  Write ADC configurations and power up the ADC.
	 */
	/* Select ADC Reference mode and Reference voltage */
	ADC_setVREF(myADC0_BASE,ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);

	/* Set trim */
	AdcaRegs.ADCINLTRIM1 = ADC_TRIM_VALUE;

	/* Configures the analog-to-digital converter module prescaler. */
	AdcaRegs.ADCCTL2.bit.PRESCALE = 6;

	/* Sets the timing of the end-of-conversion pulse */
	AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;

	/* Powers up the ADCA core. */
	AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1;

	/* Delay for 1ms to allow ADCA time to power up */
	DEVICE_DELAY_US(3600);

	/*
	 * @brief SOC Configuration:
	 * 		  Setup ADC EPWM channel and trigger settings.
	 */
	/* Disables SOC burst mode. */
	AdcaRegs.ADCBURSTCTL.bit.BURST_EN = 0;

	/* Sets the priority mode of the SOCs. */
	AdcaRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;

	/*
	 * @brief Start of Conversion 0 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 0
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	AdcaRegs.ADCSOC0CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC0CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC0CTL.bit.ACQPS = 36U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC0 = 2;

	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	AdcaRegs.ADCSOC1CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC1CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC1CTL.bit.ACQPS = 36U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC1 = 2;

	/*
	 * @brief Start of Conversion 2 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 2
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	AdcaRegs.ADCSOC2CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC2CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC2CTL.bit.ACQPS = 36U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC2 = 2;

	/*
	 * @brief Start of Conversion 3 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 3
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	AdcaRegs.ADCSOC3CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC3CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC3CTL.bit.ACQPS = 36U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC3 = 2;

	/*
	 * @brief Start of Conversion 4 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 4
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	AdcaRegs.ADCSOC4CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC4CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC4CTL.bit.ACQPS = 36U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC4 = 2;

	/*
	 * @brief Start of Conversion 5 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 5
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	AdcaRegs.ADCSOC5CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC5CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC5CTL.bit.ACQPS = 36U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC5 = 2;

	/*
	 * @brief Start of Conversion 6 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 6
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	AdcaRegs.ADCSOC6CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC6CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC6CTL.bit.ACQPS = 36U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC6 = 2;

	/*
	 * @brief Start of Conversion 7 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 7
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	AdcaRegs.ADCSOC7CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC7CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC7CTL.bit.ACQPS = 36U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC7 = 2;

	/*
	 * @brief Start of Conversion 8 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 8
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	AdcaRegs.ADCSOC8CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC8CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC8CTL.bit.ACQPS = 36U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC8 = 1;

	/*
	 * @brief Start of Conversion 9 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 9
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	 */
	AdcaRegs.ADCSOC9CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC9CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC9CTL.bit.ACQPS = 36U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC9 = 1;

	/*
	 * @brief Start of Conversion 10 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 10
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	 */
	AdcaRegs.ADCSOC10CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC10CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC10CTL.bit.ACQPS = 36U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC10 = 1;

	/*
	 * @brief Start of Conversion 11 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 11
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	 */
	AdcaRegs.ADCSOC11CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC11CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC11CTL.bit.ACQPS = 36U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC11 = 1;

	/*
	 * @brief Start of Conversion 12 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 12
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	 */
	AdcaRegs.ADCSOC12CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC12CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC12CTL.bit.ACQPS = 36U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC12 = 1;

	/*
	 * @brief Start of Conversion 13 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 13
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	 */
	AdcaRegs.ADCSOC13CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC13CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC13CTL.bit.ACQPS = 36U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC13 = 1;

	/*
	 * @brief Start of Conversion 14 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 14
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	 */
	AdcaRegs.ADCSOC14CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC14CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC14CTL.bit.ACQPS = 36U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC14 = 1;

	/*
	 * @brief Start of Conversion 15 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 15
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	 */
	AdcaRegs.ADCSOC15CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC15CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC15CTL.bit.ACQPS = 36U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC15 = 1;

	/*
	 * @brief ADC Interrupt Initialization:
	 *
	 * ADC Interrupt 1 Configuration
	 * 		SOC/EOC number	: ADC_INT_TRIGGER_EOC6
	 * 		Interrupt Source: disabled
	 * 		Continuous Mode	: enabled
	 */
	AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = ADC_INT_TRIGGER_EOC6;
	AdcaRegs.ADCINTSEL1N2.bit.INT1E = 0;
	AdcaRegs.ADCINTSEL1N2.bit.INT1CONT = 1;

	/*
	 * @brief ADC Interrupt Initialization:
	 *
	 * ADC Interrupt 2 Configuration
	 * 		SOC/EOC number	: ADC_INT_TRIGGER_EOC14
	 * 		Interrupt Source: disabled
	 * 		Continuous Mode	: enabled
	 */
	AdcaRegs.ADCINTSEL1N2.bit.INT2SEL = ADC_INT_TRIGGER_EOC14;
	AdcaRegs.ADCINTSEL1N2.bit.INT2E = 0;
	AdcaRegs.ADCINTSEL1N2.bit.INT2CONT = 1;

	/*
	 * @brief ADC Interrupt Initialization:
	 *
	 * ADC Interrupt 3 Configuration
	 * 		SOC/EOC number	: 7ADC_INT_TRIGGER_EOC7
	 * 		Interrupt Source: disabled
	 * 		Continuous Mode	: enabled
	 */
	AdcaRegs.ADCINTSEL3N4.bit.INT3SEL = ADC_INT_TRIGGER_EOC7;
;
	AdcaRegs.ADCINTSEL3N4.bit.INT3E = 0;
	AdcaRegs.ADCINTSEL3N4.bit.INT3CONT = 1;

	/*
	 * @brief ADC Interrupt Initialization:
	 *
	 * ADC Interrupt 4 Configuration
	 * 		SOC/EOC number	: ADC_INT_TRIGGER_EOC15
	 * 		Interrupt Source: disabled
	 * 		Continuous Mode	: enabled
	 */
	AdcaRegs.ADCINTSEL3N4.bit.INT4SEL = ADC_INT_TRIGGER_EOC15;
	AdcaRegs.ADCINTSEL3N4.bit.INT4E = 0;
	AdcaRegs.ADCINTSEL3N4.bit.INT4CONT = 1;
}

#ifdef __cplusplus

#endif

