//////#############################################################################
////  @File adc_ex16_board.c
////  @KeyWords ADC Enhanced Post-Processing
////
////
////	This example show Floating Point Scaling,Offset,Grouped Averaging
////
////  @hardware_requirements
////
////
////  @software_requirements
////           TODO
//// 	   TODO FTDI
////  @ExternalConnection
////
////  @Watch Variables
////
//////#############################################################################
///*
// *   Copyright (c) Gejian Semiconductors 2023
// *   All rights reserved.
// *
// *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// *
// */

#ifdef __cplusplus
extern "C"
{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "stdio.h"
#include "adc_ex16_board.h"
#include "printf.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
uint16_t myADC0Result0;
uint16_t myADC0Result1;
float32_t MeanGroup0ADCeResult;
/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
//
// Main
//
void main(void)
{
	//
	// Initialize device clock and peripherals
	//
	Device_init();

	UartPrint_init(LOG_SCI_BASE, 115200);
	//
	// Set up ADCs, initializing the SOCs to be triggered by software
	//
	Board_init();
	ADC_enableMeanGroup(ADCARESULT_BASE, ADC_SOC_NUMBER0, ADC_MEAN_GROUP0);
	ADC_enableMeanGroup(ADCARESULT_BASE, ADC_SOC_NUMBER1, ADC_MEAN_GROUP0);
#if IS_GS32F3xx(0x22) ||IS_GS32F00xx(0x30)
	ADC_setEPPBScale(ADCARESULT_BASE,ADC_SOC_NUMBER1,3.5);
	ADC_setEPPBOffset(ADCARESULT_BASE,ADC_SOC_NUMBER1,2);
#endif
	//
	// Enable Global Interrupt
	//
	EINT;

	//
	// Loop indefinitely
	//
	while(1)
	{
		//
		// Convert, wait for completion, and store results
		//
		ADC_forceMultipleSOC(myADC0_BASE, (ADC_FORCE_SOC0 | ADC_FORCE_SOC1));

		//
		// Wait for ADCA to complete, then acknowledge flag
		//
		while(ADC_getInterruptStatus(myADC0_BASE, ADC_INT_NUMBER1) == false)
		{

		}
		ADC_clearInterruptStatus(myADC0_BASE, ADC_INT_NUMBER1);
		//
		// Store results
		//
		myADC0Result0 = ADC_readResult(ADCARESULT_BASE, ADC_SOC_NUMBER0);
		myADC0Result1 = ADC_readResult(ADCARESULT_BASE, ADC_SOC_NUMBER1);
#if IS_GS32F3xx(0x22) ||IS_GS32F00xx(0x30)
		MeanGroup0ADCeResult = ADC_readEPPBResult(ADCARESULT_BASE, ADC_SOC_NUMBER1);
#endif
	}
}

#ifdef __cplusplus
}
#endif
