/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "can_dma_if2.h"
#include <string.h>
#include "device.h"
#include "stdio.h"
#include "string.h"

uint32_t status1;
__IO CAN_TxMessage_t TxMsgBuf1[16] = {0};
CAN_RxMessage_t RxMsgBuf = {0};
CAN_TxMessage_t TxMsgBuf = {0};
volatile int dma_block =0;
#if IS_GS32F00xx(0x12)
DMA_ConfigParams dmaCfg = {0};
#elif IS_GS32F3xx(0x22)
XDMA_ConfigParams dmaCfg = {0};
#endif

void dma_ISR()
{

    dma_block++;
    CAN_selectNextSecondaryBuf(CAN_BASE);
#if IS_GS32F00xx(0x12)
    CAN_clearIntrStatus(CAN_BASE, CAN_RTIF_TSIF_M);
    DMA_clearInterrupt(DMA_CH1_BASE,DMA_INT_BLOCK);
    if(dma_block==16){
    	CAN_startTransmission(CAN_BASE,CAN_TX_MODE_ALL_MSG);
    	DMA_stopChannel(DMA_CH1_BASE);
    }
#elif IS_GS32F3xx(0x22)
    XDMA_clearInterrupt(DMA1_CH1_BASE,XDMA_INT_BLOCK);
    if(dma_block>15){
    	CAN_startTransmission(CAN_BASE,CAN_TX_MODE_ALL_MSG);
    	while(HWREG(CAN_BASE + CAN_O_TCMD) & CAN_TCMD_TSALL_M);
    	XDMA_stopChannel(DMA1_CH1_BASE);
        CAN_clearIntrStatus(CAN_BASE, CAN_RTIF_TSIF_M);
    }
#endif
}

void dma_ex_can2m(void)
{

    uint32_t errCnt = 0;
    uint32_t i;
    uint32_t chl_base;

	for(i=0;i<16;i++){
		TxMsgBuf1[i].dlc = CAN_DATA_LENGTH_64;
		TxMsgBuf1[i].id = 0xc1+i;
		TxMsgBuf1[i].data[i]=1;
		TxMsgBuf1[i].ide = 0;
		TxMsgBuf1[i].fdf = 1;
	}
#if IS_GS32F00xx(0x12)
    DMA_initController(DMA_BASE);

    DMA_stopChannel(DMA_CH1_BASE);

    dmaCfg.enableInterrupt = 1;
    dmaCfg.dmaDstReqId = CAN_DMAREQID_2;
    dmaCfg.srcAddr = (uint32_t)TxMsgBuf1;
    dmaCfg.destAddr =(CAN_BASE+0x50);
    dmaCfg.blockTS = 18;
    dmaCfg.ttfc    = DMA_TT_FC_1_M2P_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_1;
    dmaCfg.destBtl = DMA_BTL_1;
    dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.destAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_4;
    dmaCfg.destTrWidthBytes = DMA_TR_WIDTH_BYTE_4;
    dmaCfg.reloadDst=1;
    dmaCfg.reloadSrc=0;
    chl_base = DMA_convertChnbase2DmamuxBase(DMA_CH1_BASE);
	DMAMUX_setDmaMuxGenNumReqs(chl_base, 0,   16*dmaCfg.blockTS-1);
    DMA_configChannel(DMA_CH1_BASE, &dmaCfg);

    DMA_clearInterrupt(DMA_CH1_BASE, DMA_INT_TFR | DMA_INT_BLOCK | DMA_INT_ERR);
    DMA_unMaskInterrupt(DMA_CH1_BASE, DMA_INT_TFR | DMA_INT_BLOCK | DMA_INT_ERR);

    Interrupt_register(INT_DMA1_CH1, dma_ISR);
    Interrupt_enable(INT_DMA1_CH1);

    DMA_enableInterrupt(DMA_BASE);
    DMA_startChannel(DMA_CH1_BASE);
#elif IS_GS32F3xx(0x22)
    XDMA_initController(DMA1_BASE);
    dmaCfg.enableInterrupt = 1;
    dmaCfg.dmaDstReqId = CAN_DMAREQID_2;
    dmaCfg.srcAddr = (uint32_t)TxMsgBuf1;
    dmaCfg.destAddr = (CAN_BASE+0x50);
    dmaCfg.blockTS = 18;
    dmaCfg.ttfc    = XDMA_TT_FC_1_M2P_DMAC;//DMA_TT_FC_2_P2M_DMAC
    dmaCfg.srcBtl  = XDMA_BTL_1;
    dmaCfg.destBtl = XDMA_BTL_1;
    dmaCfg.srcAddrDirect = XDMA_ADDR_INCRE;
    dmaCfg.destAddrDirect = XDMA_ADDR_INCRE;
    dmaCfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_4;
    dmaCfg.destTrWidthBytes = XDMA_TR_WIDTH_BYTE_4;
    dmaCfg.reloadDst=1;
    dmaCfg.reloadSrc=0;
    chl_base = XDMA_convertChnbase2DmamuxBase(DMA1_CH1_BASE);
	DMAMUX_setDmaMuxGenNumReqs(chl_base, 0,16*dmaCfg.blockTS-1);
    XDMA_configChannel(DMA1_CH1_BASE, &dmaCfg);

    XDMA_unMaskInterrupt(DMA1_CH1_BASE,  XDMA_INT_BLOCK );
    XDMA_clearInterrupt(DMA1_CH1_BASE,  XDMA_INT_BLOCK );

    Interrupt_register(INT_DMA1_CH1, &dma_ISR);
    Interrupt_enable(INT_DMA1_CH1);

    XDMA_enableInterrupt(DMA1_BASE);
    XDMA_startChannel(DMA1_CH1_BASE);
#endif
}

void can_config(void)
{
	CAN_InitParams_t initParams = {0};
	CAN_FilterElement_t stdFiltelem = {0};

	initParams.fdMode = true;
	initParams.txbmode = CAN_TS_MODE_PRIORITY;
	initParams.timestamp = CAN_TIMESTAMP_EOF;

	/* accept all CAN ID frames. */
	stdFiltelem.acode = 0xc0;
	stdFiltelem.amsk = 0x1fffffff;
	stdFiltelem.filerFrameType = CAN_IDTYPE_BOTH_STD_EXT;

	/* Initial CAN module. */
	if (!CAN_initModule(CAN_BASE))
		while (1);

	/* Configuration CAN basic function. */
	if (!CAN_initConfig(CAN_BASE, &initParams))
		while (1);
	/* Set the arbitration segment bit rate based on sampling points. */
	if (!CAN_setBitRateSamplePoint(CAN_BASE, 40000000, 1U * 1000 * 1000, 0.8))
		while (1);

	/* Set the data segment bit rate based on sampling points */
	if (!CAN_setDataBitRateSamplePoint(CAN_BASE, 40000000, 4U * 1000 * 1000, 0.8))
		while (1);

	/* Set CAN ID acceptance filter 0. */
	if (!CAN_configMsgFilter(CAN_BASE, 0, &stdFiltelem))
		while (1);

	/* Enable CAN ID acceptance filter 0. */
	if (!CAN_configMsgFilterEnable(CAN_BASE, 0))
		while (1);

	/* Start running CAN module. */
	if (!CAN_startModule(CAN_BASE))
		while (1);

	/* Enable internal loopback mode. */
	if (!CAN_lpbkModeEnable(CAN_BASE, CAN_LPBK_MODE_INTERNAL, false))
		while (1);
}

void can_ctrl_init(void)
{
	SysCtl_setCanClkSrcSel(CAN_CLK_TYPE_PLL);

	/* CAN clock source = 40MHz, PLL_CLK = 2* SYS_CLK */
	SysCtl_setCanClkDiv((DEVICE_SYSCLK_FREQ * 2 / 40000000));
	can_config();
	Interrupt_SetPriority(CAN_IRQ_NUM, 0, 0);
//	Interrupt_enable(CAN_IRQ_NUM);
	CAN_enableInterrupt(CAN_BASE,CAN_RTIE_TSIE_M);
}
