/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/**
*   @file    clb_ex10_delay.c
*   @brief
*   @details
*
/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"
#include "board.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define EDA_CSIM                  0             //set to 1 when make target for simulation
#define LOG_LEVEL                 LOG_INFO

#define LED_STA_PIN     GPIO_PIN_LED2
#define GPREG_0_EVENT_DATA_SHIFT  0U
#define GPREG_1_MODE0_EN_SHIFT    1U
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

int main(void)
{
    uint32_t oldTicks[20],i=0;
    uint32_t tickCnt[20];
    uint32_t counterValue = 0;

    Device_init();
        //enable clb Peripherals
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_CLB);

    log_set_level(LOG_LEVEL);

    __enable_irq();

    CLB_init();

    // clbInputXbar select gpio0(epwm1a) as Input Single
    XBAR_setInputPin(CLBINPUTXBAR_BASE, XBAR_INPUT1, 0);
    // GPIO0 Input  to CLB outputXbar delay time
    XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT1, XBAR_OUT_MUX00_CLB1_OUT1  );
    XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX00);

    XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT2,XBAR_OUT_MUX12_CLB2_OUT1 );
    XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT2,XBAR_MUX12);
    XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT1,XBAR_OUT_MUX13_CLB1_OUT7);
    XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX13);
    HWREG(0x4006DF00+0x58)=1;

    XBAR_setEPWMMuxConfig(XBAR_TRIP4, XBAR_OUT_MUX13_CLB1_OUT7);
    XBAR_enableEPWMMux(XBAR_TRIP4, XBAR_MUX13);

    CLB_enableCLB(myTILE1_BASE);
    CLB_enableCLB(myTILE2_BASE);

    //gp6=1,out6=HIGH,out7=low
    SysCtl_delay(180500L);
    CLB_setGPREG(myTILE1_BASE,0x40);

    while(1)
    {

    }

    return 0;
}

