/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    ecap_ex05_apwm_pwm_sync.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "ecap_ex05_apwm_pwm_sync.h"
#include "printf.h"
#include "ecap_ex05_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define PWM_FREQUENCY       10000U // 10 Khz
#define PWM_DUTY            0.5f   // 50% duty
#define PWM_PRD_VAL         20000000U / PWM_FREQUENCY
#define PWM_CMP_VAL         (uint32_t)(PWM_DUTY * PWM_PRD_VAL)

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

void initEPWM()
{
    // Disable sync(Freeze clock to PWM as well)
    //
    // SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    // Configure ePWM
    //       Counter runs in up-count mode.
    //       Action qualifier will output low on period match
    //       Action qualifier will output high on CTR=CMPA
    //
    EPWM_setClockPrescaler(EPWM1_BASE,
                           EPWM_CLOCK_DIVIDER_1,
                           EPWM_HSCLOCK_DIVIDER_1);
	EPWM_setTimeBasePeriod(EPWM1_BASE, PWM_PRD_VAL);
	EPWM_setTimeBaseCounter(EPWM1_BASE,0U);
    EPWM_setTimeBaseCounterMode(EPWM1_BASE, EPWM_COUNTER_MODE_UP);
    EPWM_disablePhaseShiftLoad(EPWM1_BASE);
    EPWM_setPhaseShift(EPWM1_BASE, 0U);
	EPWM_setCounterCompareValue(EPWM1_BASE,EPWM_COUNTER_COMPARE_A,PWM_CMP_VAL);
	EPWM_setCounterCompareShadowLoadMode(EPWM1_BASE,EPWM_COUNTER_COMPARE_A,EPWM_COMP_LOAD_ON_CNTR_ZERO);
	EPWM_enableSyncOutPulseSource(EPWM1_BASE,EPWM_SYNC_OUT_PULSE_ON_CNTR_ZERO);
    EPWM_setActionQualifierAction(EPWM1_BASE,
                                  EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
	EPWM_setActionQualifierAction(EPWM1_BASE,
                                  EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);

    // Another ePWM Configurations where ePWM shifts phase by 50% comparing to eCAP.
    //       Counter runs in up-count mode.
    //       Action qualifier will output low on period match
    //       Action qualifier will output high on CTR=CMPB
    // 
    // EPWM_setClockPrescaler(EPWM1_BASE,
    //                        EPWM_CLOCK_DIVIDER_1,
    //                        EPWM_HSCLOCK_DIVIDER_1);
	// EPWM_setTimeBasePeriod(EPWM1_BASE, PWM_PRD_VAL);
	// EPWM_setTimeBaseCounter(EPWM1_BASE,0U);
    // EPWM_setTimeBaseCounterMode(EPWM1_BASE, EPWM_COUNTER_MODE_UP);
    // EPWM_disablePhaseShiftLoad(EPWM1_BASE);
    // EPWM_setPhaseShift(EPWM1_BASE, 0U);
	// EPWM_setCounterCompareValue(EPWM1_BASE,EPWM_COUNTER_COMPARE_B,PWM_CMP_VAL);
	// EPWM_setCounterCompareShadowLoadMode(EPWM1_BASE,EPWM_COUNTER_COMPARE_B,EPWM_COMP_LOAD_ON_CNTR_ZERO);
	// EPWM_enableSyncOutPulseSource(EPWM1_BASE,EPWM_SYNC_OUT_PULSE_ON_CNTR_COMPARE_B);
    // EPWM_setActionQualifierAction(EPWM1_BASE,
    //                               EPWM_AQ_OUTPUT_A,
    //                               EPWM_AQ_OUTPUT_LOW,
    //                               EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
	// EPWM_setActionQualifierAction(EPWM1_BASE,
    //                               EPWM_AQ_OUTPUT_A,
    //                               EPWM_AQ_OUTPUT_HIGH,
    //                               EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);

    // Enable sync and clock to PWM
    //
     SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

void main(void){

	Device_init();

	// Board initialization
    // Select eCAP1OUT on MUX 0. Make GPIO5 as eCAP1OUT for PWM output
    // Select eCAP2OUT on MUX 2. Make GPIO6 as eCAP2OUT for PWM output
    // Configure eCAP1 in APWM mode with defined period and duty values
    // Polarity as low and configure SYNCOUT at CTR=PRD
    //
	Board_init();
    
    // Configure ePWM
	initEPWM();

    while(1)
    {

    }
}

/**
 * \brief   "add brief description of this function" 
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

#ifdef __cplusplus
}
#endif
