//#############################################################################
//
// FILE:   epg_ex10_generate_serial_data_shift_mode.c
//
// TITLE:   EPG Generate Serial Data Shift Mode
//
//! \addtogroup driver_example_list
//! <h1> EPG Generate Serial Data Shift Mode</h1>
//!
//! This example generates SPICLK and SPI DATA signals using the SIGGEN module
//! in SHIFT mode.
//! For more information on this example, visit:
//! [Designing With the C2000 Embedded Pattern Generator
//! (EPG)](https://www.ti.com/lit/spracy7)
//!
//! \b External \b Connections \n
//!  - None. Signal is generated on GPIO 2, 3. Can be visualized
//!    through oscilloscope.
//!
//#############################################################################
/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "log.h"
#include "epg.h"
#include "epg_ex10_generate_serial_data_shift_mode_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

volatile uint32_t epg1_gintsts = 0;

/* ================================================EPG_setData1Word(EPG_BASE, EPG_SIGGEN0, SIG_GEN_DATA0_1);========================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/*
 * @brief  main function.
 */
int main(void)
{
    uint32_t oldTicks;
    uint32_t tickCnt;

    Device_init();
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_EPG);
    UartPrint_init(LOG_SCI_BASE, 115200);
    printf("print ok\r\n");

    Board_init();

    __enable_irq();


    while (1)
    {
    	epg1_gintsts = EPG_getInterruptStatus(EPG_BASE);		
        if (epg1_gintsts & EPG_INT_SIGGEN0_DONE){				
            EPG_clearInterruptFlag(EPG_BASE, epg1_gintsts);		
            EPG_setData0Word(EPG_BASE, EPG_SIGGEN0, (SIG_GEN_DATA0_0_15 | (uint32_t)SIG_GEN_DATA0_16_31 << 16));	
            EPG_setData1Word(EPG_BASE, EPG_SIGGEN0, SIG_GEN_DATA0_1);
            EPG_enableSignalGen(EPG_BASE, EPG_SIGGEN0);			
        }
        DEVICE_DELAY_US(10);
    }

    return 0;
}

