#include "epg_ex1_generate_clocks_board.h"
#include "epg.h"
#include "xbar.h"

#define CLK_GEN_PERIOD      0U
#define CLK_GEN_OFFSET      0U
#define SIG_GEN_DATA_LENGTH 12U
#define SIG_GEN_DATA0_0_12  0b000001111110U                  
#define SIG_GEN_DATA0_16_27 (SIG_GEN_DATA0_0_12 << 2)       

void PinMux_init(void)
{
	// OUTPUTXBAR Pin Mux
	// OUTPUTXBAR1_PIN GPIO_2
    GPIO_setPinConfig(OUTPUTXBAR1_PIN_CONFIG);
    GPIO_setDirectionMode(OUTPUTXBAR1_GPIO, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(OUTPUTXBAR1_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(OUTPUTXBAR1_GPIO, GPIO_QUAL_SYNC);

    // OUTPUTXBAR2_PIN GPIO_3
    GPIO_setPinConfig(OUTPUTXBAR2_PIN_CONFIG);
    GPIO_setDirectionMode(OUTPUTXBAR2_GPIO, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(OUTPUTXBAR2_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(OUTPUTXBAR2_GPIO, GPIO_QUAL_SYNC);
}


void XBAR_Init(void)
{
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT1,
							XBAR_OUT_MUX30_EPGOUT0);
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT2,
							XBAR_OUT_MUX31_EPGOUT1);

	XBAR_enableOutputMux(OUTPUTXBAR_BASE, XBAR_OUTPUT1, XBAR_MUX30);
	XBAR_enableOutputMux(OUTPUTXBAR_BASE, XBAR_OUTPUT2, XBAR_MUX31);
}

void EPG_Init(void)
{
	uint32_t sigGenData = 0;

	//
	// Set EPGOUT0 and 1 to select the output of the signal generator
	//
	EPG_selectEPGOutput(EPG_BASE, EPG_OUT0, EPG_OUT_SEL_SIG);
	EPG_selectEPGOutput(EPG_BASE, EPG_OUT1, EPG_OUT_SEL_SIG);

	//
    // This makes sure that bit 0, bit 16 of the transformed data
    // are sent to the output when bit bang is disabled
    //
	EPG_selectSignalOutput(EPG_BASE, EPG_OUT0, EPG_SIGGEN0_DATATRANOUT0);
	EPG_selectSignalOutput(EPG_BASE, EPG_OUT1, EPG_SIGGEN0_DATATRANOUT2);

    //
    // Set Clock Generator 0 period to 0 which is divide by 1
    //
    EPG_setClkGenPeriod(EPG_BASE, EPG_CLKGEN0, CLK_GEN_PERIOD);

    //
    // Set offset of clock generator output 0 to 0
    //
    EPG_setClkGenOffset(EPG_BASE, EPG_CLKGEN0, 0, CLK_GEN_OFFSET);

    //
    // Set the source of signal generator 0 to clk generator output 0
    //
    EPG_selectSigGenClkSource(EPG_BASE, EPG_SIGGEN0, EPG_CLKGEN0_CLKOUT0_DCLK);

    //
    // Set signal generator bit length to 12. When it completes
    // shifting of 12 bits, it loads the data0 and data1 registers to
    // to the active data register
    //
    EPG_setDataBitLen(EPG_BASE, EPG_SIGGEN0, SIG_GEN_DATA_LENGTH);

    //
    // Set signal generator mode to right shift and repeat for 12 bits.
    //
    EPG_setSignalGenMode(EPG_BASE, EPG_SIGGEN0,
                         EPG_SIGGEN_MODE_ROTATE_RIGHT_REPEAT);
    //
    // Set the first 12 bits of data for signal generator output 0 to
    // generator a 50% duty cycle clock with 1 cycle offset and next
    // 12 bits with 3 cycle offset
    //
    sigGenData = (SIG_GEN_DATA0_0_12 | (uint32_t)SIG_GEN_DATA0_16_27 << 16);
    EPG_setData0Word(EPG_BASE, EPG_SIGGEN0, sigGenData);		// sigGenDataдźŷData0[0:31]

    //
    // Enable EPG
    //
    EPG_enableGlobal(EPG_BASE);

    //
    // Enable signal generator
    //
    EPG_enableSignalGen(EPG_BASE, EPG_SIGGEN0);
}


void Board_init(void)
{
	PinMux_init();
	XBAR_Init();
	EPG_Init();
}
