/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "epwm_ex04_board_bit.h"

//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules.
// Call this function in your application if you wish to do all module
// initialization.
// If you wish to not use some of the initializations, instead of the
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
    EALLOW;

    PinMux_init();
    INPUTXBAR_init();
    EPWM_init();
    INTERRUPT_init();
    GPIO_init();

    EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{
    //
    // PinMux for modules assigned to CPU1
    //

    //
    // EPWM1 -> myEPWM1 Pinmux
    //
    GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

    // GPIO25 -> myGPIO25 Pinmux
    GPIO_setPinConfig(GPIO_25_GPIO25);

}

//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
void EPWM_init()
{
    //	ePWM1 Configurations
    //TB
    //	Set 16(4*4) frequency division
    EPwm1Regs.TBCTL.bit.CLKDIV 	  = 2;
    EPwm1Regs.TBCTL.bit.HSPCLKDIV = 2;
    //	Set TBPRD = 12000
    EPwm1Regs.TBPRD = 12000;
    //	Set TBCTR = 0
    EPwm1Regs.TBCTR = 0;
    //	Counting mode: UP_DOWN
    EPwm1Regs.TBCTL.bit.CTRMODE = 2;
    //	Disable phase shift load
    EPwm1Regs.TBCTL.bit.PHSEN = 0;
    //	Set TBPHS = 0
    EPwm1Regs.TBPHS.bit.TBPHS = 0;


    //CC
    //	Set CMPA = 6000
    EPwm1Regs.CMPA.bit.CMPA = 6000;
    //	Load the new CMPA when TBCTR = 0
    EPwm1Regs.CMPCTL.bit.LOADAMODE = 0;

    //AQ
    //	TBCTR = UP_CMPA -> ePWM1A:HIGH
    EPwm1Regs.AQCTLA.bit.CAU = 2;
    //	TBCTR = DOWN_CMPA -> ePWM1A:LOW
    EPwm1Regs.AQCTLA.bit.CAD = 1;


    //TZ
    //	When TZ1-TZ6, DCAEVT2, DCAEVT1 occur occur -> ePWM1A:LOW
    EPwm1Regs.TZCTL.bit.TZA = 2;
    // 	enable DCAEVT1 occur Interrupt
    EPwm1Regs.TZEINT.bit.DCAEVT1 = 1;
    //	When the DCxH = LOW event occurs, the DC outputs the A1 event(DCA outputs event 1)
    EPwm1Regs.TZDCSEL.bit.DCAEVT1 = 1;


    //DC
    //	Set the Digital Comparator A synchronization input mode to the DC input signal is not synchronized with TBCLK
    //  and the Digital Comparison event number is 1(One-shot).
    EPwm1Regs.DCACTL.bit.EVT1FRCSYNCSEL = 1;
    EPwm1Regs.DCACTL.bit.EVT1SRCSEL = 0;

}

//*****************************************************************************
//
// GPIO Configurations
//
//*****************************************************************************
void GPIO_init()
{
    myGPIO25_init();
}

void myGPIO25_init()
{
    GPIO_setPadConfig(myGPIO25, GPIO_PIN_TYPE_STD | GPIO_PIN_TYPE_PULLUP);
    GPIO_setQualificationMode(myGPIO25, GPIO_QUAL_ASYNC);
    GPIO_setDirectionMode(myGPIO25, GPIO_DIR_MODE_IN);
}

//*****************************************************************************
//
// INPUTXBAR Configurations
//
//*****************************************************************************
void INPUTXBAR_init()
{
    myINPUTXBARINPUT0_init();
}

void myINPUTXBARINPUT0_init()
{
    XBAR_setInputPin(INPUTXBAR_BASE, myINPUTXBARINPUT0_INPUT, myINPUTXBARINPUT0_SOURCE);
}

//*****************************************************************************
//
// INTERRUPT Configurations
//
//*****************************************************************************
void INTERRUPT_init()
{

    // Interrupt Settings for INT_myEPWM1_TZ
    // ISR need to be defined for the registered interrupts
    Interrupt_register(INT_myEPWM1_TZ, &epwm1TZISR);
    Interrupt_enable(INT_myEPWM1_TZ);


}

