/*
 * 	File: epwm_ex17_Compare_Extend
 *
 *	ʾƶABͨ,ⳡ
 *
 *
 *	ePWM1Ϊһ  Upģʽʾ
 *	ʾePWM1A ->IO0ePWM1B->IO1۲첨
 *
 *
 *	ePWM2Ϊһ  Downģʽʾ
 *	ʾePWM2A ->IO2ePWM2B->IO3۲첨
 *
 *
 *
 *	ePWM3Ϊһ  Up-Downģʽʾ
 *	ʾePWM3A ->IO4ePWM3B->IO5۲첨
 *
 *
*/
/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "epwm_ex17_board.h"




int main(void)
{
	 //
	// Initialize device clock and peripherals
	//
	Device_init();


	//
	// Disable sync(Freeze clock to PWM as well)
	//
	SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);


	//
	// For this case just init GPIO pins for ePWM1, ePWM2, ePWM3
	//
	Board_init();


	//
	// Enable sync and clock to PWM
	//
	SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);


	//
	// Enable global Interrupts and higher priority real-time debug events:
	//
	EINT;  // Enable Global interrupt INTM
	ERTM;  // Enable Global realtime interrupt DBGM

	//
	// IDLE loop. Just sit and loop forever (optional):
	//
	for(;;)
	{
		asm ("  NOP");
	}

	return 0;

}

