/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */



#include "epwm_ex17_board.h"





//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules.
// Call this function in your application if you wish to do all module
// initialization.
// If you wish to not use some of the initializations, instead of the
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
    EALLOW;

    PinMux_init();
    EPWM1_init();
    EPWM2_init();
    EPWM3_init();

    EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{
    //
    // PinMux for modules assigned to CPU1
    //

    //
    // EPWM1 -> myEPWM1 Pinmux
    //
    GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);

    //
    // EPWM2 -> myEPWM2 Pinmux
    //
    GPIO_setPinConfig(myEPWM2_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM2_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM2_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM2_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM2_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM2_EPWMB_GPIO, GPIO_QUAL_SYNC);

    //
    // EPWM3 -> myEPWM3 Pinmux
    //
    GPIO_setPinConfig(myEPWM3_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM3_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM3_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM3_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM3_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM3_EPWMB_GPIO, GPIO_QUAL_SYNC);


}




//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
void EPWM1_init()
{
	//ePWM1
	//TB
	//	ePWMʱ1Ƶ
	EPWM_setClockPrescaler(myEPWM1_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);  //EPWMʱΪ1Ƶ
	//	ģʽϼ
    EPWM_setTimeBaseCounterMode(myEPWM1_BASE, EPWM_COUNTER_MODE_UP);
	//	ֵTBPRD = 20000
    EPWM_setTimeBasePeriod(myEPWM1_BASE, 20000);
    //	ֵTBCTR = 0
    EPWM_setTimeBaseCounter(myEPWM1_BASE, 0);
    //	ฺʧ
    EPWM_disablePhaseShiftLoad(myEPWM1_BASE);
    //	ֵTBPHS = 0
    EPWM_setPhaseShift(myEPWM1_BASE, 0);


    //CC
	// 	ʹ CMPA1/B1 
	//	ʱͨACMPACMPBƣͨBCMPA1CMPB1
	EPWM_enableCounterCompare_Extend(myEPWM1_BASE);

	//Aͨ
    //	ñȽAֵCMPA = 5000
    EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, 5000);
    //	ñȽAļģʽTBCTR = 0 ʱµCMPA
    EPWM_setCounterCompareShadowLoadMode(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
    //	ñȽBֵCMPB = 15000
    EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B, 15000);
    //	ñȽBļģʽTBCTR = 0 ʱµCMPB
    EPWM_setCounterCompareShadowLoadMode(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);

	//Bͨ
    //	ñȽA1ֵCMPA1 = 5000
	EPWM_setCounterCompareValue_Extend(myEPWM1_BASE,EPWM_COUNTER_COMPARE_A1,5000);
    //	ñȽA1ļģʽTBCTR = 0 ʱµCMPA1
	EPWM_setCounterCompareShadowLoadMode_Extend(myEPWM1_BASE,EPWM_COUNTER_COMPARE_A1,EPWM_COMP_LOAD_ON_CNTR_ZERO);
    //	ñȽB1ֵCMPB1 = 15000
	EPWM_setCounterCompareValue_Extend(myEPWM1_BASE,EPWM_COUNTER_COMPARE_B1,15000);
    //	ñȽB1ļģʽTBCTR = 0 ʱµCMPB1
	EPWM_setCounterCompareShadowLoadMode_Extend(myEPWM1_BASE,EPWM_COUNTER_COMPARE_B1,EPWM_COMP_LOAD_ON_CNTR_ZERO);


	//AQ
	//Aͨ
    //	Aͨ¼: TBCTR = UP_CMPA -> ePWM1AHIGH
	EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    //	Aͨ¼: TBCTR =  UP_CMPB -> ePWM1BLOW
	EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    //	Aͨ¼ӰӼģʽ -> Aͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM1_BASE,EPWM_ACTION_QUALIFIER_A);

	//Bͨ
    //	Bͨ¼: TBCTR = UP_CMPA1 -> ePWM1BHIGH
	EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA1);
    //	Bͨ¼: TBCTR =  UP_CMPB1 -> ePWM1BLOW
	EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB1);
    //	Bͨ¼ӰӼģʽ -> Bͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM1_BASE,EPWM_ACTION_QUALIFIER_B);
}


void EPWM2_init()
{

	//ePWM2
	//TB
	//	ePWMʱ1Ƶ
	EPWM_setClockPrescaler(myEPWM2_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);  //EPWMʱΪ1Ƶ
	//	ģʽ¼
    EPWM_setTimeBaseCounterMode(myEPWM2_BASE, EPWM_COUNTER_MODE_DOWN);
	//	ֵTBPRD = 20000
    EPWM_setTimeBasePeriod(myEPWM2_BASE, 20000);
    //	ֵTBCTR = 0
    EPWM_setTimeBaseCounter(myEPWM2_BASE, 0);
    //	ฺʧ
    EPWM_disablePhaseShiftLoad(myEPWM2_BASE);
    //	ֵTBPHS = 0
    EPWM_setPhaseShift(myEPWM2_BASE, 0);



    //CC
	// 	ʹ CMPA1/B1 
	//	ʱͨACMPACMPBƣͨBCMPA1CMPB1
	EPWM_enableCounterCompare_Extend(myEPWM2_BASE);

	//Aͨ
    //	ñȽAֵCMPA = 5000
    EPWM_setCounterCompareValue(myEPWM2_BASE, EPWM_COUNTER_COMPARE_A, 5000);
    //	ñȽAļģʽTBCTR = 0 ʱµCMPA
    EPWM_setCounterCompareShadowLoadMode(myEPWM2_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
    //	ñȽBֵCMPB = 15000
    EPWM_setCounterCompareValue(myEPWM2_BASE, EPWM_COUNTER_COMPARE_B, 15000);
    //	ñȽBļģʽTBCTR = 0 ʱµCMPB
    EPWM_setCounterCompareShadowLoadMode(myEPWM2_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);


	//Bͨ
    //	ñȽA1ֵCMPA1 = 5000
	EPWM_setCounterCompareValue_Extend(myEPWM2_BASE,EPWM_COUNTER_COMPARE_A1,5000);
    //	ñȽA1ļģʽTBCTR = 0 ʱµCMPA1
	EPWM_setCounterCompareShadowLoadMode_Extend(myEPWM2_BASE,EPWM_COUNTER_COMPARE_A1,EPWM_COMP_LOAD_ON_CNTR_ZERO);
    //	ñȽB1ֵCMPB1 = 15000
	EPWM_setCounterCompareValue_Extend(myEPWM2_BASE,EPWM_COUNTER_COMPARE_B1,15000);
    //	ñȽB1ļģʽTBCTR = 0 ʱµCMPB1
	EPWM_setCounterCompareShadowLoadMode_Extend(myEPWM2_BASE,EPWM_COUNTER_COMPARE_B1,EPWM_COMP_LOAD_ON_CNTR_ZERO);


	//AQ
	//Aͨ
    //	Aͨ¼: TBCTR = Down_CMPA -> ePWM1AHIGH
	EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
    //	Aͨ¼: TBCTR = Down_CMPB -> ePWM1ALOW
	EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
    //	Aͨ¼ӰӼģʽ -> Aͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM2_BASE,EPWM_ACTION_QUALIFIER_A);

	//Bͨ
    //	Bͨ¼: TBCTR = Down_CMPA1 -> ePWM1BHIGH
	EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA1);
    //	Bͨ¼: TBCTR = Down_CMPB1 -> ePWM1ALOW
	EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB1);
    //	Bͨ¼ӰӼģʽ -> Bͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM2_BASE,EPWM_ACTION_QUALIFIER_B);

}

void EPWM3_init()
{

	//ePWM3
	//TB
	//	ePWMʱ1Ƶ
	EPWM_setClockPrescaler(myEPWM3_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);  //EPWMʱΪ1Ƶ
	//	ģʽ¼
    EPWM_setTimeBaseCounterMode(myEPWM3_BASE, EPWM_COUNTER_MODE_UP_DOWN);
	//	ֵTBPRD = 10000
    EPWM_setTimeBasePeriod(myEPWM3_BASE, 10000);
    //	ֵTBCTR = 0
    EPWM_setTimeBaseCounter(myEPWM3_BASE, 0);
    //	ฺʧ
    EPWM_disablePhaseShiftLoad(myEPWM3_BASE);
    //	ֵTBPHS = 0
    EPWM_setPhaseShift(myEPWM3_BASE, 0);



    //CC
	// 	ʹ CMPA1/B1 
	//	ʱͨACMPACMPBƣͨBCMPA1CMPB1
	EPWM_enableCounterCompare_Extend(myEPWM3_BASE);

	//Aͨ
    //	ñȽAֵCMPA = 5000
    EPWM_setCounterCompareValue(myEPWM3_BASE, EPWM_COUNTER_COMPARE_A, 5000);
    //	ñȽAļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPA
    EPWM_setCounterCompareShadowLoadMode(myEPWM3_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
    //	ñȽBֵCMPB = 5000
    EPWM_setCounterCompareValue(myEPWM3_BASE, EPWM_COUNTER_COMPARE_B, 5000);
    //	ñȽBļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPB
    EPWM_setCounterCompareShadowLoadMode(myEPWM3_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);


	//Bͨ
    //	ñȽA1ֵCMPA1 = 5000
	EPWM_setCounterCompareValue_Extend(myEPWM3_BASE,EPWM_COUNTER_COMPARE_A1,5000);
    //	ñȽA1ļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPA1
	EPWM_setCounterCompareShadowLoadMode_Extend(myEPWM3_BASE,EPWM_COUNTER_COMPARE_A1,EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
    //	ñȽB1ֵCMPB1 = 5000
	EPWM_setCounterCompareValue_Extend(myEPWM3_BASE,EPWM_COUNTER_COMPARE_B1,5000);
    //	ñȽB1ļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPB1
	EPWM_setCounterCompareShadowLoadMode_Extend(myEPWM3_BASE,EPWM_COUNTER_COMPARE_B1,EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);


	//AQ
	//Aͨ
    //	Aͨ¼: TBCTR = Up_CMPA -> ePWM1AHIGH
	EPWM_setActionQualifierAction(myEPWM3_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    //	Aͨ¼: TBCTR = Down_CMPB -> ePWM1ALOW
	EPWM_setActionQualifierAction(myEPWM3_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
    //	Aͨ¼ӰӼģʽ -> Aͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM3_BASE,EPWM_ACTION_QUALIFIER_A);

	//Bͨ
    //	Bͨ¼: TBCTR = Up_CMPA1 -> ePWM1BHIGH
	EPWM_setActionQualifierAction(myEPWM3_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA1);
    //	Bͨ¼: TBCTR = Down_CMPB1 -> ePWM1BLOW
	EPWM_setActionQualifierAction(myEPWM3_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB1);
    //	Bͨ¼ӰӼģʽ -> Bͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM3_BASE,EPWM_ACTION_QUALIFIER_B);

}

