/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "load_img.h"
#include "fsmc.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */
volatile uint32_t dspTicks = 0;

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

extern void FFT_Init(void);
extern void EPWM_ADC_init(void);

extern volatile uint32_t adcTicks;
extern volatile uint32_t cntAdc;

extern volatile uint32_t adcStart;
//extern volatile uint32_t tickStart;
extern volatile uint32_t tickFFT;
extern volatile uint32_t tickDump;
extern volatile uint32_t cntFFT;

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

void ap_timer3_int_handler(void)
{
    adcStart = __RV_CSR_READ(CSR_MCYCLE);       //adc start from here

	CPUTimer_clearOverflowFlag(CPUTIMER3_BASE);
	dspTicks += 1;
}

int32_t ap_timer_init(uint32_t period)
{
	/* Initialize CPUTimer with interrupt enable */
	CPUTimer_init(CPUTIMER3_BASE, period);

	Interrupt_register(INT_TIMER3, ap_timer3_int_handler);
	Interrupt_enable(INT_TIMER3);
	return 0;
}

int main(void)
{
    uint32_t oldTicks;
    uint32_t tickCnt;

    __disable_irq();

    Device_init();

    UartPrint_init(LOG_SCI_BASE, 115200);

    log_set_level(LOG_DEBUG);

    log_info("Hello DSP FFT!\r\n");
    log_info("Core running @ %d MHz.\r\n", DEVICE_SYSCLK_FREQ / 1000000);
    log_info("Code @ 0x%08X, Data @ 0x%08X.\r\n", (uint32_t)main, (uint32_t)&oldTicks);

    ap_timer_init(DEVICE_APBCLK_FREQ/100);

	__enable_irq();

    DMA_initController(DMA_BASE);

    FFT_Init();
    EPWM_ADC_init();

    oldTicks = dspTicks;

    while(1) {
        if (oldTicks != dspTicks) {
            oldTicks = dspTicks;
            tickCnt += 1;

            if ((tickCnt % 100) == 0) {
                log_info("   ADC DMA reload cnt: %d\r\n", cntAdc);
                log_info(" ADC DMA ticks/reload: %d\r\n", adcTicks);
                log_info("         FFT calc cnt: %d\r\n", cntFFT);
                log_info("       FFT calc ticks: %d\r\n", tickFFT);
                log_info("FFT result dump ticks: %d\r\n\r\n", tickDump);
            }
        }
    }

    for(;;);

    return 0;
}

