/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "log.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/*
 * Define the select the example to compile in.
 * Only one example should be set as 1 the rest should be set as 0.
 */
#define EXAMPLE1 1 // Basic pinout configuration example
#define EXAMPLE2 0 // Communication pinout example

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

void Gpio_setup1(void);
void Gpio_setup2(void);

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/*
 * @brief  main function.
 */
int main(void)
{
    // Initialize the device
    Device_init();

#if EXAMPLE1
    //
    // This example is a basic pinout
    //
    Gpio_setup1();

#endif // - EXAMPLE1

#if EXAMPLE2
    //
    // This example is a communications pinout
    //
    Gpio_setup2();

#endif // - EXAMPLE2

    while (1) {
    }

    return 0;
}

//
// Gpio_setup1 - Basic pinout example
//
void Gpio_setup1(void)
{
    //
    // Example 1:
    // Basic Pinout.
    // This basic pinout includes:
    // PWM1-3, ECAP1, ECAP2, TZ1-TZ4, SPI-A, EQEP1, SCI-A, I2C
    // and a number of I/O pins
    //

    //
    // These can be combined into single statements for improved
    // code efficiency.
    //

    //
    // Enable PWM1-3 on GPIO0-GPIO5
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO0  = GPIO_PULL_ENABLE;              // Enable pullup on GPIO0
    GpioCtrlRegs.GPAPUD.bit.GPIO1  = GPIO_PULL_ENABLE;              // Enable pullup on GPIO1
    GpioCtrlRegs.GPAPUD.bit.GPIO2  = GPIO_PULL_ENABLE;              // Enable pullup on GPIO2
    GpioCtrlRegs.GPAPUD.bit.GPIO3  = GPIO_PULL_ENABLE;              // Enable pullup on GPIO3
    GpioCtrlRegs.GPAPUD.bit.GPIO4  = GPIO_PULL_ENABLE;              // Enable pullup on GPIO4
    GpioCtrlRegs.GPAPUD.bit.GPIO5  = GPIO_PULL_ENABLE;              // Enable pullup on GPIO5
    GpioCtrlRegs.GPAMUX1.bit.GPIO0 = GPIO_0_EPWM1A & GPIO_MUX_MASK; // GPIO0 = PWM1A
    GpioCtrlRegs.GPAMUX1.bit.GPIO1 = GPIO_1_EPWM1B & GPIO_MUX_MASK; // GPIO1 = PWM1B
    GpioCtrlRegs.GPAMUX1.bit.GPIO2 = GPIO_2_EPWM2A & GPIO_MUX_MASK; // GPIO2 = PWM2A
    GpioCtrlRegs.GPAMUX1.bit.GPIO3 = GPIO_3_EPWM2B & GPIO_MUX_MASK; // GPIO3 = PWM2B
    GpioCtrlRegs.GPAMUX1.bit.GPIO4 = GPIO_4_EPWM3A & GPIO_MUX_MASK; // GPIO4 = PWM3A
    GpioCtrlRegs.GPAMUX1.bit.GPIO5 = GPIO_5_EPWM3B & GPIO_MUX_MASK; // GPIO5 = PWM3B

    //
    // Enable an GPIO output on GPIO6, set it high
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO6  = GPIO_PULL_ENABLE;             // Enable pullup on GPIO6
    GpioDataRegs.GPASET.bit.GPIO6  = 0x1;                          // Load output latch
    GpioCtrlRegs.GPAMUX1.bit.GPIO6 = GPIO_6_GPIO6 & GPIO_MUX_MASK; // GPIO6 = GPIO6
    GpioCtrlRegs.GPADIR.bit.GPIO6  = GPIO_DIR_MODE_OUT;            // GPIO6 = output

    //
    // Enable an GPIO output on GPIO7, set it high
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO7   = GPIO_PULL_ENABLE;             // Enable pullup on GPIO7
    GpioCtrlRegs.GPAQSEL1.bit.GPIO7 = GPIO_QUAL_SYNC;               // Synch to SYSCLOUT
    GpioCtrlRegs.GPAMUX1.bit.GPIO7  = GPIO_7_GPIO7 & GPIO_MUX_MASK; // GPIO7 = GPIO7
    GpioCtrlRegs.GPADIR.bit.GPIO7   = GPIO_DIR_MODE_OUT;            // GPIO7 = output

    //
    // Enable GPIO outputs on GPIO8 - GPIO11, set it high
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO8  = GPIO_PULL_ENABLE;             // Enable pullup on GPIO8
    GpioDataRegs.GPASET.bit.GPIO8  = 0x1;                          // Load output latch
    GpioCtrlRegs.GPAMUX1.bit.GPIO8 = GPIO_8_GPIO8 & GPIO_MUX_MASK; // GPIO8 = GPIO8
    GpioCtrlRegs.GPADIR.bit.GPIO8  = GPIO_DIR_MODE_OUT;            // GPIO8 = output

    GpioCtrlRegs.GPAPUD.bit.GPIO9  = GPIO_PULL_ENABLE;             // Enable pullup on GPIO9
    GpioDataRegs.GPASET.bit.GPIO9  = 0x1;                          // Load output latch
    GpioCtrlRegs.GPAMUX1.bit.GPIO9 = GPIO_9_GPIO9 & GPIO_MUX_MASK; // GPIO9 = GPIO9
    GpioCtrlRegs.GPADIR.bit.GPIO9  = GPIO_DIR_MODE_OUT;            // GPIO9 = output

    GpioCtrlRegs.GPAPUD.bit.GPIO10  = GPIO_PULL_ENABLE;               // Enable pullup on GPIO10
    GpioDataRegs.GPASET.bit.GPIO10  = 0x1;                            // Load output latch
    GpioCtrlRegs.GPAMUX1.bit.GPIO10 = GPIO_10_GPIO10 & GPIO_MUX_MASK; // GPIO10 = GPIO10
    GpioCtrlRegs.GPADIR.bit.GPIO10  = GPIO_DIR_MODE_OUT;              // GPIO10 = output

    GpioCtrlRegs.GPAPUD.bit.GPIO11  = GPIO_PULL_ENABLE;               // Enable pullup on GPIO11
    GpioCtrlRegs.GPAMUX1.bit.GPIO11 = GPIO_11_GPIO11 & GPIO_MUX_MASK; // GPIO11 = GPIO11
    GpioCtrlRegs.GPADIR.bit.GPIO11  = GPIO_DIR_MODE_OUT;              // GPIO11 = output

    //
    // Enable Trip Zone inputs on GPIO12 - GPIO15
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO12   = GPIO_PULL_ENABLE;            // Enable pullup on GPIO12
    GpioCtrlRegs.GPAPUD.bit.GPIO13   = GPIO_PULL_ENABLE;            // Enable pullup on GPIO13
    GpioCtrlRegs.GPAPUD.bit.GPIO14   = GPIO_PULL_ENABLE;            // Enable pullup on GPIO14
    GpioCtrlRegs.GPAPUD.bit.GPIO15   = GPIO_PULL_ENABLE;            // Enable pullup on GPIO15
    GpioCtrlRegs.GPAQSEL1.bit.GPIO12 = GPIO_QUAL_ASYNC;             // asynch input
    GpioCtrlRegs.GPAQSEL1.bit.GPIO13 = GPIO_QUAL_ASYNC;             // asynch input
    GpioCtrlRegs.GPAQSEL1.bit.GPIO14 = GPIO_QUAL_ASYNC;             // asynch input
    GpioCtrlRegs.GPAQSEL1.bit.GPIO15 = GPIO_QUAL_ASYNC;             // asynch input
    GpioCtrlRegs.GPAMUX1.bit.GPIO12  = GPIO_12_TZ1 & GPIO_MUX_MASK; // GPIO12 = TZ1
    GpioCtrlRegs.GPAMUX1.bit.GPIO13  = GPIO_13_TZ2 & GPIO_MUX_MASK; // GPIO13 = TZ2
    GpioCtrlRegs.GPAMUX1.bit.GPIO14  = GPIO_14_TZ3 & GPIO_MUX_MASK; // GPIO14 = TZ3
    GpioCtrlRegs.GPAMUX1.bit.GPIO15  = GPIO_15_TZ1 & GPIO_MUX_MASK; // GPIO15 = TZ1

    //
    // Enable SPI-A on GPIO16 - GPIO19
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO16   = GPIO_PULL_ENABLE;                 // Enable pullup on GPIO16
    GpioCtrlRegs.GPAPUD.bit.GPIO17   = GPIO_PULL_ENABLE;                 // Enable pullup on GPIO17
    GpioCtrlRegs.GPAPUD.bit.GPIO18   = GPIO_PULL_ENABLE;                 // Enable pullup on GPIO18
    GpioCtrlRegs.GPAPUD.bit.GPIO19   = GPIO_PULL_ENABLE;                 // Enable pullup on GPIO19
    GpioCtrlRegs.GPAQSEL2.bit.GPIO16 = GPIO_QUAL_ASYNC;                  // asynch input
    GpioCtrlRegs.GPAQSEL2.bit.GPIO17 = GPIO_QUAL_ASYNC;                  // asynch input
    GpioCtrlRegs.GPAQSEL2.bit.GPIO18 = GPIO_QUAL_ASYNC;                  // asynch input
    GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = GPIO_QUAL_ASYNC;                  // asynch input
    GpioCtrlRegs.GPAMUX2.bit.GPIO16  = GPIO_16_SPIA_SIMO & GPIO_MUX_MASK; // GPIO16 = SPISIMOA
    GpioCtrlRegs.GPAMUX2.bit.GPIO17  = GPIO_17_SPIA_SOMI & GPIO_MUX_MASK; // GPIO17 = SPIS0MIA
    GpioCtrlRegs.GPAMUX2.bit.GPIO18  = GPIO_18_SPIA_CLK & GPIO_MUX_MASK;  // GPIO18 = SPICLKA
    GpioCtrlRegs.GPAMUX2.bit.GPIO19  = GPIO_19_SPIA_STEn & GPIO_MUX_MASK;  // GPIO19 = SPISTEA

    //
    // Enable EQEP1 on GPIO20 - GPIO23
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO20   = GPIO_PULL_ENABLE;               // Enable pullup on GPIO20
    GpioCtrlRegs.GPAPUD.bit.GPIO21   = GPIO_PULL_ENABLE;               // Enable pullup on GPIO21
    GpioCtrlRegs.GPAPUD.bit.GPIO22   = GPIO_PULL_ENABLE;               // Enable pullup on GPIO22
    GpioCtrlRegs.GPAPUD.bit.GPIO23   = GPIO_PULL_ENABLE;               // Enable pullup on GPIO23
    GpioCtrlRegs.GPAQSEL2.bit.GPIO20 = GPIO_QUAL_SYNC;                 // Synch to SYSCLKOUT
    GpioCtrlRegs.GPAQSEL2.bit.GPIO21 = GPIO_QUAL_SYNC;                 // Synch to SYSCLKOUT
    GpioCtrlRegs.GPAQSEL2.bit.GPIO22 = GPIO_QUAL_SYNC;                 // Synch to SYSCLKOUT
    GpioCtrlRegs.GPAQSEL2.bit.GPIO23 = GPIO_QUAL_SYNC;                 // Synch to SYSCLKOUT
    GpioCtrlRegs.GPAMUX2.bit.GPIO20  = GPIO_20_EQEP1A & GPIO_MUX_MASK; // GPIO20 = EQEP1A
    GpioCtrlRegs.GPAMUX2.bit.GPIO21  = GPIO_21_EQEP1B & GPIO_MUX_MASK; // GPIO21 = EQEP1B
    GpioCtrlRegs.GPAMUX2.bit.GPIO22  = GPIO_22_EQEP1S & GPIO_MUX_MASK; // GPIO22 = EQEP1S
    GpioCtrlRegs.GPAMUX2.bit.GPIO23  = GPIO_23_EQEP1I & GPIO_MUX_MASK; // GPIO23 = EQEP1I

    //
    // Enable eCAP1 on GPIO24
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO24   = GPIO_PULL_ENABLE;              // Enable pullup on GPIO24
    GpioCtrlRegs.GPAQSEL2.bit.GPIO24 = GPIO_QUAL_SYNC;                // Synch to SYSCLKOUT
    GpioCtrlRegs.GPAMUX2.bit.GPIO24  = GPIO_24_ECAP1 & GPIO_MUX_MASK; // GPIO24 = ECAP1

    //
    // Set input qualification period for GPIO25 & GPIO26
    //
    GpioCtrlRegs.GPACTRL.all          = 0x1000000;         // QUALPRD3 = SYSCLKOUT/2
    GpioCtrlRegs.GPAQSEL2.bit.GPIO25  = GPIO_QUAL_6SAMPLE; // 6 samples
    GpioCtrlRegs.GPAQSEL2.bit.GPIO26  = GPIO_QUAL_6SAMPLE; // 6 samples

    //
    // Make GPIO25 the input source for XINT1
    //
    GpioCtrlRegs.GPAMUX2.bit.GPIO25 = GPIO_25_GPIO25 & GPIO_MUX_MASK; // GPIO25 = GPIO25
    GpioCtrlRegs.GPADIR.bit.GPIO25  = GPIO_DIR_MODE_IN;               // GPIO25 = input
    GpioIntRegs.GPIOXINT1SEL.all    = 25;                             // XINT1 connected to GPIO25

    //
    // Make GPIO26 the input source for XINT2
    //
    GpioCtrlRegs.GPAMUX2.bit.GPIO26 = GPIO_26_GPIO26 & GPIO_MUX_MASK; // GPIO26 = GPIO26
    GpioCtrlRegs.GPADIR.bit.GPIO26  = GPIO_DIR_MODE_IN;               // GPIO26 = input
    GpioIntRegs.GPIOXINT2SEL.all    = 26;                             // XINT2 connected to GPIO26

    //
    // Enable SCI-A on GPIO28 - GPIO29
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO28   = GPIO_PULL_ENABLE;                // Enable pullup on GPIO28
    GpioCtrlRegs.GPAQSEL2.bit.GPIO28 = GPIO_QUAL_ASYNC;                 // asynch input
    GpioCtrlRegs.GPAMUX2.bit.GPIO28  = GPIO_28_SCIA_RX & GPIO_MUX_MASK; // GPIO28 = SCIRXDA
    GpioCtrlRegs.GPAPUD.bit.GPIO29   = GPIO_PULL_ENABLE;                // Enable pullup on GPIO29
    GpioCtrlRegs.GPAMUX2.bit.GPIO29  = GPIO_29_SCIA_TX & GPIO_MUX_MASK; // GPIO29 = SCITXDA

    //
    // Enable CAN-A on GPIO30 - GPIO31
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO30   = GPIO_PULL_ENABLE;               // Enable pullup on GPIO30
    GpioCtrlRegs.GPAQSEL2.bit.GPIO30 = GPIO_QUAL_ASYNC;                // asynch input
    GpioCtrlRegs.GPAMUX2.bit.GPIO30  = GPIO_30_CANA_RX & GPIO_MUX_MASK; // GPIO30 = CANRXA
    GpioCtrlRegs.GPAPUD.bit.GPIO31   = GPIO_PULL_ENABLE;               // Enable pullup on GPIO31
    GpioCtrlRegs.GPAMUX2.bit.GPIO31  = GPIO_31_CANA_TX & GPIO_MUX_MASK; // GPIO31 = CANTXA

    //
    // Enable I2C-A on GPIO32 - GPIO33
    //
    GpioCtrlRegs.GPBPUD.bit.GPIO32   = GPIO_PULL_ENABLE;             // Enable pullup on GPIO32
    GpioCtrlRegs.GPBMUX1.bit.GPIO32  = GPIO_32_I2CA_SDA & GPIO_MUX_MASK; // GPIO32 = SDAA
    GpioCtrlRegs.GPBQSEL1.bit.GPIO33 = GPIO_QUAL_ASYNC;              // asynch input
    GpioCtrlRegs.GPBPUD.bit.GPIO33   = GPIO_PULL_ENABLE;             // Enable pullup on GPIO33
    GpioCtrlRegs.GPBQSEL1.bit.GPIO33 = GPIO_QUAL_ASYNC;              // asynch input
    GpioCtrlRegs.GPBMUX1.bit.GPIO33  = GPIO_33_I2CA_SCL & GPIO_MUX_MASK; // GPIO33 = SCLA

    //
    // Make GPIO34 an input
    //
    GpioCtrlRegs.GPBPUD.bit.GPIO34  = GPIO_PULL_ENABLE;               // Enable pullup on GPIO34
    GpioCtrlRegs.GPBMUX1.bit.GPIO34 = GPIO_34_GPIO34 & GPIO_MUX_MASK; // GPIO34 = GPIO34
    GpioCtrlRegs.GPBDIR.bit.GPIO34  = GPIO_DIR_MODE_IN;               // GPIO34 = inpu
}

//
// Gpio_setup2 - Communication pinout example
//
void Gpio_setup2(void)
{
    //
    // Example 1:
    // Communications Pinout.
    // This basic communications pinout includes:
    // PWM1-3, CAP1, CAP2, SPI-A, SPI-B, CAN-A, SCI-A and I2C
    // and a number of I/O pins
    //

    //
    // Enable PWM1-3 on GPIO0-GPIO5
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO0  = GPIO_PULL_ENABLE;              // Enable pullup on GPIO0
    GpioCtrlRegs.GPAPUD.bit.GPIO1  = GPIO_PULL_ENABLE;              // Enable pullup on GPIO1
    GpioCtrlRegs.GPAPUD.bit.GPIO2  = GPIO_PULL_ENABLE;              // Enable pullup on GPIO2
    GpioCtrlRegs.GPAPUD.bit.GPIO3  = GPIO_PULL_ENABLE;              // Enable pullup on GPIO3
    GpioCtrlRegs.GPAPUD.bit.GPIO4  = GPIO_PULL_ENABLE;              // Enable pullup on GPIO4
    GpioCtrlRegs.GPAPUD.bit.GPIO5  = GPIO_PULL_ENABLE;              // Enable pullup on GPIO5
    GpioCtrlRegs.GPAMUX1.bit.GPIO0 = GPIO_0_EPWM1A & GPIO_MUX_MASK; // GPIO0 = PWM1A
    GpioCtrlRegs.GPAMUX1.bit.GPIO1 = GPIO_1_EPWM1B & GPIO_MUX_MASK; // GPIO1 = PWM1B
    GpioCtrlRegs.GPAMUX1.bit.GPIO2 = GPIO_2_EPWM2A & GPIO_MUX_MASK; // GPIO2 = PWM2A
    GpioCtrlRegs.GPAMUX1.bit.GPIO3 = GPIO_3_EPWM2B & GPIO_MUX_MASK; // GPIO3 = PWM2B
    GpioCtrlRegs.GPAMUX1.bit.GPIO4 = GPIO_4_EPWM3A & GPIO_MUX_MASK; // GPIO4 = PWM3A
    GpioCtrlRegs.GPAMUX1.bit.GPIO5 = GPIO_5_EPWM3B & GPIO_MUX_MASK; // GPIO5 = PWM3B

    //
    // Enable an GPIO output on GPIO6
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO6  = GPIO_PULL_ENABLE;             // Enable pullup on GPIO6
    GpioDataRegs.GPASET.bit.GPIO6  = 0x1;                          // Load output latch
    GpioCtrlRegs.GPAMUX1.bit.GPIO6 = GPIO_6_GPIO6 & GPIO_MUX_MASK; // GPIO6 = GPIO6
    GpioCtrlRegs.GPADIR.bit.GPIO6  = GPIO_DIR_MODE_OUT;            // GPIO6 = output

    //
    // Enable GPIO outputs on GPIO8 - GPIO11
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO8  = GPIO_PULL_ENABLE;             // Enable pullup on GPIO8
    GpioDataRegs.GPASET.bit.GPIO8  = 0x1;                          // Load output latch
    GpioCtrlRegs.GPAMUX1.bit.GPIO8 = GPIO_8_GPIO8 & GPIO_MUX_MASK; // GPIO8 = GPIO8
    GpioCtrlRegs.GPADIR.bit.GPIO8  = GPIO_DIR_MODE_OUT;            // GPIO8 = output

    GpioCtrlRegs.GPAPUD.bit.GPIO9  = GPIO_PULL_ENABLE;             // Enable pullup on GPIO9
    GpioDataRegs.GPASET.bit.GPIO9  = 0x1;                          // Load output latch
    GpioCtrlRegs.GPAMUX1.bit.GPIO9 = GPIO_9_GPIO9 & GPIO_MUX_MASK; // GPIO9 = GPIO9
    GpioCtrlRegs.GPADIR.bit.GPIO9  = GPIO_DIR_MODE_OUT;            // GPIO9 = output

    GpioCtrlRegs.GPAPUD.bit.GPIO10  = GPIO_PULL_ENABLE;               // Enable pullup on GPIO10
    GpioDataRegs.GPASET.bit.GPIO10  = 0x1;                            // Load output latch
    GpioCtrlRegs.GPAMUX1.bit.GPIO10 = GPIO_10_GPIO10 & GPIO_MUX_MASK; // GPIO10 = GPIO10
    GpioCtrlRegs.GPADIR.bit.GPIO10  = GPIO_DIR_MODE_OUT;              // GPIO10 = output

    GpioCtrlRegs.GPAPUD.bit.GPIO11  = GPIO_PULL_ENABLE;               // Enable pullup on GPIO11
    GpioDataRegs.GPASET.bit.GPIO11  = 0x1;                            // Load output latch
    GpioCtrlRegs.GPAMUX1.bit.GPIO11 = GPIO_11_GPIO11 & GPIO_MUX_MASK; // GPIO11 = GPIO11
    GpioCtrlRegs.GPADIR.bit.GPIO11  = GPIO_DIR_MODE_OUT;              // GPIO11 = output

    //
    // Enable SPI-B on GPIO12 - GPIO15
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO12   = GPIO_PULL_ENABLE;                 // Enable pullup on GPIO12 (SPISIMOB)
    GpioCtrlRegs.GPAPUD.bit.GPIO12   = GPIO_PULL_ENABLE;                 // Enable pullup on GPIO13 (SPISOMIB)
    GpioCtrlRegs.GPAPUD.bit.GPIO14   = GPIO_PULL_ENABLE;                 // Enable pullup on GPIO14 (SPICLKB)
    GpioCtrlRegs.GPAPUD.bit.GPIO15   = GPIO_PULL_ENABLE;                 // Enable pullup on GPIO15 (SPISTEB)
    GpioCtrlRegs.GPAQSEL1.bit.GPIO12 = GPIO_QUAL_ASYNC;                  // asynch input
    GpioCtrlRegs.GPAQSEL1.bit.GPIO13 = GPIO_QUAL_ASYNC;                  // asynch input
    GpioCtrlRegs.GPAQSEL1.bit.GPIO14 = GPIO_QUAL_ASYNC;                  // asynch input
    GpioCtrlRegs.GPAQSEL1.bit.GPIO15 = GPIO_QUAL_ASYNC;                  // asynch input
    GpioCtrlRegs.GPAMUX1.bit.GPIO12  = GPIO_12_SPIB_SIMO & GPIO_MUX_MASK; // GPIO12 = SPISIMOB
    GpioCtrlRegs.GPAMUX1.bit.GPIO13  = GPIO_13_SPIB_SOMI & GPIO_MUX_MASK; // GPIO13 = SPISOMIB
    GpioCtrlRegs.GPAMUX1.bit.GPIO14  = GPIO_14_SPIB_CLK & GPIO_MUX_MASK;  // GPIO14 = SPICLKB
    GpioCtrlRegs.GPAMUX1.bit.GPIO15  = GPIO_15_SPIB_STEn & GPIO_MUX_MASK;  // GPIO15 = SPISTEB

    //
    // Enable SPI-A on GPIO16 - GPIO19
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO16   = GPIO_PULL_ENABLE;                 // Enable pullup on GPIO16 (SPICLKA)
    GpioCtrlRegs.GPAPUD.bit.GPIO17   = GPIO_PULL_ENABLE;                 // Enable pullup on GPIO17 (SPIS0MIA)
    GpioCtrlRegs.GPAPUD.bit.GPIO18   = GPIO_PULL_ENABLE;                 // Enable pullup on GPIO18 (SPICLKA)
    GpioCtrlRegs.GPAPUD.bit.GPIO19   = GPIO_PULL_ENABLE;                 // Enable pullup on GPIO19 (SPISTEA)
    GpioCtrlRegs.GPAQSEL2.bit.GPIO16 = GPIO_QUAL_ASYNC;                  // asynch input
    GpioCtrlRegs.GPAQSEL2.bit.GPIO17 = GPIO_QUAL_ASYNC;                  // asynch input
    GpioCtrlRegs.GPAQSEL2.bit.GPIO18 = GPIO_QUAL_ASYNC;                  // asynch input
    GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = GPIO_QUAL_ASYNC;                  // asynch input
    GpioCtrlRegs.GPAMUX2.bit.GPIO16  = GPIO_16_SPIA_SIMO & GPIO_MUX_MASK; // GPIO16 = SPISIMOA
    GpioCtrlRegs.GPAMUX2.bit.GPIO17  = GPIO_17_SPIA_SOMI & GPIO_MUX_MASK; // GPIO17 = SPIS0MIA
    GpioCtrlRegs.GPAMUX2.bit.GPIO18  = GPIO_18_SPIA_CLK & GPIO_MUX_MASK;  // GPIO18 = SPICLKA
    GpioCtrlRegs.GPAMUX2.bit.GPIO19  = GPIO_19_SPIA_STEn & GPIO_MUX_MASK;  // GPIO19 = SPISTEA

    //
    // Enable EQEP1 on GPIO20 - GPIO23
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO20   = GPIO_PULL_ENABLE;               // Enable pullup on GPIO20 (EQEP1A)
    GpioCtrlRegs.GPAPUD.bit.GPIO21   = GPIO_PULL_ENABLE;               // Enable pullup on GPIO21 (EQEP1B)
    GpioCtrlRegs.GPAPUD.bit.GPIO22   = GPIO_PULL_ENABLE;               // Enable pullup on GPIO22 (EQEP1S)
    GpioCtrlRegs.GPAPUD.bit.GPIO23   = GPIO_PULL_ENABLE;               // Enable pullup on GPIO23 (EQEP1I)
    GpioCtrlRegs.GPAQSEL2.bit.GPIO20 = GPIO_QUAL_SYNC;                 // Synch to SYSCLKOUT
    GpioCtrlRegs.GPAQSEL2.bit.GPIO21 = GPIO_QUAL_SYNC;                 // Synch to SYSCLKOUT
    GpioCtrlRegs.GPAQSEL2.bit.GPIO22 = GPIO_QUAL_SYNC;                 // Synch to SYSCLKOUT
    GpioCtrlRegs.GPAQSEL2.bit.GPIO23 = GPIO_QUAL_SYNC;                 // Synch to SYSCLKOUT
    GpioCtrlRegs.GPAMUX2.bit.GPIO20  = GPIO_20_EQEP1A & GPIO_MUX_MASK; // GPIO20 = EQEP1A
    GpioCtrlRegs.GPAMUX2.bit.GPIO21  = GPIO_21_EQEP1B & GPIO_MUX_MASK; // GPIO21 = EQEP1B
    GpioCtrlRegs.GPAMUX2.bit.GPIO22  = GPIO_22_EQEP1S & GPIO_MUX_MASK; // GPIO22 = EQEP1S
    GpioCtrlRegs.GPAMUX2.bit.GPIO23  = GPIO_23_EQEP1I & GPIO_MUX_MASK; // GPIO23 = EQEP1I

    //
    // Enable eCAP1 on GPIO24
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO24   = GPIO_PULL_ENABLE;              // Enable pullup on GPIO24 (ECAP1)
    GpioCtrlRegs.GPAQSEL2.bit.GPIO24 = GPIO_QUAL_SYNC;                // Synch to SYSCLKOUT
    GpioCtrlRegs.GPAMUX2.bit.GPIO24  = GPIO_24_ECAP1 & GPIO_MUX_MASK; // GPIO24 = ECAP1

    //
    // Set input qualification period for GPIO25 & GPIO26 inputs
    //
    GpioCtrlRegs.GPACTRL.all          = 0x1000000;         // QUALPRD3 = SYSCLKOUT/2
    GpioCtrlRegs.GPAQSEL2.bit.GPIO25  = GPIO_QUAL_6SAMPLE; // 6 samples
    GpioCtrlRegs.GPAQSEL2.bit.GPIO26  = GPIO_QUAL_3SAMPLE; // 3 samples

    //
    // Make GPIO25 the input source for XINT1
    //
    GpioCtrlRegs.GPAMUX2.bit.GPIO25 = GPIO_25_GPIO25 & GPIO_MUX_MASK; // GPIO25 = GPIO25
    GpioCtrlRegs.GPADIR.bit.GPIO25  = GPIO_DIR_MODE_IN;               // GPIO25 = input
    GpioIntRegs.GPIOXINT1SEL.all    = 25;                             // XINT1 connected to GPIO25

    //
    // Make GPIO26 the input source for XINT2
    //
    GpioCtrlRegs.GPAMUX2.bit.GPIO26 = GPIO_26_GPIO26 & GPIO_MUX_MASK; // GPIO26 = GPIO26
    GpioCtrlRegs.GPADIR.bit.GPIO26  = GPIO_DIR_MODE_IN;               // GPIO26 = input
    GpioIntRegs.GPIOXINT2SEL.all    = 26;                             // XINT2 connected to GPIO26

    //
    // Enable SCI-A on GPIO28 - GPIO29
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO28   = GPIO_PULL_ENABLE;                // Enable pullup on GPIO28
    GpioCtrlRegs.GPAQSEL2.bit.GPIO28 = GPIO_QUAL_ASYNC;                 // asynch input
    GpioCtrlRegs.GPAMUX2.bit.GPIO28  = GPIO_28_SCIA_RX & GPIO_MUX_MASK; // GPIO28 = SCIRXDA
    GpioCtrlRegs.GPAPUD.bit.GPIO29   = GPIO_PULL_ENABLE;                // Enable pullup on GPIO29
    GpioCtrlRegs.GPAMUX2.bit.GPIO29  = GPIO_29_SCIA_TX & GPIO_MUX_MASK; // GPIO29 = SCITXDA

    //
    // Enable CAN-A on GPIO30 - GPIO31
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO30   = GPIO_PULL_ENABLE;               // Enable pullup on GPIO30
    GpioCtrlRegs.GPAQSEL2.bit.GPIO30 = GPIO_QUAL_ASYNC;                // asynch input
    GpioCtrlRegs.GPAMUX2.bit.GPIO30  = GPIO_30_CANA_RX & GPIO_MUX_MASK; // GPIO30 = CANRXA
    GpioCtrlRegs.GPAPUD.bit.GPIO31   = GPIO_PULL_ENABLE;               // Enable pullup on GPIO31
    GpioCtrlRegs.GPAMUX2.bit.GPIO31  = GPIO_31_CANA_TX & GPIO_MUX_MASK; // GPIO31 = CANTXA

    //
    // Enable I2C-A on GPIO32 - GPIO33
    //
    GpioCtrlRegs.GPBPUD.bit.GPIO32   = GPIO_PULL_ENABLE;             // Enable pullup on GPIO32
    GpioCtrlRegs.GPBPUD.bit.GPIO33   = GPIO_PULL_ENABLE;             // Enable pullup on GPIO33
    GpioCtrlRegs.GPBQSEL1.bit.GPIO32 = GPIO_QUAL_ASYNC;              // asynch input
    GpioCtrlRegs.GPBQSEL1.bit.GPIO32 = GPIO_QUAL_ASYNC;              // asynch input
    GpioCtrlRegs.GPBMUX1.bit.GPIO32  = GPIO_32_I2CA_SDA & GPIO_MUX_MASK; // GPIO32 = SDAA
    GpioCtrlRegs.GPBMUX1.bit.GPIO33  = GPIO_33_I2CA_SCL & GPIO_MUX_MASK; // GPIO33 = SCLA

    //
    // Make GPIO34 an input
    //
    GpioCtrlRegs.GPBPUD.bit.GPIO32  = GPIO_PULL_ENABLE;               // Enable pullup on GPIO34
    GpioCtrlRegs.GPBMUX1.bit.GPIO34 = GPIO_34_GPIO34 & GPIO_MUX_MASK; // GPIO34 = GPIO34
    GpioCtrlRegs.GPBDIR.bit.GPIO34  = GPIO_DIR_MODE_IN;               // GPIO34 = input
}
