/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "hrpwm_ex01_board.h"
#include "SFO_v2.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define AUTO 0


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */



/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

volatile uint32_t pwm_base[18] =
    {myEPWM1_BASE, myEPWM2_BASE, myEPWM3_BASE, myEPWM4_BASE, myEPWM5_BASE, myEPWM6_BASE, myEPWM7_BASE, myEPWM8_BASE,\
    myEPWM9_BASE, myEPWM10_BASE, myEPWM11_BASE, myEPWM12_BASE, myEPWM13_BASE, myEPWM14_BASE, myEPWM15_BASE, myEPWM16_BASE,\
	myEPWM17_BASE, myEPWM18_BASE};
SFO_Params_t SFO_ParamsStruct;
uint16_t status;
/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules. 
// Call this function in your application if you wish to do all module 
// initialization.
// If you wish to not use some of the initializations, instead of the 
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
	EALLOW;

	PinMux_init();

	for(int i = 0;i < 18;i++)
	{
		EPWM_init( pwm_base[i]);
	}

  //HRPWMͨΪռձ50.55%
	for(int i = 0;i < 18;i++)
	{
#if(AUTO == 1)
		HRPWM_Update_HrDuty_Auto(pwm_base[i], 100, 0.5055, HRPWM_COUNTER_COMPARE_A);
		HRPWM_Update_HrDuty_Auto(pwm_base[i], 100, 0.5055, HRPWM_COUNTER_COMPARE_B);
#elif(AUOT == 0)
		HRPWM_Update_HrDuty_Manual(pwm_base[i], 100, 0.5080, HRPWM_COUNTER_COMPARE_A);
		HRPWM_Update_HrDuty_Manual(pwm_base[i], 100, 0.5080, HRPWM_COUNTER_COMPARE_B);
#endif
	}
	EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{ 
	//
	// PinMux for modules assigned to CPU1
	//
	
	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM2 -> myEPWM2 Pinmux
	//
	GPIO_setPinConfig(myEPWM2_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM2_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM2_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM2_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM2_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM2_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM3 -> myEPWM3 Pinmux
	//
	GPIO_setPinConfig(myEPWM3_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM3_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM3_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM3_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM3_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM3_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM4 -> myEPWM4 Pinmux
	//
	GPIO_setPinConfig(myEPWM4_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM4_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM4_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM4_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM4_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM4_EPWMB_GPIO, GPIO_QUAL_SYNC);


	//
	// EPWM5
	//
	GPIO_setPinConfig(myEPWM5_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM5_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM5_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM5_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM5_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM5_EPWMB_GPIO, GPIO_QUAL_SYNC);


	//
	// EPWM6 -> myEPWM6 Pinmux
	//
	GPIO_setPinConfig(myEPWM6_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM6_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM6_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM6_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM6_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM6_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
    // EPWM7
	//
    GPIO_setPinConfig(myEPWM7_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM7_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM7_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM7_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM7_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM7_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM8
    //
	GPIO_setPinConfig(myEPWM8_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM8_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM8_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM8_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM8_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM8_EPWMB_GPIO, GPIO_QUAL_SYNC);





	//
	// EPWM9
	//
	GPIO_setPinConfig(myEPWM9_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM9_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM9_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM9_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM9_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM9_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM9
	//
	GPIO_setPinConfig(myEPWM9_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM9_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM9_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM9_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM9_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM9_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM10
	//
	GPIO_setPinConfig(myEPWM10_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM10_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM10_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM10_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM10_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM10_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM11
	//
	GPIO_setPinConfig(myEPWM11_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM11_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM11_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM11_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM11_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM11_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM12
	//
	GPIO_setPinConfig(myEPWM12_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM12_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM12_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM12_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM12_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM12_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM13
	//
	GPIO_setPinConfig(myEPWM13_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM13_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM13_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM13_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM13_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM13_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM14
	//
	GPIO_setPinConfig(myEPWM14_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM14_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM14_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM14_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM14_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM14_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM15
	//
	GPIO_setPinConfig(myEPWM15_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM15_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM15_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM15_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM15_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM15_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM16
	//
	GPIO_setPinConfig(myEPWM16_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM16_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM16_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM16_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM16_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM16_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM17
	//
	GPIO_setPinConfig(myEPWM17_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM17_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM17_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM17_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM17_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM17_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM18
	//
	GPIO_setPinConfig(myEPWM18_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM18_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM18_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM18_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM18_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM18_EPWMB_GPIO, GPIO_QUAL_SYNC);

}

//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
void EPWM_init(uint32_t base){
	HRPWM_setClockPrescaler(base, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	EPWM_setTimeBasePeriod(base, 99);
	HRPWM_setTimeBaseCounter(base, 0);
	HRPWM_setTimeBaseCounterMode(base, EPWM_COUNTER_MODE_UP);
	EPWM_disablePhaseShiftLoad(base);
	EPWM_setPhaseShift(base, 0);
	EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, 50);
	HRPWM_setCounterCompareShadowLoadMode(base, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
	EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_B, 50);
	HRPWM_setCounterCompareShadowLoadMode(base, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);

	HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_LOAD_ON_CNTR_ZERO);
	HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
	HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_LOAD_ON_CNTR_ZERO);
	//debugͣʱPWM
	EPWM_setEmulationMode(base, 2);


#if (AUTO == 1)
	HRPWM_enableAutoConversion(base);
#elif(AUTO == 0)
	HRPWM_disableAutoConversion(base);
#endif

	HRPWM_enableCalibration(base);
	HRPWM_setMEPEdgeSelect(base, HRPWM_CHANNEL_A, HRPWM_MEP_CTRL_FALLING_EDGE);
	HRPWM_setCounterCompareShadowLoadEvent(base, HRPWM_CHANNEL_A, HRPWM_LOAD_ON_CNTR_ZERO_PERIOD);
    HRPWM_setMEPEdgeSelect(base, HRPWM_CHANNEL_B, HRPWM_MEP_CTRL_FALLING_EDGE);
    HRPWM_setCounterCompareShadowLoadEvent(base, HRPWM_CHANNEL_B, HRPWM_LOAD_ON_CNTR_ZERO_PERIOD);



	/*--SFO ṹ0--*/
	SFO_Struct_deinit(&SFO_ParamsStruct);
	/*--SFO ṹ帳ֵloop_cntƼ4~5--*/
	SFO_Struct_init(&SFO_ParamsStruct,5);

	status = SFO(&SFO_ParamsStruct);
	//һУ׼
    if (status !=0)
    {
//    	error();
    }



}



/*HRPWMautoconvʹô˺ȥCMPֺС
 * base:EPWMַ
 * period:EPWMֵ
 * cmpareҪõCMPHR,HRPWM_COUNTER_COMPARE_A / HRPWM_COUNTER_COMPARE_B
 */
void HRPWM_Update_HrDuty_Auto(uint32_t base,uint32_t period,float32_t duty,HRPWM_CounterCompareModule cmpare)
{
	uint32_t cmp_set = 0;
	/*Сֿ*/
	//CMPHR = frac(duty*period) * 256 +0.5 СֵļԼֵ
	cmp_set =( (duty*period- (uint32_t)(duty*period)) *256) + 0.5;
	//ֵļԼֵ
	cmp_set += (uint32_t)(duty*period)<<8;

	/*Сһ
	 * 	cmp_set = duty*period*256;
	 * */



	if(cmpare){
		HRPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_B,cmp_set);
	}
	else{
		HRPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_A,cmp_set);
	}
}


/*δHRPWMautoconvʹô˺ȥCMPֺС
 * base:EPWMַ
 * period:EPWMֵ
 * cmpareҪõCMPHR,HRPWM_COUNTER_COMPARE_A / HRPWM_COUNTER_COMPARE_B
 */
void HRPWM_Update_HrDuty_Manual(uint32_t base,uint32_t period,float32_t duty,HRPWM_CounterCompareModule cmpare)
{
	uint32_t cmp_set = 0;

	//CMPHR = frac(duty*period) * hrstep +0.5
	cmp_set =  (duty*period - (uint32_t)(duty*period)) * SFO_ParamsStruct.HR_mstep+0.5;
	if(cmpare){
//		HRPWM_setCmpHRINT(base,cmp_set,SFO_ParamsStruct.HR_mstep,HRPWM_COUNTER_COMPARE_B);
		cmp_set += (uint32_t)(duty*period)<<8;
		HRPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_B,cmp_set);
	}
	else{
//		HRPWM_setCmpHRINT(base,cmp_set,SFO_ParamsStruct.HR_mstep,HRPWM_CHANNEL_A);
		cmp_set += (uint32_t)(duty*period)<<8;
		HRPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_A,cmp_set);
	}
}




#ifdef __cplusplus

#endif

