/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "hrpwm_ex02_board.h"
#include "SFO_v2.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */



/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

volatile uint32_t pwm_base[] =
    {myEPWM1_BASE, myEPWM2_BASE, myEPWM3_BASE, myEPWM4_BASE, myEPWM5_BASE, myEPWM6_BASE, myEPWM7_BASE, myEPWM8_BASE,\
    myEPWM9_BASE, myEPWM10_BASE, myEPWM11_BASE, myEPWM12_BASE, myEPWM13_BASE, myEPWM14_BASE, myEPWM15_BASE, myEPWM16_BASE,\
	myEPWM17_BASE, myEPWM18_BASE};

SFO_Params_t SFO_ParamsStruct;
uint16_t status;
/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules. 
// Call this function in your application if you wish to do all module 
// initialization.
// If you wish to not use some of the initializations, instead of the 
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
	EALLOW;

	PinMux_init();

	InitTimerModule();
	EPWM_init();

	EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{
	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);


	//
	// EPWM9
	//
	GPIO_setPinConfig(myEPWM9_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM9_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM9_EPWMA_GPIO, GPIO_QUAL_SYNC);

}


//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
void EPWM_init(){

	//PWM1A ߾
#if(PWM1A_HR == 1)
	{
		HRPWM_setClockPrescaler(EPWM1_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
		EPWM_setTimeBasePeriod(EPWM1_BASE, 999);
		HRPWM_setTimeBaseCounter(EPWM1_BASE, 0);
		HRPWM_setTimeBaseCounterMode(EPWM1_BASE, EPWM_COUNTER_MODE_UP);
		EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, 0);
		EPWM_setCounterCompareShadowLoadMode(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
		HRPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		HRPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);

		//debugͣʱPWM
		EPWM_setEmulationMode(EPWM1_BASE, 2);

		EPWM_setRisingEdgeDeadBandDelayInput(EPWM1_BASE,EPWM_DB_INPUT_EPWMA);
		EPWM_setRisingEdgeDelayCount(EPWM1_BASE,50);
		EPWM_setDeadBandDelayMode(EPWM1_BASE,EPWM_DB_RED,TRUE);


		HRPWM_setClockPrescaler(EPWM9_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
		EPWM_setTimeBasePeriod(EPWM9_BASE, 999);
		HRPWM_setTimeBaseCounter(EPWM9_BASE, 0);
		HRPWM_setTimeBaseCounterMode(EPWM9_BASE, EPWM_COUNTER_MODE_UP);
		EPWM_setCounterCompareValue(EPWM9_BASE, EPWM_COUNTER_COMPARE_A, 0);
		EPWM_setCounterCompareShadowLoadMode(EPWM9_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
		HRPWM_setActionQualifierAction(EPWM9_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		HRPWM_setActionQualifierAction(EPWM9_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);

		EPWM_setFallingEdgeDeadBandDelayInput(EPWM9_BASE,EPWM_DB_INPUT_EPWMA);
		EPWM_setFallingEdgeDelayCount(EPWM9_BASE,50);
		EPWM_setDeadBandDelayMode(EPWM9_BASE,EPWM_DB_FED,TRUE);
		EPWM_setDeadBandDelayPolarity(EPWM9_BASE,EPWM_DB_FED,EPWM_DB_POLARITY_ACTIVE_LOW);
		EPWM_setDeadBandOutputSwapMode(EPWM9_BASE,EPWM_DB_OUTPUT_A,TRUE);
		//debugͣʱPWM
		EPWM_setEmulationMode(EPWM9_BASE, 2);

		if(AUTO == 1){
			HRPWM_enableAutoConversion(EPWM1_BASE);
		}
		else{
			HRPWM_disableAutoConversion(EPWM1_BASE);
		}
		HRPWM_setMEPEdgeSelect(EPWM1_BASE, HRPWM_CHANNEL_A, HRPWM_MEP_CTRL_FALLING_EDGE);
		HRPWM_setMEPControlMode(EPWM1_BASE, HRPWM_CHANNEL_A, HRPWM_MEP_DUTY_PERIOD_CTRL);
		HRPWM_setCounterCompareShadowLoadEvent(EPWM1_BASE, HRPWM_CHANNEL_A, HRPWM_LOAD_ON_CNTR_ZERO_PERIOD);
	}




	//PWM9A ߾
#else
	{
		HRPWM_setClockPrescaler(EPWM1_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
		EPWM_setTimeBasePeriod(EPWM1_BASE, 999);
		HRPWM_setTimeBaseCounter(EPWM1_BASE, 0);
		HRPWM_setTimeBaseCounterMode(EPWM1_BASE, EPWM_COUNTER_MODE_UP);
		EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, 0);
		EPWM_setCounterCompareShadowLoadMode(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
		HRPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		HRPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);

		//debugͣʱPWM
		EPWM_setEmulationMode(EPWM1_BASE, 2);

		EPWM_setFallingEdgeDeadBandDelayInput(EPWM1_BASE,EPWM_DB_INPUT_EPWMA);
		EPWM_setFallingEdgeDelayCount(EPWM1_BASE,50);
		EPWM_setDeadBandDelayMode(EPWM1_BASE,EPWM_DB_FED,TRUE);
		EPWM_setDeadBandDelayPolarity(EPWM1_BASE,EPWM_DB_FED,EPWM_DB_POLARITY_ACTIVE_LOW);
		EPWM_setDeadBandOutputSwapMode(EPWM1_BASE,EPWM_DB_OUTPUT_A,TRUE);

		HRPWM_setClockPrescaler(EPWM9_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
		EPWM_setTimeBasePeriod(EPWM9_BASE, 999);
		HRPWM_setTimeBaseCounter(EPWM9_BASE, 0);
		HRPWM_setTimeBaseCounterMode(EPWM9_BASE, EPWM_COUNTER_MODE_UP);
		EPWM_setCounterCompareValue(EPWM9_BASE, EPWM_COUNTER_COMPARE_A, 0);
		EPWM_setCounterCompareShadowLoadMode(EPWM9_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
		HRPWM_setActionQualifierAction(EPWM9_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		HRPWM_setActionQualifierAction(EPWM9_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);

		EPWM_setRisingEdgeDeadBandDelayInput(EPWM9_BASE,EPWM_DB_INPUT_EPWMA);
		EPWM_setRisingEdgeDelayCount(EPWM9_BASE,50);
		EPWM_setDeadBandDelayMode(EPWM9_BASE,EPWM_DB_RED,TRUE);

		if(AUTO == 1){
			HRPWM_enableAutoConversion(EPWM9_BASE);
		}
		else{
			HRPWM_disableAutoConversion(EPWM9_BASE);
		}
		HRPWM_setMEPEdgeSelect(EPWM9_BASE, HRPWM_CHANNEL_A, HRPWM_MEP_CTRL_FALLING_EDGE);
		HRPWM_setMEPControlMode(EPWM1_BASE, HRPWM_CHANNEL_A, HRPWM_MEP_DUTY_PERIOD_CTRL);
		HRPWM_setCounterCompareShadowLoadEvent(EPWM9_BASE, HRPWM_CHANNEL_A, HRPWM_LOAD_ON_CNTR_ZERO_PERIOD);
	}

#endif

	/*--SFO ṹ0--*/
	SFO_Struct_deinit(&SFO_ParamsStruct);
	/*--SFO ṹ帳ֵloop_cntƼ4~5--*/
	SFO_Struct_init(&SFO_ParamsStruct,5);

}

/* TIMER1ʼ
 * period
 */
void InitTimerModule()
{
	/* Initialize CPUTimer with interrupt enable */
	CPUTimer_init(CPUTIMER1_BASE, DEVICE_SYSCLK_FREQ/100);
	Interrupt_register(INT_TIMER1, TIMER1_IRQHandler);
	Interrupt_enable(INT_TIMER1);
	Interrupt_SetPriority( INT_TIMER1,  1,  0);
}

/* TIMER1ж
 * ڴжнHRPWMУ׼
 */
__interrupt void TIMER1_IRQHandler(void)
{
	CPUTimer_clearOverflowFlag(CPUTIMER1_BASE);
	CPUTimer_ClearInterruptStatus(CPUTIMER1_BASE);
	//2s ִһSFOУ׼


	status = SFO(&SFO_ParamsStruct);
	//һУ׼
	if (status !=0)
	{
		/*error()*/
	}

}

/*HRPWMautoconvʹô˺ȥCMPֺС
 * base:EPWMַ
 * period:EPWMֵ
 * cmpareҪõCMPHR,HRPWM_COUNTER_COMPARE_A / HRPWM_COUNTER_COMPARE_B
 */
//HRPWMautoconvʹô˺ȥCMPֺС
void HRPWM_Update_HrDuty_Auto(uint32_t base,uint32_t period,float32_t duty,HRPWM_CounterCompareModule cmpare)
{
	uint32_t cmp_set = 0;
	/*Сֿ*/
	//CMPHR = frac(duty*period) * 256 +0.5 СֵļԼֵ
	cmp_set =( (duty*period- (uint32_t)(duty*period)) *256) + 0.5;
	//ֵļԼֵ
	cmp_set += (uint32_t)(duty*period)<<8;

	/*Сһ
	 * 	cmp_set = duty*period*256;
	 * */
	if(cmpare){
		HRPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_B,cmp_set);
	}
	else{
		HRPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_A,cmp_set);
	}
}




/*δHRPWMautoconvʹô˺ȥCMPֺС
 * base:EPWMַ
 * period:EPWMֵ
 * cmpareҪõCMPHR,HRPWM_COUNTER_COMPARE_A / HRPWM_COUNTER_COMPARE_B
 */
void HRPWM_Update_HrDuty_Manual(uint32_t base,uint32_t period,float32_t duty,HRPWM_CounterCompareModule cmpare)
{
	uint32_t cmp_set = 0;

	//CMPHR = frac(duty*period) * hrstep +0.5
	cmp_set =  (duty*period - (uint32_t)(duty*period)) * SFO_ParamsStruct.HR_mstep+0.5;
	if(cmpare){
		HRPWM_setCmpHRINT(base,cmp_set,SFO_ParamsStruct.HR_mstep,HRPWM_COUNTER_COMPARE_B);
		cmp_set += (uint32_t)(duty*period)<<8;
		HRPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_B,cmp_set);
	}
	else{
		HRPWM_setCmpHRINT(base,cmp_set,SFO_ParamsStruct.HR_mstep,HRPWM_CHANNEL_A);
		cmp_set += (uint32_t)(duty*period)<<8;
		HRPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_A,cmp_set);
	}
}

/*
 * ֻͨCMP
 */
void EPWM_Update_duty(uint32_t base,uint32_t period,float32_t duty,HRPWM_CounterCompareModule cmpare)
{
	uint32_t cmp_set = 0;
	if(cmpare){
		cmp_set = (uint32_t)(duty*period);
		EPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_B,cmp_set);
	}
	else{
		cmp_set = (uint32_t)(duty*period);
		EPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_A,cmp_set);
	}
}



#ifdef __cplusplus

#endif

