/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    board.h
*   @brief   
*
*/

#ifndef DEVICE_BOARD_H_
#define DEVICE_BOARD_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */


//ģʽѡ
#define AUTO 1
//ѡPWM1A or PWM9A ߾
#define PWM1A_HR 0






//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************

//
// EPWM1 -> myEPWM1 Pinmux
//
//
// EPWM1_A - GPIO Settings
//
#define GPIO_PIN_EPWM1_A 0
#define myEPWM1_EPWMA_GPIO 0
#define myEPWM1_EPWMA_PIN_CONFIG  GPIO_0_EPWM1A
//
// EPWM1_B - GPIO Settings
//
#define GPIO_PIN_EPWM1_B 1
#define myEPWM1_EPWMB_GPIO 1
#define myEPWM1_EPWMB_PIN_CONFIG  GPIO_1_EPWM1B

//
// EPWM2 -> myEPWM2 Pinmux
//
//
// EPWM2_A - GPIO Settings
//
#define GPIO_PIN_EPWM2_A 2
#define myEPWM2_EPWMA_GPIO 2
#define myEPWM2_EPWMA_PIN_CONFIG  GPIO_2_EPWM2A
//
// EPWM2_B - GPIO Settings
//
#define GPIO_PIN_EPWM2_B 3
#define myEPWM2_EPWMB_GPIO 3
#define myEPWM2_EPWMB_PIN_CONFIG  GPIO_3_EPWM2B

//
// EPWM3 -> myEPWM3 Pinmux
//
//
// EPWM3_A - GPIO Settings
//
#define GPIO_PIN_EPWM3_A 4
#define myEPWM3_EPWMA_GPIO 4
#define myEPWM3_EPWMA_PIN_CONFIG GPIO_4_EPWM3A
//
// EPWM3_B - GPIO Settings
//
#define GPIO_PIN_EPWM3_B 5
#define myEPWM3_EPWMB_GPIO 5
#define myEPWM3_EPWMB_PIN_CONFIG GPIO_5_EPWM3B

//
// EPWM3 -> myEPWM3 Pinmux
//
//
// EPWM3_A - GPIO Settings
//
#define GPIO_PIN_EPWM4_A 6
#define myEPWM4_EPWMA_GPIO 6
#define myEPWM4_EPWMA_PIN_CONFIG GPIO_6_EPWM4A
//
// EPWM3_B - GPIO Settings
//
#define GPIO_PIN_EPWM4_B 7
#define myEPWM4_EPWMB_GPIO 7
#define myEPWM4_EPWMB_PIN_CONFIG GPIO_7_EPWM4B

//
// EPWM6 -> myEPWM6 Pinmux
//
//
// EPWM6_A - GPIO Settings
//
#define GPIO_PIN_EPWM5_A 8
#define myEPWM5_EPWMA_GPIO 8
#define myEPWM5_EPWMA_PIN_CONFIG GPIO_8_EPWM5A
//
// EPWM6_B - GPIO Settings
//
#define GPIO_PIN_EPWM5_B 9
#define myEPWM5_EPWMB_GPIO 9
#define myEPWM5_EPWMB_PIN_CONFIG GPIO_9_EPWM5B



//
// EPWM6 -> myEPWM6 Pinmux
//
//
// EPWM6_A - GPIO Settings
//
#define GPIO_PIN_EPWM6_A 10
#define myEPWM6_EPWMA_GPIO 10
#define myEPWM6_EPWMA_PIN_CONFIG GPIO_10_EPWM6A
//
// EPWM6_B - GPIO Settings
//
#define GPIO_PIN_EPWM6_B 11
#define myEPWM6_EPWMB_GPIO 11
#define myEPWM6_EPWMB_PIN_CONFIG GPIO_11_EPWM6B

//
// EPWM7 -> myEPWM7 Pinmux
//
//
// EPWM7_A - GPIO Settings
//
#define GPIO_PIN_EPWM7_A 12
#define myEPWM7_EPWMA_GPIO 12
#define myEPWM7_EPWMA_PIN_CONFIG GPIO_12_EPWM7A
//
// EPWM7_B - GPIO Settings
//
#define GPIO_PIN_EPWM7_B 13
#define myEPWM7_EPWMB_GPIO 13
#define myEPWM7_EPWMB_PIN_CONFIG GPIO_13_EPWM7_B

//
// EPWM8 -> myEPWM8 Pinmux
//
//
// EPWM8_A - GPIO Settings
//
#define GPIO_PIN_EPWM8_A 14
#define myEPWM8_EPWMA_GPIO 14
#define myEPWM8_EPWMA_PIN_CONFIG GPIO_14_EPWM8A
//
// EPWM8_B - GPIO Settings
//
#define GPIO_PIN_EPWM8_B 15
#define myEPWM8_EPWMB_GPIO 15
#define myEPWM8_EPWMB_PIN_CONFIG GPIO_15_EPWM8B

//
// EPWM9 -> myEPWM9 Pinmux
//
//
// EPWM9_A - GPIO Settings
//
#define GPIO_PIN_EPWM9_A 16
#define myEPWM9_EPWMA_GPIO 16
#define myEPWM9_EPWMA_PIN_CONFIG GPIO_16_EPWM9A
//
// EPWM9_B - GPIO Settings
//
#define GPIO_PIN_EPWM9_B 17
#define myEPWM9_EPWMB_GPIO 17
#define myEPWM9_EPWMB_PIN_CONFIG GPIO_17_EPWM9B

//
// EPWM10 -> myEPWM9 Pinmux
//
//
// EPWM10_A - GPIO Settings
//
#define GPIO_PIN_EPWM10_A 18
#define myEPWM10_EPWMA_GPIO 18
#define myEPWM10_EPWMA_PIN_CONFIG GPIO_18_EPWM10A
//
// EPWM10_B - GPIO Settings
//
#define GPIO_PIN_EPWM10_B 19
#define myEPWM10_EPWMB_GPIO 19
#define myEPWM10_EPWMB_PIN_CONFIG GPIO_19_EPWM10B

//
// EPWM11 -> myEPWM9 Pinmux
//
//
// EPWM11_A - GPIO Settings
//
#define GPIO_PIN_EPWM11_A 20
#define myEPWM11_EPWMA_GPIO 20
#define myEPWM11_EPWMA_PIN_CONFIG GPIO_20_EPWM11A
//
// EPWM11_B - GPIO Settings
//
#define GPIO_PIN_EPWM11_B 21
#define myEPWM11_EPWMB_GPIO 21
#define myEPWM11_EPWMB_PIN_CONFIG GPIO_21_EPWM11B

//
// EPWM12 -> myEPWM9 Pinmux
//
//
// EPWM12_A - GPIO Settings
//
#define GPIO_PIN_EPWM12_A 22
#define myEPWM12_EPWMA_GPIO 22
#define myEPWM12_EPWMA_PIN_CONFIG GPIO_22_EPWM12A
//
// EPWM12_B - GPIO Settings
//
#define GPIO_PIN_EPWM12_B 23
#define myEPWM12_EPWMB_GPIO 23
#define myEPWM12_EPWMB_PIN_CONFIG GPIO_23_EPWM12B

//
// EPWM13 -> myEPWM9 Pinmux
//
//
// EPWM13_A - GPIO Settings
//
#define GPIO_PIN_EPWM13_A 24
#define myEPWM13_EPWMA_GPIO 24
#define myEPWM13_EPWMA_PIN_CONFIG GPIO_24_EPWM13_A
//
// EPWM13_B - GPIO Settings
//
#define GPIO_PIN_EPWM13_B 25
#define myEPWM13_EPWMB_GPIO 25
#define myEPWM13_EPWMB_PIN_CONFIG GPIO_25_EPWM13_B

//
// EPWM14 -> myEPWM9 Pinmux
//
//
// EPWM14_A - GPIO Settings
//
#define GPIO_PIN_EPWM14_A 26
#define myEPWM14_EPWMA_GPIO 26
#define myEPWM14_EPWMA_PIN_CONFIG GPIO_26_EPWM14_A
//
// EPWM14_B - GPIO Settings
//
#define GPIO_PIN_EPWM14_B 27
#define myEPWM14_EPWMB_GPIO 27
#define myEPWM14_EPWMB_PIN_CONFIG GPIO_27_EPWM14_B

//
// EPWM15 -> myEPWM9 Pinmux
//
//
// EPWM15_A - GPIO Settings
//
#define GPIO_PIN_EPWM15_A 28
#define myEPWM15_EPWMA_GPIO 28
#define myEPWM15_EPWMA_PIN_CONFIG GPIO_28_EPWM15_A
//
// EPWM15_B - GPIO Settings
//
#define GPIO_PIN_EPWM15_B 28
#define myEPWM15_EPWMB_GPIO 28
#define myEPWM15_EPWMB_PIN_CONFIG GPIO_29_EPWM15_B

//
// EPWM16 -> myEPWM9 Pinmux
//
//
// EPWM16_A - GPIO Settings
//
#define GPIO_PIN_EPWM16_A 30
#define myEPWM16_EPWMA_GPIO 30
#define myEPWM16_EPWMA_PIN_CONFIG GPIO_30_EPWM16_A
//
// EPWM16_B - GPIO Settings
//
#define GPIO_PIN_EPWM16_B 31
#define myEPWM16_EPWMB_GPIO 31
#define myEPWM16_EPWMB_PIN_CONFIG GPIO_31_EPWM16_B

//
// EPWM17 -> myEPWM9 Pinmux
//
//
// EPWM17_A - GPIO Settings
//
#define GPIO_PIN_EPWM17_A 32
#define myEPWM17_EPWMA_GPIO 32
#define myEPWM17_EPWMA_PIN_CONFIG GPIO_67_EPWM17_A
//
// EPWM17_B - GPIO Settings
//
#define GPIO_PIN_EPWM17_B 33
#define myEPWM17_EPWMB_GPIO 33
#define myEPWM17_EPWMB_PIN_CONFIG GPIO_68_EPWM17_B

//
// EPWM18 -> myEPWM9 Pinmux
//
//
// EPWM18_A - GPIO Settings
//
#define GPIO_PIN_EPWM18_A 32
#define myEPWM18_EPWMA_GPIO 32
#define myEPWM18_EPWMA_PIN_CONFIG GPIO_34_EPWM18_A
//
// EPWM18_B - GPIO Settings
//
#define GPIO_PIN_EPWM18_B 33
#define myEPWM18_EPWMB_GPIO 33
#define myEPWM18_EPWMB_PIN_CONFIG GPIO_35_EPWM18_B

//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
#define myEPWM1_BASE EPWM1_BASE
#define myEPWM1_TBPRD 0
#define myEPWM1_COUNTER_MODE EPWM_COUNTER_MODE_STOP_FREEZE
#define myEPWM1_TBPHS 0
#define myEPWM1_CMPA 0
#define myEPWM1_CMPB 0
#define myEPWM1_CMPC 0
#define myEPWM1_CMPD 0
#define myEPWM1_DBRED 0
#define myEPWM1_DBFED 0
#define myEPWM1_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM1_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM1_INTERRUPT_SOURCE EPWM_INT_TBCTR_DISABLED
#define myEPWM2_BASE EPWM2_BASE
#define myEPWM2_TBPRD 0
#define myEPWM2_COUNTER_MODE EPWM_COUNTER_MODE_STOP_FREEZE
#define myEPWM2_TBPHS 0
#define myEPWM2_CMPA 0
#define myEPWM2_CMPB 0
#define myEPWM2_CMPC 0
#define myEPWM2_CMPD 0
#define myEPWM2_DBRED 0
#define myEPWM2_DBFED 0
#define myEPWM2_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM2_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM2_INTERRUPT_SOURCE EPWM_INT_TBCTR_DISABLED
#define myEPWM3_BASE EPWM3_BASE
#define myEPWM3_TBPRD 0
#define myEPWM3_COUNTER_MODE EPWM_COUNTER_MODE_STOP_FREEZE
#define myEPWM3_TBPHS 0
#define myEPWM3_CMPA 0
#define myEPWM3_CMPB 0
#define myEPWM3_CMPC 0
#define myEPWM3_CMPD 0
#define myEPWM3_DBRED 0
#define myEPWM3_DBFED 0
#define myEPWM3_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM3_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM3_INTERRUPT_SOURCE EPWM_INT_TBCTR_DISABLED

#define myEPWM4_BASE EPWM4_BASE
#define myEPWM4_TBPRD 20
#define myEPWM4_COUNTER_MODE EPWM_COUNTER_MODE_UP_DOWN
#define myEPWM4_TBPHS 0
#define myEPWM4_CMPA 10
#define myEPWM4_CMPB 10
#define myEPWM4_CMPC 0
#define myEPWM4_CMPD 0
#define myEPWM4_DBRED 0
#define myEPWM4_DBFED 0
#define myEPWM4_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM4_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM4_INTERRUPT_SOURCE EPWM_INT_TBCTR_DISABLED
#define myEPWM5_BASE EPWM5_BASE
#define myEPWM6_BASE EPWM6_BASE
#define myEPWM7_BASE EPWM7_BASE
#define myEPWM8_BASE EPWM8_BASE
#define myEPWM9_BASE EPWM9_BASE
#define myEPWM10_BASE EPWM10_BASE
#define myEPWM11_BASE EPWM11_BASE
#define myEPWM12_BASE EPWM12_BASE
#define myEPWM13_BASE EPWM13_BASE
#define myEPWM14_BASE EPWM14_BASE
#define myEPWM15_BASE EPWM15_BASE
#define myEPWM16_BASE EPWM16_BASE
#define myEPWM17_BASE EPWM17_BASE
#define myEPWM18_BASE EPWM18_BASE
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */




/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */



/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void	Board_init();
void	EPWM_init();
void	PinMux_init();
void InitTimerModule();
void TIMER1_IRQHandler(void);
void HRPWM_Update_HrDuty_Auto(uint32_t base,uint32_t period,float32_t duty,HRPWM_CounterCompareModule cmpare);
void HRPWM_Update_HrDuty_Manual(uint32_t base,uint32_t period,float32_t duty,HRPWM_CounterCompareModule cmpare);
void EPWM_Update_duty(uint32_t base,uint32_t period,float32_t duty,HRPWM_CounterCompareModule cmpare);
#ifdef __cplusplus
}
#endif


#endif /* DEVICE_HEADER_TEMPLATE_H_ */
