/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"
#include <eeprom.h>
#include "printf.h"



uint32_t eeprom_addr_len = 0;
#if 0
int32_t I2C_SendStatusCheck(uint32_t base)
{
    uint32_t retry_cnt = 0;

    while (!(I2C_getIcStatus(base) & I2C_ICSTS_TFNF))
    {
        if (retry_cnt++ == 10000)
        {
            #if defined(DEBUG)
            printf("eeprom tx fifo is full \r\n");
            #endif
            return -1;
        }
    }
    return 0;
}

int32_t I2C_ReceiveStatusCheck(uint32_t base)
{
    uint32_t retry_cnt = 0;

    while (!(I2C_getIcStatus(base) & I2C_ICSTS_RFNE))
    {
        if (retry_cnt++ == 10000)
        {
            #if defined(DEBUG)
            printf("eeprom rx fifo is empty \r\n");
            #endif
            return -1;
        }
    }
    return 0;
}
#endif

int32_t eeprom_DataAddrWrite(uint32_t base, uint32_t data_addr)
{
    uint8_t addr[2] = {0};

    if (eeprom_addr_len == 2)
    {
        addr[0] = (uint8_t)((data_addr >> 8) & 0xff);
        addr[1] = (uint8_t)(data_addr & 0xff);
    }
    else if (eeprom_addr_len == 1)
    {
        addr[0] = (uint8_t)(data_addr & 0xff);
    }
    else
    {
        return -1;
    }

    for(uint32_t i = 0; i < eeprom_addr_len; i++)
    {
        I2C_pollTxEmpty(base);
        I2C_putData(base, addr[i]);
    }
    return 0;
}

int32_t eeprom_DataCmdWrite(uint32_t base, uint8_t *data_cmd, uint32_t data_cmd_len)
{
    int32_t err = 0;

    if (I2C_getIcMode(base) == I2C_ICMODE_MASTER)
    {
        for (uint32_t i = 0; i < data_cmd_len; i++)
        {
            I2C_pollTxEmpty(base);

            if (i == (data_cmd_len - 1))
                I2C_sendCmdWriteAndStop(base, data_cmd[i]);
            else
            	I2C_putData(base, data_cmd[i]);
        }
    }
    else
    {
        ASSERT(0);
    }
    return err;
}
int32_t eeprom_DataCmdRead(uint32_t base, uint8_t *data_cmd, uint32_t data_cmd_len)
{
    int32_t err = 0;
    uint32_t retry_cnt = 0;

    if (I2C_getIcMode(base) == I2C_ICMODE_MASTER)
    {
        for (uint32_t i = 0; i < data_cmd_len; i++)
        {
            I2C_pollTxEmpty(base);
			
            if (i == 0)            
                I2C_sendCmdRestartAndRead(base);            
            else if (i == (data_cmd_len - 1))            
                I2C_sendCmdReadAndStop(base);            
            else            
                I2C_sendCmdRead(base); 	
			
            I2C_pollRxFull(base);
            *data_cmd = I2C_getData(base);
            data_cmd++;
        }
    }
    else
    {
        ASSERT(0);
    }
    return 0;
}

int32_t eeprom_DataCmdReadReq(uint32_t base, uint8_t *data_cmd, uint32_t data_cmd_len)
{
    if (I2C_getIcMode(base) == I2C_ICMODE_MASTER)
    {
        for (uint32_t i = 0; i < data_cmd_len; i++)
        {
            I2C_pollTxEmpty(base);

            if (i == 0)
                I2C_sendCmdRestartAndRead(base);
            else if (i == (data_cmd_len - 1))
                I2C_sendCmdReadAndStop(base);
            else
                I2C_sendCmdRead(base);
        }
    }
    else
    {
        ASSERT(0);
    }
    return 0;
}

int32_t eeprom_DataCmdReadReceive(uint32_t base, uint8_t *data_cmd, uint32_t data_cmd_len)
{
    if (I2C_getIcMode(base) == I2C_ICMODE_MASTER)
    {
        for (uint32_t i = 0; i < data_cmd_len; i++)
        {
        	I2C_pollRxFull(base);

            *data_cmd = I2C_getData(base);
            //printf("r %d \r\n", *data_cmd);
            data_cmd++;
        }
    }
    else
    {
        ASSERT(0);
    }
    return 0;
}

void eeprom_init(uint32_t addr_len)
{
	eeprom_addr_len = addr_len;
}

#ifdef __cplusplus
}
#endif

