/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __EEPROM_STATE_H_
#define __EEPROM_STATE_H_

#ifdef __cplusplus
extern "C"{
#endif

#include "device.h"
#include <stdio.h>

#define I2C_ACTIVITY_ISRC        (0x1<<8)
#define I2C_TX_ABRT_ISRC        (0x1<<6)
#define I2C_TX_EMPT_ISRC        (0x1<<4)
#define I2C_SCD_ISRC            (0x1<<9)
#define I2C_AAS_ISRC            (0x1<<16)

#define TARGET_ADDRESS              0x50
#define EEPROM_HIGH_ADDR            0x00
#define EEPROM_LOW_ADDR             0x00
#define NUM_BYTES                   8
#define MAX_BUFFER_SIZE             9      // Max is currently 14 because of
                                            // 2 address bytes and the 16-byte
                                            // FIFO

#define MSG_STATUS_INACTIVE         0x0000 // Message not in use, do not send
#define MSG_STATUS_SEND_WITHSTOP    0x0010 // Send message with stop bit
#define MSG_STATUS_WRITE_BUSY       0x0011 // Message sent, wait for stop
#define MSG_STATUS_SEND_NOSTOP      0x0020 // Send message without stop bit
#define MSG_STATUS_SEND_NOSTOP_BUSY 0x0021 // Message sent, wait for ARDY
#define MSG_STATUS_RESTART          0x0022 // Ready to become controller-receiver
#define MSG_STATUS_READ_BUSY        0x0023 // Wait for stop before reading data
#define MSG_STATUS_END        		0x0024 // Wait for stop before reading data

#define I2C_BASE					I2CB_BASE


#define ERROR_BUS_BUSY              0x1000
#define ERROR_STOP_NOT_READY        0x5555
#define SUCCESS                     0x0000


struct I2CMsg {
    uint16_t msgStatus;

    uint16_t targetAddr;
    uint16_t numBytes;
    uint16_t memoryHighAddr;

    uint16_t memoryLowAddr;

    uint16_t msgBuffer[MAX_BUFFER_SIZE];
};

extern struct I2CMsg i2cMsgOut;
extern struct I2CMsg i2cMsgIn;
extern struct I2CMsg *currentMsgPtr;

uint16_t readData(struct I2CMsg *msg);
uint16_t writeData(struct I2CMsg *msg);
void Check_Status(void);
void RecvDataCheck(void);


void I2C_GPIO_init(void);
void I2Cinit(uint32_t i2c_base);

#ifdef __cplusplus
}
#endif

#endif
