/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


#ifdef __cplusplus
extern "C"{
#endif


#include "device.h"
#include "master.h"

uint16_t tx_Buffer[NUM_BYTES];
uint16_t rx_Buffer[NUM_BYTES];

void initI2C(void)
{
	I2C_INIT_PARAM init_param = {0};

    GPIO_setPinConfig(GPIO_2_I2CB_SDA);
    GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD | GPIO_PIN_TYPE_PULLUP);//I2CA_SDA_GP0
    GPIO_setQualificationMode(2, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(GPIO_3_I2CB_SCL);
    GPIO_setPadConfig(3, GPIO_PIN_TYPE_STD | GPIO_PIN_TYPE_PULLUP);//I2CA_SCL_GP1
    GPIO_setQualificationMode(3, GPIO_QUAL_ASYNC);

	init_param.master_mode = I2C_MASTER_MODE;
	init_param.slave_addr = I2C_SLAVE_ADDRESS;
	init_param.speed_mode = I2C_FAST_SPEED_MODE;
	init_param.baudrate = 400 * 1000;
	init_param.apbclk_freq = DEVICE_APBCLK_FREQ;
	I2C_initConfig(I2CB_BASE, &init_param);
#if 0
	I2C_disableModule(i2c_base);
	I2C_disableInterrupt(i2c_base, 0xFFFFFFF);
	I2C_setTargetAddress(i2c_base,EEPROM_SLAVE_ADDRESS);
	I2C_setConfig(i2c_base, I2C_MASTER_MODE | I2C_TX_EMPTY_CTRL | I2C_RESTART_EN);//
	I2C_initController(i2c_base, DEVICE_APBCLK_FREQ, 400000, I2C_DUTYCYCLE_50);
	I2C_enableModule(i2c_base);

#endif
}

uint16_t readData(uint32_t eeprom_addr, uint16_t *rx_msg, uint16_t datalen)
{
    uint16_t addr[2];
    uint16_t i = 0;

    addr[0] = (uint16_t)(eeprom_addr >> 16);
    addr[1] = (uint16_t)eeprom_addr;



    //
    // Setup target address
    //
    I2C_setTargetAddress(I2CB_BASE, I2C_SLAVE_ADDRESS);

    //
    // Check if bus busy
    //
    if(I2C_isBusBusy(I2CB_BASE))
    {
        return(ERROR_BUS_BUSY);
    }
    I2C_putData(I2CB_BASE, eeprom_addr);


   for (i = 0; i < datalen; i++)
   {
	   I2C_pollTxEmpty(I2CB_BASE);
	   if(i == datalen - 1)
	   {
		   I2C_sendCmdReadAndStop(I2CB_BASE);
	   }
	   else
	   {
		   I2C_sendCmdRead(I2CB_BASE);
	   }
	   I2C_pollRxFull(I2CA_BASE);
	   rx_msg[i] =I2C_getData(I2CB_BASE);
   }
//   I2C_clearInterruptStopDet(I2CA_BASE);
   return SUCCESS;
}

uint16_t writeData(uint32_t eeprom_addr, uint16_t *tx_msg, uint16_t datalen)
{
    uint16_t addr[2];
    uint16_t i = 0;


    addr[0] = (uint16_t)(eeprom_addr >> 16);
    addr[1] = (uint16_t)eeprom_addr;

    //
    // Setup target address
    //

    I2C_setTargetAddress(I2CB_BASE, I2C_SLAVE_ADDRESS);

    //
    // Check if bus busy
    //
    if(I2C_isBusBusy(I2CB_BASE))
    {
        return(ERROR_BUS_BUSY);
    }



    //
    // Setup number of bytes to send msgBuffer and data
    //

    for (i = 0; i < datalen; i++)
    {
    	if(i == datalen - 1)
	    {
		    I2C_sendCmdWriteAndStop(I2CB_BASE, (tx_msg[i] & 0x00ff));
	    }
	    else
	    {
		    I2C_putData(I2CB_BASE,  (tx_msg[i] & 0x00ff));
	    }
	    I2C_pollTxEmpty(I2CB_BASE);
    }

    return SUCCESS;
}

void verifyEEPROMRead(void)
{
    uint16_t i;
    while(I2C_getStatus(I2CB_BASE) & I2C_STS_BUS_BUSY);

    for(i=0;i<NUM_BYTES;i++)
    {
        if(rx_Buffer[i] != tx_Buffer[i])
        {
            //Transmitted data doesn't match received data
            //Fail condition. PC shouldn't reach here
            return;
        }
    }
}

#ifdef __cplusplus
}
#endif
