/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __EEPROM_REGISTER_H_
#define __EEPROM_REGISTER_H_

#ifdef __cplusplus
extern "C"{
#endif

#include "inc/hw_types.h"
#include "inc/hw_memmap.h"



#if (GS32_PART_NUM != 0x35)

#define I2C_BASE 	I2CB_BASE

#if(I2C_BASE == I2CA_BASE)

#define I2C_SDA_PIN		0U
#define I2C_SCL_PIN		1U

#define I2C_SDA_PIN_MUX	GPIO_0_I2CA_SDA
#define I2C_SCL_PIN_MUX	GPIO_1_I2CA_SCL

#define I2C_INT		INT_I2CA

#elif (I2C_BASE == I2CB_BASE)

#define I2C_SDA_PIN		2U
#define I2C_SCL_PIN		3U

#define I2C_SDA_PIN_MUX	GPIO_2_I2CB_SDA
#define I2C_SCL_PIN_MUX	GPIO_3_I2CB_SCL

#define I2C_INT		INT_I2CB

#endif

#else

#define I2C_BASE 	I2CB_BASE

#if(I2C_BASE == I2CA_BASE)

#define I2C_SDA_PIN_MUX		GpioCtrlRegs.GPAMUX2.bit.GPIO28 = (GPIO_28_I2CA_SDA & GPIO_MUX_MASK)
#define I2C_SCL_PIN_MUX		GpioCtrlRegs.GPAMUX2.bit.GPIO29 = (GPIO_29_I2CA_SCL & GPIO_MUX_MASK)

#define I2C_INT		INT_I2CA


#elif (I2C_BASE == I2CB_BASE)

#define I2C_SDA_PIN_MUX		GpioCtrlRegs.GPAMUX2.bit.GPIO30 = (GPIO_30_I2CB_SDA & GPIO_MUX_MASK)
#define I2C_SCL_PIN_MUX		GpioCtrlRegs.GPAMUX2.bit.GPIO31 = (GPIO_31_I2CB_SCL & GPIO_MUX_MASK)

#define I2C_INT		INT_I2CB

#endif

#endif

/* Error messages for read and write functions */
#define ERROR_BUS_BUSY              0x1000
#define ERROR_NACK_RECEIVED         0x2000
#define ERROR_ARBITRATION_LOST      0x3000
#define ERROR_STOP_NOT_READY        0x5555
#define SUCCESS                     0x0000

#define EEPROM_ADDR_LENGTH			1
#define TARGET_ADDRESS              0x50
#define NUM_BYTES                   4
/*
 * Max is currently 14 because of
 * 2 address bytes and the 16-byte
 */
#define MAX_BUFFER_SIZE             14

extern uint8_t tx_Buffer[NUM_BYTES];
extern uint8_t rx_Buffer[NUM_BYTES];


void i2c_init(void);
void transfer_buffer_init(void);
uint16_t writeData(uint32_t eeprom_addr, uint8_t *tx_msg, uint16_t datalen);
uint16_t readData(uint32_t eeprom_addr, uint8_t *rx_msg, uint16_t datalen);
void verifyEEPROMRead(void);

#ifdef __cplusplus
}
#endif

#endif
