/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __I2C_EEPROM_STATE_H_
#define __I2C_EEPROM_STATE_H_


#ifdef __cplusplus
extern "C"{
#endif

#include "device.h"

#define I2C_BASE 	I2CB_BASE

#if (GS32_PART_NUM != 0x35)

#if(I2C_BASE == I2CA_BASE)

#define I2C_SDA_PIN 0U
#define I2C_SCL_PIN 1U
#define I2C_SDA_PINMUX	GPIO_0_I2CA_SDA
#define I2C_SCL_PINMUX	GPIO_1_I2CA_SCL

#elif(I2C_BASE == I2CB_BASE)

#define I2C_SDA_PIN 2U
#define I2C_SCL_PIN 3U
#define I2C_SDA_PINMUX	GPIO_2_I2CB_SDA
#define I2C_SCL_PINMUX	GPIO_3_I2CB_SCL

#endif

#else

#if(I2C_BASE == I2CA_BASE)

#define I2C_SDA_PIN_MUX		GpioCtrlRegs.GPAMUX2.bit.GPIO28 = (GPIO_28_I2CA_SDA & GPIO_MUX_MASK)
#define I2C_SCL_PIN_MUX		GpioCtrlRegs.GPAMUX2.bit.GPIO29 = (GPIO_29_I2CA_SCL & GPIO_MUX_MASK)

#elif(I2C_BASE == I2CB_BASE)

#endif

#endif

/*
 * AT24C01\AT24C02\AT24C04\AT24C08\AT24C16
 * AT24C32\AT24C64\AT24C128\AT24C256\AT24C512
 */
#define AT24C01

#if(defined(AT24C01)||defined(AT24C02)||defined(AT24C04)||defined(AT24C08)||defined(AT24C16))
#define REG_ADDR_SZIE	(1)
#else
#define REG_ADDR_SZIE	(2)
#endif

#if(defined(AT24C01)||defined(AT24C02))
#define PAGE_SIZE		(8)
#elif(defined(AT24C04)||defined(AT24C08)||defined(AT24C16))
#define PAGE_SIZE		(16)
#elif(defined(AT24C32)||defined(AT24C64))
#define PAGE_SIZE		(32)
#elif(defined(AT24C128)||defined(AT24C256))
#define PAGE_SIZE		(64)
#elif(defined(AT24C512))
#define PAGE_SIZE		(128)
#endif

#if(defined(AT24C01)||defined(AT24C04)||defined(AT24C08)||defined(AT24C16))
#define PAGE_MAX_NUM	(16)
#elif(defined(AT24C02))
#define PAGE_MAX_NUM	(32)
#elif(defined(AT24C32))
#define PAGE_MAX_NUM	(128)
#elif(defined(AT24C64)||defined(AT24C128))
#define PAGE_MAX_NUM	(256)
#elif(defined(AT24C256)||defined(AT24C512))
#define PAGE_MAX_NUM	(512)
#endif


#if(defined(AT24C04))
#define	BANK_MAX_NUM	(2)
#elif(defined(AT24C08))
#define	BANK_MAX_NUM	(4)
#elif(defined(AT24C16))
#define	BANK_MAX_NUM	(8)
#else
#define	BANK_MAX_NUM	(1)
#endif


#define I2C_IS_BUSY				(1<<0)
#define I2C_IS_IDLE				(1<<1)
#define I2C_IS_READY			(1<<2)
#define I2C_SEND_REGADDR		(1<<3)
#define I2C_IS_RESTART			(1<<4)
#define I2C_IS_TRANSFER			(1<<5)
#define I2C_IS_STOP				(1<<6)
#define I2C_IS_ARB_LOST			(1<<7)
#define I2C_IS_SEND_REGADDR		(1<<8)
#define I2C_IS_NACK				(1<<9)

#define EEPROM_WRITE_RETRY_COUNT 		2

#define EEPROM_ADDR			0X50

void i2c_init();
uint8_t eeprom_write(uint16_t reg_addr,uint8_t* pdata,uint16_t data_length);
uint8_t eeprom_read(uint16_t reg_addr,uint8_t* pdata,uint16_t data_length);
uint8_t i2c_read_data(uint8_t dev_addr,uint16_t reg_addr,uint8_t *pdata,uint16_t datalen);

#ifdef __cplusplus
}
#endif

#endif
