/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


#include "device.h"
#include "i2c_loopback.h"


uint8_t sData[2];
uint8_t rData[2];
uint16_t rDataPoint = 0;


static void initI2CFIFO(void)
{

	/* Must put I2C into reset before configuring it */
    I2C_disableModule(I2C_BASE);

    I2C_initController(I2C_BASE, DEVICE_APBCLK_FREQ, 400000, I2C_DUTYCYCLE_50);
    I2C_setConfig(I2C_BASE,I2C_CONTROLLER_SEND_MODE);
    I2C_setOwnAddress(I2C_BASE, TARGET_ADDRESS);
    I2C_enableLoopback(I2C_BASE);
    I2C_setEmulationMode(I2CA_BASE, I2C_EMULATION_FREE_RUN);

    I2C_enableFIFO(I2C_BASE);

    I2C_setFIFOInterruptLevel(I2C_BASE, I2C_FIFO_TX2, I2C_FIFO_RX2);
    I2C_clearInterruptStatus(I2C_BASE,I2C_INT_TXFF|I2C_INT_STOP_CONDITION|I2C_INT_RXFF);
    I2C_enableInterrupt(I2C_BASE,I2C_INT_TXFF|I2C_INT_STOP_CONDITION|I2C_INT_RXFF);

    I2C_enableModule(I2C_BASE);
}


__interrupt void i2cFIFOISR(void)
{
	static uint16_t cnt=0;
	uint16_t i;
	if((I2C_getInterruptStatus(I2C_BASE) & I2C_INT_RXFF) != 0){
		for(i = 0; i < 2; i++){
			rData[i] = I2C_getData(I2C_BASE);
		}
		for(i=0;i<2;i++){
			if(rData[i] != sData[i]){
				cnt++;
			}
		}
		for(i=0;i<2;i++){
			sData[i] += 2;
		}
		I2C_clearInterruptStatus(I2C_BASE, I2C_INT_RXFF);
	}else if((I2C_getInterruptStatus(I2C_BASE) & I2C_INT_TXFF) != 0){
		I2C_sendStartCondition(I2C_BASE);
		for(i = 0; i < 2; i++){
			I2C_putData(I2C_BASE, sData[i]);
		}
		I2C_clearInterruptStatus(I2C_BASE, I2C_INT_TXFF);
	}
	DELAY_US(100);
}

static void i2c_buffer_init(void)
{
    uint16_t i;

    for(i = 0; i < 2; i++)
    {
        sData[i] = i;
        rData[i]= 0;
    }
}

void i2c_init(void)
{
	initI2CFIFO();

	i2c_buffer_init();

    Interrupt_register(INT_I2CA_FIFO, &i2cFIFOISR);

	Interrupt_enable(INT_I2CA_FIFO);
}
