/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __I2C_STATE_H_
#define __I2C_STATE_H_

#ifdef __cplusplus
extern "C"{
#endif

#include "device.h"



#if (GS32_PART_NUM != 0x35)

#define I2C_BASE 	I2CB_BASE

#if(I2C_BASE == I2CA_BASE)

#define I2C_SDA_PIN 0U
#define I2C_SCL_PIN 1U

#define I2C_SDA_PINMUX	GPIO_0_I2CA_SDA
#define I2C_SCL_PINMUX	GPIO_1_I2CA_SCL

#elif(I2C_BASE == I2CB_BASE)

#define I2C_SDA_PIN			2U
#define I2C_SCL_PIN			3U

#define I2C_SDA_PINMUX		GPIO_2_I2CB_SDA
#define I2C_SCL_PINMUX		GPIO_3_I2CB_SCL

#endif

#else

#define I2C_BASE 	I2CB_BASE

#if(I2C_BASE == I2CA_BASE)

#define I2C_SDA_PIN_MUX		GpioCtrlRegs.GPAMUX2.bit.GPIO28 = (GPIO_28_I2CA_SDA & GPIO_MUX_MASK)
#define I2C_SCL_PIN_MUX		GpioCtrlRegs.GPAMUX2.bit.GPIO29 = (GPIO_29_I2CA_SCL & GPIO_MUX_MASK)

#elif(I2C_BASE == I2CB_BASE)

#define I2C_SDA_PIN_MUX		GpioCtrlRegs.GPAMUX2.bit.GPIO30 = (GPIO_30_I2CB_SDA & GPIO_MUX_MASK)
#define I2C_SCL_PIN_MUX		GpioCtrlRegs.GPAMUX2.bit.GPIO31 = (GPIO_31_I2CB_SCL & GPIO_MUX_MASK)

#define I2C_INT		INT_I2CB

#endif

#endif

typedef enum
{
	I2C_READY = 0,
	I2C_START,
	I2C_TRANSFER,
	I2C_STOP
}I2C_Stage;

void i2c_init(void);
uint8_t i2c_read_data(uint8_t dev_addr,uint16_t reg_addr,uint8_t *pdata,uint16_t datalen);
uint8_t i2c_write_data(uint8_t dev_addr,uint16_t reg_addr,uint8_t *pdata,uint16_t datalen);

#ifdef __cplusplus
}
#endif

#endif
