/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"
#include "dma_controller.h"
#include "lin_transfer.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

LIN_SlaveDataBuf slaveData;
uint16_t done_chanel0 = 0;

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

static void configMsgs(void)
{
#if(LIN_ACTION)
    slaveData.Data[0] = 0x11;
    slaveData.Data[1] = 0x23;
    slaveData.Data[2] = 0x45;
    slaveData.Data[3] = 0x67;
    slaveData.Data[4] = 0x89;
    slaveData.Data[5] = 0xAB;
    slaveData.Data[6] = 0xCD;
    slaveData.Data[7] = 0xFE;
#else
    slaveData.Data[0] = 0x00;
    slaveData.Data[1] = 0x00;
    slaveData.Data[2] = 0x00;
    slaveData.Data[3] = 0x00;
    slaveData.Data[4] = 0x00;
    slaveData.Data[5] = 0x00;
    slaveData.Data[6] = 0x00;
    slaveData.Data[7] = 0x00;
#endif
}

static void configureDMAChannels(uint32_t linbase)
{
#if (IS_GS32F00xx(0x12) || IS_GS32F00xx(0x30))

#if(LIN_ACTION)
	DMA_ConfigParams txWrDmaCfg = {0};

    txWrDmaCfg.enableInterrupt = 1;
    //enable DMA Trigger by DMA MUX
#if(IS_GS32F00xx(0x30))
    txWrDmaCfg.dmaDstReqId = DMAMUX_ReqId_lin1_tx;
#else
    txWrDmaCfg.dmaDstReqId = DMAMUX_LIN_TX;
#endif
    txWrDmaCfg.srcAddr = (uint32_t)(&slaveData);
    txWrDmaCfg.destAddr = (uint32_t)(linbase + LIN_US_THR);
    txWrDmaCfg.blockTS = sizeof(LIN_SlaveDataBuf);
    txWrDmaCfg.ttfc    = DMA_TT_FC_1_M2P_DMAC;
    txWrDmaCfg.srcBtl  = DMA_BTL_1;
    txWrDmaCfg.reloadSrc = true;
    txWrDmaCfg.destBtl = DMA_BTL_1;
    txWrDmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
    txWrDmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
    txWrDmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_1;
    txWrDmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_1;

#if (IS_GS32F00xx(0x30))

    txWrDmaCfg.enableBlkOfst = false;
    txWrDmaCfg.blockOffset = 0;
    txWrDmaCfg.enableBlkCnt = false;
    txWrDmaCfg.blockCnt = 1;

    DMA_configChannel(DMA_CH1_BASE, &txWrDmaCfg);
    DMA_clearInterrupt(DMA_CH1_BASE, DMA_INT_BLOCK);
    DMA_unMaskInterrupt(DMA_CH1_BASE, DMA_INT_BLOCK);

#else

    DMA_configChannel(DMA1_CH1_BASE, &txWrDmaCfg);
    DMA_clearInterrupt(DMA1_CH1_BASE, DMA_INT_BLOCK);
    DMA_unMaskInterrupt(DMA1_CH1_BASE, DMA_INT_BLOCK);

#endif

#else
    DMA_ConfigParams rxRdDmaCfg = {0};

    rxRdDmaCfg.enableInterrupt = 1;
    //enable DMA Trigger by DMA MUX
#if(IS_GS32F00xx(0x30))
    rxRdDmaCfg.dmaSrcReqId = DMAMUX_ReqId_lin1_rx;
#else
    rxRdDmaCfg.dmaSrcReqId = DMAMUX_LIN_RX;
#endif
    rxRdDmaCfg.srcAddr = (uint32_t)(linbase + LIN_US_RHR);
    rxRdDmaCfg.destAddr = (uint32_t)(&slaveData);
    rxRdDmaCfg.blockTS = sizeof(LIN_SlaveDataBuf);
    rxRdDmaCfg.ttfc    = DMA_TT_FC_2_P2M_DMAC;
    rxRdDmaCfg.srcBtl  = DMA_BTL_1;
    rxRdDmaCfg.reloadDst = true;
    rxRdDmaCfg.destBtl = DMA_BTL_1;
    rxRdDmaCfg.srcAddrDirect = DMA_ADDR_NO_CHANGE;
    rxRdDmaCfg.destAddrDirect = DMA_ADDR_INCRE;
    rxRdDmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_1;
    rxRdDmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_1;
#if(IS_GS32F00xx(0x30))
    rxRdDmaCfg.enableBlkOfst = false;
	rxRdDmaCfg.blockOffset = 0;
	rxRdDmaCfg.enableBlkCnt = false;
	rxRdDmaCfg.blockCnt = 1;
    DMA_configChannel(DMA_CH1_BASE, &rxRdDmaCfg);
	DMA_clearInterrupt(DMA_CH1_BASE, DMA_INT_BLOCK);
	DMA_unMaskInterrupt(DMA_CH1_BASE, DMA_INT_BLOCK);
#else
    DMA_configChannel(DMA1_CH1_BASE, &rxRdDmaCfg);
    DMA_clearInterrupt(DMA1_CH1_BASE, DMA_INT_BLOCK);
    DMA_unMaskInterrupt(DMA1_CH1_BASE, DMA_INT_BLOCK);
#endif

#endif

#elif (IS_GS32F3xx(0x22))

#if(LIN_ACTION)
    XDMA_ConfigParams txWrDmaCfg = {0};

    txWrDmaCfg.enableInterrupt = 1;
    //enable DMA Trigger by DMA MUX
    txWrDmaCfg.dmaDstReqId = DMAMUX_LIN_TX;
    txWrDmaCfg.srcAddr = (uint32_t)(&slaveData);
    txWrDmaCfg.destAddr = (uint32_t)(linbase + LIN_US_THR);
    txWrDmaCfg.blockTS = sizeof(LIN_SlaveDataBuf);
    txWrDmaCfg.ttfc    = XDMA_TT_FC_1_M2P_DMAC;
    txWrDmaCfg.srcBtl  = XDMA_BTL_1;
    txWrDmaCfg.reloadSrc = XDMA_RELOAD;
    txWrDmaCfg.destBtl = XDMA_BTL_1;
    txWrDmaCfg.srcAddrDirect = XDMA_ADDR_INCRE;
    txWrDmaCfg.destAddrDirect = XDMA_ADDR_NO_CHANGE;
    txWrDmaCfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
    txWrDmaCfg.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_1;
    XDMA_configChannel(DMA1_CH1_BASE, &txWrDmaCfg);
    XDMA_clearInterrupt(DMA1_CH1_BASE, XDMA_INT_BLOCK);
    XDMA_unMaskInterrupt(DMA1_CH1_BASE, XDMA_INT_BLOCK);
#else
    XDMA_ConfigParams rxRdDmaCfg = {0};

    rxRdDmaCfg.enableInterrupt = 1;
    //enable DMA Trigger by DMA MUX
    rxRdDmaCfg.dmaSrcReqId = DMAMUX_LIN_RX;
    rxRdDmaCfg.srcAddr = (uint32_t)(linbase + LIN_US_RHR);
    rxRdDmaCfg.destAddr = (uint32_t)(&slaveData);
    rxRdDmaCfg.blockTS = sizeof(LIN_SlaveDataBuf);
    rxRdDmaCfg.ttfc    = XDMA_TT_FC_2_P2M_DMAC;
    rxRdDmaCfg.srcBtl  = XDMA_BTL_1;
    rxRdDmaCfg.reloadDst = XDMA_RELOAD;
    rxRdDmaCfg.destBtl = XDMA_BTL_1;
    rxRdDmaCfg.srcAddrDirect = XDMA_ADDR_NO_CHANGE;
    rxRdDmaCfg.destAddrDirect = XDMA_ADDR_INCRE;
    rxRdDmaCfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
    rxRdDmaCfg.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_1;
    XDMA_configChannel(DMA1_CH1_BASE, &rxRdDmaCfg);
    XDMA_clearInterrupt(DMA1_CH1_BASE, XDMA_INT_BLOCK);
    XDMA_unMaskInterrupt(DMA1_CH1_BASE, XDMA_INT_BLOCK);
#endif

#endif
}

void dma1_ch1_irq_handler(void)
{
	done_chanel0 = 1;
#if (IS_GS32F00xx(0x12))
	DMA_clearInterrupt(DMA1_CH1_BASE,DMA_INT_BLOCK);
#elif (IS_GS32F3xx(0x22))
	XDMA_clearInterrupt(DMA1_CH1_BASE,XDMA_INT_BLOCK);
#elif (IS_GS32F00xx(0x30))
	DMA_clearInterrupt(DMA_CH1_BASE,DMA_INT_BLOCK);
#endif
}

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

void dma_init(uint32_t linbase)
{

#if (IS_GS32F00xx(0x12))
	DMA_initController(DMA1_BASE);
#elif (IS_GS32F3xx(0x22))
	XDMA_initController(DMA1_BASE);
#elif (IS_GS32F00xx(0x30))
	DMA_initController(DMA_BASE);
#endif
	configMsgs();
	configureDMAChannels(linbase);

	Interrupt_register(INT_DMA1_CH1,dma1_ch1_irq_handler);
	Interrupt_enable(INT_DMA1_CH1);
}
