#include "sdfm_ex4_pwm_sync_cpuread_board.h"
#include "sdfm.h"
#include "board_cfg.h"

//
// Defines
//
#define MAX_SAMPLES               1024
#define SDFM_PIN_MUX_OPTION1      1
#define SDFM_PIN_MUX_OPTION2      2
#define EPWM_TIMER_TBPRD          65535  // ePWM Period register
#define SDFM_INT_MASK             0x8000F000U

//
// Globals
//
uint32_t sdfmInstance;
uint32_t pwmInstance = EPWM1_BASE; // ePWM 11 for synchronizing SDFM1 filters



// SDFM1 SD1_C1 - GPIO Settings
//
#define GPIO_PIN_SDFM1_C1 17
#define mySDFM1_SDFM1C1_GPIO 17
#define mySDFM1_SDFM1C1_PIN_CONFIG GPIO_17_SD1_C1
//
// SDFM1 SD1_D1 - GPIO Settings
//
#define GPIO_PIN_SDFM1_D1 16
#define mySDFM1_SDFM1D1_GPIO 16
#define mySDFM1_SDFM1D1_PIN_CONFIG GPIO_16_SD1_D1


// SDFM1 SD1_C2 - GPIO Settings
//
#define GPIO_PIN_SDFM1_C2 19
#define mySDFM1_SDFM1C2_GPIO 19
#define mySDFM1_SDFM1C2_PIN_CONFIG GPIO_19_SD1_C2
//
// SDFM1 SD1_D2 - GPIO Settings
//
#define GPIO_PIN_SDFM1_D2 18
#define mySDFM1_SDFM1D2_GPIO 18
#define mySDFM1_SDFM1D2_PIN_CONFIG GPIO_18_SD1_D2


//
// SDFM1 SD1_C3 - GPIO Settings
//
#define GPIO_PIN_SDFM1_C3 53
#define mySDFM1_SDFM1C3_GPIO 53
#define mySDFM1_SDFM1C3_PIN_CONFIG GPIO_53_SD1_C3
//
// SDFM1 SD1_D3 - GPIO Settings
//
#define GPIO_PIN_SDFM1_D3 52
#define mySDFM1_SDFM1D3_GPIO 52
#define mySDFM1_SDFM1D3_PIN_CONFIG GPIO_52_SD1_D3

//
// SDFM1 SD1_C4 - GPIO Settings
//
#define GPIO_PIN_SDFM1_C4 55
#define mySDFM1_SDFM1C4_GPIO 55
#define mySDFM1_SDFM1C4_PIN_CONFIG GPIO_55_SD1_C4

//
// SDFM1 SD1_D4 - GPIO Settings
//
#define GPIO_PIN_SDFM1_D4 22
#define mySDFM1_SDFM1D4_GPIO 22
#define mySDFM1_SDFM1D4_PIN_CONFIG GPIO_22_SD1_D4



void Board_init(void){
	PinMux_init();
	sdfm_init();
}
void PinMux_init()
{

	// SDFM1 Pin Mux
	//SDFM1 SD1_C1 _GP17
	GPIO_setPinConfig(mySDFM1_SDFM1C1_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1C1_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1C1_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1C1_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_D1 _GP16
	GPIO_setPinConfig(mySDFM1_SDFM1D1_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1D1_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1D1_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1D1_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_C2 _GP19
	GPIO_setPinConfig(mySDFM1_SDFM1C2_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1C2_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1C2_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1C2_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_D2 _GP18
	GPIO_setPinConfig(mySDFM1_SDFM1D2_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1D2_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1D2_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1D2_GPIO, GPIO_QUAL_ASYNC);


	//SDFM1 SD1_C3 _GP53
	GPIO_setPinConfig(mySDFM1_SDFM1C3_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1C3_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1C3_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1C3_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_D3 _GP52
	GPIO_setPinConfig(mySDFM1_SDFM1D3_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1D3_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1D3_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1D3_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_C4 _GP55
	GPIO_setPinConfig(mySDFM1_SDFM1C4_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1C4_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1C4_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1C4_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_D4 _GP22
	GPIO_setPinConfig(mySDFM1_SDFM1D4_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1D4_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1D4_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1D4_GPIO, GPIO_QUAL_ASYNC);


}
//
// initEPWM - Initialize specified EPWM settings
//

EPWM_SignalParams pwmSignal =
            {1000, 0.5f, 0.5f, true, DEVICE_SYSCLK_FREQ,
            EPWM_COUNTER_MODE_UP_DOWN, EPWM_CLOCK_DIVIDER_1,
            EPWM_HSCLOCK_DIVIDER_1};
//EPWM_SignalParams pwmSignal2 =
//            {1000000, 0.5f, 0.5f, true, DEVICE_SYSCLK_FREQ/4,
//            EPWM_COUNTER_MODE_UP_DOWN, EPWM_CLOCK_DIVIDER_1,
//            EPWM_HSCLOCK_DIVIDER_1};

//
// EPWM1 -> myEPWM1 Pinmux
//
//
// EPWM1_A - GPIO Settings
//
#define GPIO_PIN_EPWM1_A 0
#define myEPWM1_EPWMA_GPIO 0
#define myEPWM1_EPWMA_PIN_CONFIG GPIO_0_EPWM1_A
//
// EPWM1_B - GPIO Settings
//
#define GPIO_PIN_EPWM1_B 1
#define myEPWM1_EPWMB_GPIO 1
#define myEPWM1_EPWMB_PIN_CONFIG GPIO_1_EPWM1_B

void initEPWM(uint32_t epwmInstance)
{
	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);
	EPWM_configureSignal(epwmInstance, &pwmSignal);


	EPWM_enableADCTrigger(epwmInstance, EPWM_SOC_A);
	EPWM_setADCTriggerSource(epwmInstance, EPWM_SOC_A, EPWM_SOC_TBCTR_ZERO);
	EPWM_setADCTriggerEventPrescale(epwmInstance, EPWM_SOC_A, 1);
	EPWM_clearADCTriggerFlag(epwmInstance,EPWM_SOC_A);

//	GPIO_setPinConfig(GPIO_2_EPWM2A);
//	GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(2, GPIO_QUAL_SYNC);
//	EPWM_configureSignal(EPWM2_BASE, &pwmSignal2);
    //
    // Enable sync and clock to PWM
    //
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);
}
void sdfm_init(void){

	uint16_t  pinMuxOption;
    uint16_t  hlt, llt;


    //
    // Configure SDFM type to 0 and see if data ack generated SDINT.
    //
	SysCtl_configureType(0);
	pinMuxOption = SDFM_PIN_MUX_OPTION1;

    //
    // Select SDFM1
    //
    sdfmInstance = SDFM1_BASE;

    //
    // Input Control Unit
    //
    // Configure Input Control Unit: Modulator Clock rate = Modulator data rate
    //
    Sdfm1Regs.SDCTLPARM1.bit.MOD = SDFM_MODULATOR_CLK_EQUAL_DATA_RATE;
    Sdfm1Regs.SDCTLPARM2.bit.MOD = SDFM_MODULATOR_CLK_EQUAL_DATA_RATE;
    Sdfm1Regs.SDCTLPARM3.bit.MOD = SDFM_MODULATOR_CLK_EQUAL_DATA_RATE;
    Sdfm1Regs.SDCTLPARM4.bit.MOD = SDFM_MODULATOR_CLK_EQUAL_DATA_RATE;

    //
    // Comparator Unit - over and under value threshold settings
    //
    hlt = 0x7FFF;
    llt = 0x0000;

    //
    // Configure Comparator Unit's comparator filter type and comparator's
    // OSR value, higher threshold, lower threshold
    //
    Sdfm1Regs.SDCPARM1.bit.CS1_CS0 = 3;
    Sdfm1Regs.SDCPARM1.bit.COSR = 32 - 1;
    Sdfm1Regs.SDCPARM2.bit.CS1_CS0 = 3;
    Sdfm1Regs.SDCPARM2.bit.COSR = 32 - 1;
    Sdfm1Regs.SDCPARM3.bit.CS1_CS0 = 3;
    Sdfm1Regs.SDCPARM3.bit.COSR = 32 - 1;
    Sdfm1Regs.SDCPARM4.bit.CS1_CS0 = 3;
    Sdfm1Regs.SDCPARM4.bit.COSR = 32 - 1;
    Sdfm1Regs.SDCPARM1.bit.CEN = 1;
    Sdfm1Regs.SDCPARM2.bit.CEN = 1;
    Sdfm1Regs.SDCPARM3.bit.CEN = 1;
    Sdfm1Regs.SDCPARM4.bit.CEN = 1;


    //
    // Data filter Module
    //
    // Configure Data filter modules filter type, OSR value and
    // enable / disable data filter
    //
    // Data filter parameter
    Sdfm1Regs.SDDFPARM1.all |= 256 - 1;
//    Sdfm1Regs.SDDFPARM1.bit.DOSR = 128 - 1;  unsupport store byte command
    Sdfm1Regs.SDDFPARM1.bit.SST = 3;
    Sdfm1Regs.SDDFPARM1.bit.FEN = 1;
    Sdfm1Regs.SDDFPARM1.bit.AE = 1;

    // Data filter parameter
    Sdfm1Regs.SDDFPARM2.all |= 256 - 1;
//    Sdfm1Regs.SDDFPARM1.bit.DOSR = 128 - 1;  unsupport store byte command
    Sdfm1Regs.SDDFPARM2.bit.SST = 3;
    Sdfm1Regs.SDDFPARM2.bit.FEN = 1;
    Sdfm1Regs.SDDFPARM2.bit.AE = 1;

    // Data filter parameter
    Sdfm1Regs.SDDFPARM3.all |= 256 - 1;
//    Sdfm1Regs.SDDFPARM1.bit.DOSR = 128 - 1;  unsupport store byte command
    Sdfm1Regs.SDDFPARM3.bit.SST = 3;
    Sdfm1Regs.SDDFPARM3.bit.FEN = 1;
    Sdfm1Regs.SDDFPARM3.bit.AE = 1;

    // Data filter parameter
    Sdfm1Regs.SDDFPARM4.all |= 256 - 1;
//    Sdfm1Regs.SDDFPARM1.bit.DOSR = 128 - 1;  unsupport store byte command
    Sdfm1Regs.SDDFPARM4.bit.SST = 3;
    Sdfm1Regs.SDDFPARM4.bit.FEN = 1;
    Sdfm1Regs.SDDFPARM4.bit.AE = 1;

    // Data parameter
    Sdfm1Regs.SDDPARM1.bit.DR = 0;
    Sdfm1Regs.SDDPARM1.bit.SH = 10;
    // Data parameter
    Sdfm1Regs.SDDPARM2.bit.DR = 0;
    Sdfm1Regs.SDDPARM2.bit.SH = 10;
    // Data parameter
    Sdfm1Regs.SDDPARM3.bit.DR = 0;
    Sdfm1Regs.SDDPARM3.bit.SH = 10;
    // Data parameter
    Sdfm1Regs.SDDPARM4.bit.DR = 0;
    Sdfm1Regs.SDDPARM4.bit.SH = 10;



    //
    // Enable Master filter bit: Unless this bit is set none of the filter modules
    // can be enabled. All the filter modules are synchronized when master filter
    // bit is enabled after individual filter modules are enabled.
    //
    Sdfm1Regs.SDMFILEN.bit.MFE = 1;


    Sdfm1Regs.SDDFPARM1.bit.SDSYNCEN = 1;
    Sdfm1Regs.SDDFPARM2.bit.SDSYNCEN = 1;
    Sdfm1Regs.SDDFPARM3.bit.SDSYNCEN = 1;
    Sdfm1Regs.SDDFPARM4.bit.SDSYNCEN = 1;

    Sdfm1Regs.SDSYNC1.bit.SYNCSEL = SDFM_SYNC_PWM1_SOCA;



    //
    // Init EPWMs
    //
    initEPWM(pwmInstance);

    //
    // Enable interrupts
    //
    // Following SDFM interrupts can be enabled / disabled using this function.
    //  Enable / disable comparator high threshold
    //  Enable / disable comparator low threshold
    //  Enable / disable modulator clock failure
    //  Enable / disable filter acknowledge
    //
    Sdfm1Regs.SDCPARM1.bit.MFIE = 1;
    Sdfm1Regs.SDDFPARM1.bit.AE = 1;

    Sdfm1Regs.SDCPARM2.bit.MFIE = 1;
    Sdfm1Regs.SDDFPARM2.bit.AE = 1;

    Sdfm1Regs.SDCPARM3.bit.MFIE = 1;
    Sdfm1Regs.SDDFPARM3.bit.AE = 1;

    Sdfm1Regs.SDCPARM4.bit.MFIE = 1;
    Sdfm1Regs.SDDFPARM4.bit.AE = 1;


    Sdfm1Regs.SDCPARM1.bit.EN_CEVT1 = 0;
    Sdfm1Regs.SDCPARM1.bit.EN_CEVT2 = 0;

    Sdfm1Regs.SDCPARM2.bit.EN_CEVT1 = 0;
    Sdfm1Regs.SDCPARM2.bit.EN_CEVT2 = 0;

    Sdfm1Regs.SDCPARM3.bit.EN_CEVT1 = 0;
    Sdfm1Regs.SDCPARM3.bit.EN_CEVT2 = 0;

    Sdfm1Regs.SDCPARM4.bit.EN_CEVT1 = 0;
    Sdfm1Regs.SDCPARM4.bit.EN_CEVT2 = 0;

    Sdfm1Regs.SDCPARM1.bit.MFIE = 0;
    Sdfm1Regs.SDCPARM2.bit.MFIE = 0;
    Sdfm1Regs.SDCPARM3.bit.MFIE = 0;
    Sdfm1Regs.SDCPARM4.bit.MFIE = 0;

    while((HWREGH(pwmInstance + EPWM_O_TBCTR)) < 550);


    //
    // Enable master interrupt so that any of the filter interrupts can trigger
    // by SDFM interrupt to CPU
    //
    Sdfm1Regs.SDCTL.bit.MIE = 1;
}





