/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include <spi_ex05_board.h>

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void Board_init()
{
	Gpio_init();
	PinMux_init();
	SPI_init();
	INTERRUPT_init();
}
void Gpio_init()
{
    // Enable write on one pin as CS
    GPIO_enableWritePin(8);
}

void PinMux_init(void)
{
#if IS_GS32F00xx(0x12)
		// SPIA Pin Mux
		//SPIA_STE_GPIO0
		GPIO_setPinConfig(mySPI0_SPISTE_PIN_CONFIG);
		GPIO_setPadConfig(mySPI0_SPISTE_GPIO, GPIO_PIN_TYPE_STD|GPIO_PIN_TYPE_PULLUP);
		GPIO_setQualificationMode(mySPI0_SPISTE_GPIO, GPIO_QUAL_ASYNC);

		//SPIA_CLK_GPIO3
		GPIO_setPinConfig(mySPI0_SPICLK_PIN_CONFIG);
		GPIO_setPadConfig(mySPI0_SPICLK_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(mySPI0_SPICLK_GPIO, GPIO_QUAL_ASYNC);

		//SPIA_SIMO_GPIO2
		GPIO_setPinConfig(mySPI0_SPISIMO_PIN_CONFIG);
		GPIO_setPadConfig(mySPI0_SPISIMO_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(mySPI0_SPISIMO_GPIO, GPIO_QUAL_ASYNC);

		//SPIA_SOMI_GPIO1
		GPIO_setPinConfig(mySPI0_SPISOMI_PIN_CONFIG);
		GPIO_setPadConfig(mySPI0_SPISOMI_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(mySPI0_SPISOMI_GPIO, GPIO_QUAL_ASYNC);
#elif IS_GS32F3xx(0x22)
		// SPIB Pin Mux
		//SPIB_STE_GPIO66
		GPIO_setPinConfig(mySPI0_SPISTE_PIN_CONFIG);
		GPIO_setPadConfig(mySPI0_SPISTE_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(mySPI0_SPISTE_GPIO, GPIO_QUAL_ASYNC);

		//SPIB_CLK_GPIO65
		GPIO_setPinConfig(mySPI0_SPICLK_PIN_CONFIG);
		GPIO_setPadConfig(mySPI0_SPICLK_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(mySPI0_SPICLK_GPIO, GPIO_QUAL_ASYNC);

		//SPIB_SIMO_GPIO63
		GPIO_setPinConfig(mySPI0_SPISIMO_PIN_CONFIG);
		GPIO_setPadConfig(mySPI0_SPISIMO_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(mySPI0_SPISIMO_GPIO, GPIO_QUAL_ASYNC);

		//SPIB_SOMI_GPIO64
		GPIO_setPinConfig(mySPI0_SPISOMI_PIN_CONFIG);
		GPIO_setPadConfig(mySPI0_SPISOMI_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(mySPI0_SPISOMI_GPIO, GPIO_QUAL_ASYNC);
#endif
}

void INTERRUPT_init(void)
{
	Interrupt_register(INT_SPIB,spiFIFOISR);
	Interrupt_enable(INT_SPIB);
}

void SPI_init(void)
{
	mySPI_init();
}

void mySPI_init(void)
{
    // Disable the SSI module before initialization
	SPI_disableModule(mySPI_BASE);

	// Initialize SSI
	SPI_setConfig(mySPI_BASE,DEVICE_APBCLK_FREQ,SPI_PROT_POL0PHA0,\
			SPI_MODE_CONTROLLER,mySPI_BITRATE,mySPI_DATAWIDTH);

    // Sets the FIFO level at which interrupts are generated.
    SPI_setFIFOInterruptLevel(mySPI_BASE, SPI_FIFO_TX16, SPI_FIFO_RX16);

	// Disable all interrupt
	SPI_disableAllInterrupt(mySPI_BASE);

	// Clear all interrupt
	SPI_clearAllInterruptStatus(mySPI_BASE);

    // Enable interrupt
	SPI_enableInterrupt(mySPI_BASE,SPI_INT_RXFF_OVERFLOW | SPI_INT_RXFF_UNDERFLOW | SPI_INT_TXFF_OF);

	// Open loop
	SPI_disableLoopback(mySPI_BASE);

    // Enable the SSI module before initialization
    SPI_enableModule(mySPI_BASE);

    // enable CS to transmit!!
    // SPI_csEnable(mySPI_BASE);

}





#ifdef __cplusplus
}
#endif

