/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    board.h
*   @brief
*   @details
*
*/

#ifndef SPI_EX06_BOARD_H_
#define SPI_EX06_BOARD_H_

#ifdef __cplusplus
extern "C"
{
#endif

/* ========================================================================== */
/*                               Include Files                                */
/* ========================================================================== */
#include "device.h"
#include "driverlib.h"
#include "board_cfg.h"

// The number of data to be sent
#define TEST_DATA_COUNT		256
// The number of cmd to be sent
#define TEST_CMD_COUNT		4
// The number of sum of data and cmd
#define TEST_ALL_COUNT	(TEST_DATA_COUNT+TEST_CMD_COUNT)

#define RX_INDEX (TEST_ALL_COUNT-SPI_FIFO_RX8)

// read operation : read data array
extern uint8_t rcv_data[TEST_DATA_COUNT];

//write operation : read data array
extern uint8_t rcv_virdata[TEST_DATA_COUNT+TEST_CMD_COUNT];
//write operation : write data array (The first four fields are commands)
extern uint8_t send_cmd[TEST_DATA_COUNT+TEST_CMD_COUNT];

/* ========================================================================== */
/*                            Gpio Configuration                            */
/* ========================================================================== */
#define GPIO_SPI_CS 8
#define CS_HIGH		    GPIO_writePin(GPIO_SPI_CS,1);
#define CS_LOW		    GPIO_writePin(GPIO_SPI_CS,0);

/* ========================================================================== */
/*                            PinMux Configuration                            */
/* ========================================================================== */

#if IS_GS32F00xx(0x12)
//
// SPIA -> mySPI0 Pinmux
//
//
// SPIA_SIMO - GPIO Settings
//
#define GPIO_PIN_SPIX_SIMO 2
#define mySPI0_SPISIMO_GPIO 2
#define mySPI0_SPISIMO_PIN_CONFIG GPIO_2_SPIA_SIMO
//
// SPIA_SOMI - GPIO Settings
//
#define GPIO_PIN_SPIX_SOMI 1
#define mySPI0_SPISOMI_GPIO 1
#define mySPI0_SPISOMI_PIN_CONFIG GPIO_1_SPIA_SOMI
//
// SPIA_CLK - GPIO Settings
//
#define GPIO_PIN_SPIX_CLK 3
#define mySPI0_SPICLK_GPIO 3
#define mySPI0_SPICLK_PIN_CONFIG GPIO_3_SPIA_CLK
//
// SPIA_STE - GPIO Settings
//
#define GPIO_PIN_SPIX_STE 0
#define mySPI0_SPISTE_GPIO 0
#define mySPI0_SPISTE_PIN_CONFIG GPIO_0_SPIA_STE

#elif IS_GS32F3xx(0x22)
//
// SPIB -> mySPI0 Pinmux
//
//
// SPIB_SIMO - GPIO Settings
//
#define GPIO_PIN_SPIX_SIMO 63
#define mySPI0_SPISIMO_GPIO 63
#define mySPI0_SPISIMO_PIN_CONFIG GPIO_63_SPISIMOB
//
// SPIB_SOMI - GPIO Settings
//
#define GPIO_PIN_SPIX_SOMI 64
#define mySPI0_SPISOMI_GPIO 64
#define mySPI0_SPISOMI_PIN_CONFIG GPIO_64_SPISOMIB
//
// SPIB_CLK - GPIO Settings
//
#define GPIO_PIN_SPIX_CLK 65
#define mySPI0_SPICLK_GPIO 65
#define mySPI0_SPICLK_PIN_CONFIG GPIO_65_SPICLKB
//
// SPIB_STE - GPIO Settings
//
#define GPIO_PIN_SPIX_STE 66
#define mySPI0_SPISTE_GPIO 66
#define mySPI0_SPISTE_PIN_CONFIG GPIO_66_SPISTEB

#endif

/* ========================================================================== */
/*                          INTERRUPT Configurations                          */
/* ========================================================================== */
// Interrupt Function
extern void spiFIFOISR(void);

/* ========================================================================== */
/*                             SPI Configurations                             */
/* ========================================================================== */
#if IS_GS32F00xx(0x12)
#define mySPI_BASE SPIA_BASE
#define mySPI_INT INT_SPIA
#elif IS_GS32F3xx(0x22)
#define mySPI_BASE SPIB_BASE
#define mySPI_INT INT_SPIB
#endif
#define mySPI_BITRATE 1000000
#define mySPI_DATAWIDTH 8
void mySPI_init(void);

/* ========================================================================== */
/*                             DMA Configurations                             */
/* ========================================================================== */
#define mySPI0_TX_DMA_BASE DMA1_CH1_BASE
void mySPI0_TX_DMA_init();

#define mySPI0_RX_DMA_BASE DMA1_CH2_BASE
void mySPI0_RX_DMA_init();

#if IS_GS32F00xx(0x12)
#define INT_DMA_CH0	INT_DMA1_CH1
#define INT_DMA_CH1	INT_DMA1_CH2
#elif IS_GS32F3xx(0x22)
#define INT_DMA_CH0	INT_DMA1_CH1
#define INT_DMA_CH1	INT_DMA1_CH2
#endif

#define mySPI0_RX_DMA_ADDRESS ((uint32_t)(mySPI_BASE + SPI_O_DATAREG))
#define mySPI0_TX_DMA_ADDRESS ((uint32_t)(mySPI_BASE + SPI_O_DATAREG))

extern void DMA_Tx_IRQHandler();
extern void DMA_Rx_IRQHandler();
/* ========================================================================== */
/*                            Board Configurations                            */
/* ========================================================================== */
void	Board_init();
void	GPIO_init();
void	INTERRUPT_init();
void	SPIX_init();
void	DMA_init();
void	PinMux_init();

#ifdef __cplusplus
}
#endif

#endif /* SPI_EX06_BOARD_H_ */
