
#include <spi_ex07_board.h>

//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules.
// Call this function in your application if you wish to do all module
// initialization.
// If you wish to not use some of the initializations, instead of the
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
	EALLOW;

	PinMux_init();
	DMA_init();
	SPIX_init();
	INTERRUPT_init();

	EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{
	/*
	 * PinMux for modules assigned to CPU1
	 */
	/* SPIC Pin Mux */
	/* SPIB_STE */
	GPIO_setPinConfig(mySPI1_SPISTE_PIN_CONFIG);
	GPIO_setPadConfig(mySPI1_SPISTE_GPIO, GPIO_PIN_TYPE_STD|GPIO_PIN_TYPE_PULLUP);
	GPIO_setQualificationMode(mySPI1_SPISTE_GPIO, GPIO_QUAL_ASYNC);

	/* SPIB_CLK */
	GPIO_setPinConfig(mySPI1_SPICLK_PIN_CONFIG);
	GPIO_setPadConfig(mySPI1_SPICLK_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI1_SPICLK_GPIO, GPIO_QUAL_ASYNC);

	/* SPIB_SIMO */
	GPIO_setPinConfig(mySPI1_SPISIMO_PIN_CONFIG);
	GPIO_setPadConfig(mySPI1_SPISIMO_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI1_SPISIMO_GPIO, GPIO_QUAL_ASYNC);

	/* SPIB_SOMI */
	GPIO_setPinConfig(mySPI1_SPISOMI_PIN_CONFIG);
	GPIO_setPadConfig(mySPI1_SPISOMI_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI1_SPISOMI_GPIO, GPIO_QUAL_ASYNC);

}

//*****************************************************************************
//
// DMA Configurations
//
//*****************************************************************************
void DMA_init(){
#if IS_GS32F00xx(0x12)
    DMA_initController(DMA_BASE);
    DMA_enableInterrupt(DMA1_BASE);
#elif IS_GS32F3xx(0x22)
    XDMA_initController(DMA1_BASE);
    XDMA_enableInterrupt(DMA1_BASE);
#endif
	mySPI0_RX_DMA_init();
	mySPI0_TX_DMA_init();


}

void mySPI0_TX_DMA_init(){
#if IS_GS32F00xx(0x12)
	DMA_stopChannel(mySPI0_TX_DMA_BASE);
	DMA_ConfigParams dma1Cfg = {0};
	dma1Cfg.enableInterrupt = 1;
	//enable DMA Trigger by DMA MUX
	dma1Cfg.dmaDstReqId = DMAMUX_ReqId_spi1_tx;
	dma1Cfg.srcAddr = (uint32_t)(send);
	dma1Cfg.destAddr = mySPI0_TX_DMA_ADDRESS;
	dma1Cfg.blockTS = 128;
	dma1Cfg.ttfc    = DMA_TT_FC_1_M2P_DMAC;
	dma1Cfg.srcBtl  = DMA_BTL_4;
	dma1Cfg.destBtl = DMA_BTL_4;
	dma1Cfg.srcAddrDirect = DMA_ADDR_INCRE;
	dma1Cfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
	dma1Cfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_2;
	dma1Cfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_2;
	dma1Cfg.srcHkSelect = DMA_HKS_SOFTWARE;
	dma1Cfg.srcHardInf = DMA_HKS_HARD_INF_0;
	dma1Cfg.destHkSelect = DMA_HKS_HARDWARE;
	dma1Cfg.destHardInf = DMA_HKS_HARD_INF_1;
	DMA_configChannel(mySPI0_TX_DMA_BASE, &dma1Cfg);
	DMA_clearInterrupt(mySPI0_TX_DMA_BASE, DMA_INT_TFR);
	DMA_unMaskInterrupt(mySPI0_TX_DMA_BASE, DMA_INT_TFR);
#elif IS_GS32F3xx(0x22)
    XDMA_stopChannel(mySPI0_TX_DMA_BASE);
    XDMA_ConfigParams dmaCfg1 = {0};
    dmaCfg1.enableInterrupt = 1;
    dmaCfg1.dmaDstReqId = DMAMUX_ReqId_spi2_tx;
    dmaCfg1.srcAddr = (uint32_t)(&send[0]);
    dmaCfg1.destAddr = mySPI0_TX_DMA_ADDRESS;
    dmaCfg1.blockTS = 128;
    dmaCfg1.ttfc    = XDMA_TT_FC_1_M2P_DMAC;
    dmaCfg1.srcBtl  = XDMA_BTL_4;
    dmaCfg1.destBtl = XDMA_BTL_4;
    dmaCfg1.srcAddrDirect = XDMA_ADDR_INCRE;
    dmaCfg1.destAddrDirect = XDMA_ADDR_NO_CHANGE;
    dmaCfg1.reloadSrc = TRUE;
    dmaCfg1.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_2;
    dmaCfg1.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_2;
    XDMA_configChannel(mySPI0_TX_DMA_BASE, &dmaCfg1);
    XDMA_unMaskInterrupt(mySPI0_TX_DMA_BASE, XDMA_INT_BLOCK);
    XDMA_clearInterrupt(mySPI0_TX_DMA_BASE, XDMA_INT_BLOCK);
#endif
}

void mySPI0_RX_DMA_init(){
#if IS_GS32F00xx(0x12)
	DMA_stopChannel(mySPI0_RX_DMA_BASE);
	DMA_ConfigParams dma2Cfg = {0};
	dma2Cfg.enableInterrupt = 1;
	dma2Cfg.dmaSrcReqId = DMAMUX_ReqId_spi1_rx;
	dma2Cfg.srcAddr = mySPI0_RX_DMA_ADDRESS;
	dma2Cfg.destAddr = (uint32_t)(recive);
	dma2Cfg.blockTS = 128;
	dma2Cfg.ttfc    = DMA_TT_FC_2_P2M_DMAC;
	dma2Cfg.srcBtl  = DMA_BTL_4;
	dma2Cfg.destBtl = DMA_BTL_4;
	dma2Cfg.srcAddrDirect = DMA_ADDR_NO_CHANGE;
	dma2Cfg.destAddrDirect = DMA_ADDR_INCRE;
	dma2Cfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_2;
	dma2Cfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_2;
	dma2Cfg.srcHkSelect = DMA_HKS_HARDWARE;
	dma2Cfg.srcHardInf = DMA_HKS_HARD_INF_2;
	dma2Cfg.destHkSelect = DMA_HKS_SOFTWARE;
	dma2Cfg.destHardInf = DMA_HKS_HARD_INF_3;
	DMA_configChannel(mySPI0_RX_DMA_BASE, &dma2Cfg);
	DMA_clearInterrupt(mySPI0_RX_DMA_BASE, DMA_INT_TFR);
	DMA_unMaskInterrupt(mySPI0_RX_DMA_BASE, DMA_INT_TFR);
#elif IS_GS32F3xx(0x22)
    XDMA_stopChannel(mySPI0_RX_DMA_BASE);
    XDMA_ConfigParams dmaCfg2 = {0};
    dmaCfg2.enableInterrupt = 1;
    dmaCfg2.dmaSrcReqId = DMAMUX_ReqId_spi2_rx;
    dmaCfg2.srcAddr = mySPI0_RX_DMA_ADDRESS;
    dmaCfg2.destAddr = (uint32_t)(&recive[0]);
    dmaCfg2.blockTS = 128;
    dmaCfg2.ttfc    = XDMA_TT_FC_2_P2M_DMAC;
    dmaCfg2.srcBtl  = XDMA_BTL_4;
    dmaCfg2.destBtl = XDMA_BTL_4;
    dmaCfg2.srcAddrDirect = XDMA_ADDR_NO_CHANGE;
    dmaCfg2.destAddrDirect = XDMA_ADDR_INCRE;
    dmaCfg2.reloadDst = TRUE;
    dmaCfg2.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_2;
    dmaCfg2.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_2;
    XDMA_unMaskInterrupt(mySPI0_RX_DMA_BASE, XDMA_INT_BLOCK);
    XDMA_clearInterrupt(mySPI0_RX_DMA_BASE, XDMA_INT_BLOCK);
    XDMA_configChannel(mySPI0_RX_DMA_BASE, &dmaCfg2);

#endif
}


//*****************************************************************************
//
// INTERRUPT Configurations
//
//*****************************************************************************
void INTERRUPT_init(){
	// Interrupt Setings for INT_mySPI0_RX_DMA
	Interrupt_register(INT_mySPI0_RX_DMA, &INT_mySPI0_RX_DMA_ISR);
	Interrupt_enable(INT_mySPI0_RX_DMA);

	// Interrupt Setings for INT_mySPI0_TX_DMA
	Interrupt_register(INT_mySPI0_TX_DMA, &INT_mySPI0_TX_DMA_ISR);
	Interrupt_enable(INT_mySPI0_TX_DMA);

	Interrupt_register(INT_SPIB, &spiRxFIFOISR);
	Interrupt_enable(INT_SPIB);
}
//*****************************************************************************
//
// SPI Configurations
//
//*****************************************************************************
void SPIX_init(){
	mySPI0_init();
}

void mySPI0_init()
{
	SPI_disableModule(mySPI_BASE);

	SPI_setConfig(mySPI_BASE, DEVICE_APBCLK_FREQ, SPI_PROT_POL0PHA0,
				  SPI_MODE_CONTROLLER, 500000, 16);

	// Open loop
	SPI_disableLoopback(mySPI_BASE);

    // Sets the FIFO level at which interrupts are generated.
    SPI_setFIFOInterruptLevel(mySPI_BASE, SPI_FIFO_TX1, SPI_FIFO_RX1);

	// Disable all interrupt
    SPI_disableAllInterrupt(mySPI_BASE);

	// Clear all interrupt
	SPI_clearAllInterruptStatus(mySPI_BASE);

    // Enable interrupt
	SPI_enableInterrupt(mySPI_BASE, SPI_INT_RXFF_OVERFLOW | SPI_INT_RXFF_UNDERFLOW | SPI_INT_TXFF_OF);

	SPI_enableLoopback(mySPI_BASE);

	// Set Tx FIFO level to start DMA transfer
	SPI_setDmaTxDataLevel(mySPI_BASE,SPI_FIFO_TX4);

	// Set Rx FIFO level to start DMA receive
	SPI_setDmaRxDataLevel(mySPI_BASE,SPI_FIFO_RX4);

	// enable DMA transfer function
	SPI_enableTransmitDMA(mySPI_BASE);

	// enable DMA receive function
	SPI_enableReceiveDMA(mySPI_BASE);

	SPI_enableModule(mySPI_BASE);

}
