/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "spi_tri_wire.h"
#include "log.h"
#include "spi.h"
#include "device.h"

static
void __master_pin_init(void)
{
    GPIO_setPinConfig(CONFIG_SPI_MASTER_CLK);
    GPIO_setPadConfig(CONFIG_SPI_MASTER_CLK_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(CONFIG_SPI_MASTER_CLK_GPIO, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(CONFIG_SPI_MASTER_SIMO);
    GPIO_setPadConfig(CONFIG_SPI_MASTER_SIMO_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(CONFIG_SPI_MASTER_SIMO_GPIO, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(CONFIG_SPI_MASTER_SOMI);
    GPIO_setPadConfig(CONFIG_SPI_MASTER_SOMI_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(CONFIG_SPI_MASTER_SOMI_GPIO, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(CONFIG_SPI_MASTER_CS);
    GPIO_setPadConfig(CONFIG_SPI_MASTER_CS_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(CONFIG_SPI_MASTER_CS_GPIO, GPIO_QUAL_ASYNC);
}

static
void __slave_pin_init(void)
{
    GPIO_setPinConfig(CONFIG_SPI_SLAVE_CLK);
    GPIO_setPadConfig(CONFIG_SPI_SLAVE_CLK_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(CONFIG_SPI_SLAVE_CLK_GPIO, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(CONFIG_SPI_SLAVE_SIMO);
    GPIO_setPadConfig(CONFIG_SPI_SLAVE_SIMO_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(CONFIG_SPI_SLAVE_SIMO_GPIO, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(CONFIG_SPI_SLAVE_SOMI);
    GPIO_setPadConfig(CONFIG_SPI_SLAVE_SOMI_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(CONFIG_SPI_SLAVE_SOMI_GPIO, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(CONFIG_SPI_SLAVE_CS);
    GPIO_setPadConfig(CONFIG_SPI_SLAVE_CS_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(CONFIG_SPI_SLAVE_CS_GPIO, GPIO_QUAL_ASYNC);
}

void spi_master_init(void)
{

    log_info("03_spi_external_loopback_master start!\n");

    /** <\ @brief enable SPIA and SPIB clk, same as APB bus. */
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_SPI);
    /** <\ @brief reset SPIA and SPIB. */
    SysCtl_resetSpi();
    /** <\ @brief SPI pins initial. */
    __master_pin_init();

    /** <\ @brief holed SPI in reset state before configure SPI. */
    SPI_disableModule(CONFIG_SPI_MASTER_BASE);

    SPI_setConfig(CONFIG_SPI_MASTER_BASE, DEVICE_APBCLK_FREQ,
                  SPI_PROT_POL0PHA0, SPI_MODE_CONTROLLER,
                  CONFIG_SPI_BITRATE, CONFIG_SPI_DATAWIDTH);

    SPI_setPTESignalPolarity(CONFIG_SPI_MASTER_BASE, SPI_PTE_ACTIVE_LOW);
    SPI_disableFIFO(CONFIG_SPI_MASTER_BASE);

    SPI_setEmulationMode(CONFIG_SPI_MASTER_BASE, SPI_EMULATION_FREE_RUN);

    SPI_disableInterrupt(CONFIG_SPI_MASTER_BASE,
                         SPI_INT_RX_OVERRUN |
                         SPI_INT_RX_DATA_TX_EMPTY |
                         SPI_INT_RXFF |
                         SPI_INT_TXFF);

    SPI_enableTriWire(CONFIG_SPI_MASTER_BASE);

    SPI_disableLoopback(CONFIG_SPI_MASTER_BASE);
    /** <\ @brief release SPI. */
    SPI_enableModule(CONFIG_SPI_MASTER_BASE);
}

void spi_slave_init(void)
{
    log_info("03_spi_external_loopback_master start!\n");

    /** <\ @brief enable SPIA and SPIB clk, same as APB bus. */
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_SPI);
    /** <\ @brief reset SPIA and SPIB. */
    SysCtl_resetSpi();
    /** <\ @brief SPI pins initial. */
    __slave_pin_init();

    /** <\ @brief holed SPI in reset state before configure SPI. */
    SPI_disableModule(CONFIG_SPI_SLAVE_BASE);

    SPI_setConfig(CONFIG_SPI_SLAVE_BASE, DEVICE_APBCLK_FREQ,
                  SPI_PROT_POL0PHA0, SPI_MODE_PERIPHERAL,
                  CONFIG_SPI_BITRATE, CONFIG_SPI_DATAWIDTH);

    SPI_setPTESignalPolarity(CONFIG_SPI_SLAVE_BASE, SPI_PTE_ACTIVE_LOW);
    SPI_disableFIFO(CONFIG_SPI_SLAVE_BASE);

    SPI_setEmulationMode(CONFIG_SPI_SLAVE_BASE, SPI_EMULATION_FREE_RUN);

    SPI_disableInterrupt(CONFIG_SPI_SLAVE_BASE,
                         SPI_INT_RX_OVERRUN |
                         SPI_INT_RX_DATA_TX_EMPTY |
                         SPI_INT_RXFF |
                         SPI_INT_TXFF);

    SPI_enableTriWire(CONFIG_SPI_SLAVE_BASE);

    SPI_disableLoopback(CONFIG_SPI_SLAVE_BASE);
    /** <\ @brief release SPI. */
    SPI_enableModule(CONFIG_SPI_SLAVE_BASE);
}
