/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "string.h"
#include "board_cfg.h"
#include "inc/hw_types.h"
#include "sci_ex06_rx_irq.h"

#define SEND_DATA_LEN   16
#define RCVE_DATA_LEN	16

uint8_t send_buff[SEND_DATA_LEN];
uint8_t rcv_buff[RCVE_DATA_LEN];
volatile uint32_t send_buff_count = 0;
volatile uint32_t rcv_buff_count = 0;
volatile uint8_t TxIrq_finish_Flag = 0;
volatile uint8_t RxIrq_finish_Flag = 0;
volatile uint32_t intoIRQCount = 0;

void UART_Clock_Init();
void UART_GPIO_Init();
void SCI_Init(uint32_t SCIBase,uint32_t baud);
void SCI_Interrupt_Init(uint32_t SCIBase,uint32_t interrupt_numbers);

void UART_Init(uint32_t SCIBase,uint32_t baud)
{
	UART_Clock_Init();
	UART_GPIO_Init();
	SCI_Init(SCIBase,baud);
	SCI_Interrupt_Init(SCIBase,MY_SCI_INTERRUPT_NUM);
}

__INTERRUPT void SCIx_INTR_IRQHandler(void)
{
	SAVE_IRQ_CSR_CONTEXT();

    volatile uint32_t irq_status = 0;
    volatile uint32_t RxFIFO_len = 0;

    irq_status = SCI_getInterruptStatus(MY_SCI_BASE);
    intoIRQCount++;

    switch (irq_status) {
		case SCI_THR_EMPTY:				//Ϳ
			{

				Interrupt_disable(MY_SCI_INTERRUPT_NUM);
				char temp[32];
				sprintf(temp,"[IRQ Send]into irq count:%d\r\n",intoIRQCount);
				UART_writeCharArray(MY_SCI_BASE, temp, strlen(temp));
//				SCI_enableInterrupt(MY_SCI_BASE,MY_SCI_INTERRUPT_NUM);

				TxIrq_finish_Flag = 1;

				/* жϱ־λ(ǰѶȡ)
				SCI_getInterruptStatus(MY_SCI_BASE);
				*/
			}
			break;

		default:
		       SCI_clearInterruptStatus(MY_SCI_BASE);
		       return;
			break;
	}

    RESTORE_IRQ_CSR_CONTEXT();
}

void sci_ex06_rx_irq_Example(uint32_t SCI_BASE)
{
    // wait the shift register empty
    while(SCI_isSpaceAvailableNonFIFO(SCI_BASE) == 0);

    /* Fill data into send_data.
     * The Array send_buff: 0X410x420x430x44 */
    for (int i = 0; i < SEND_DATA_LEN; i++)
    {
    	send_buff[send_buff_count++] = i+0x41;
	}

	while(1)
	{
		if(TxIrq_finish_Flag == 1)
		{
			UART_writeCharArray(MY_SCI_BASE, "send_buff data:", 15);
			UART_writeCharArray(MY_SCI_BASE, send_buff,send_buff_count);
			UART_writeCharArray(MY_SCI_BASE, "\r\n", 2);
			return ;
		}
	}
}


void UART_Clock_Init()
{
	/*
	 * Actual clock initialization is performed in Device_init()
	 * */
}
void UART_GPIO_Init()
{
    GPIO_setPadConfig(SCI_TX_GPIO, GPIO_PIN_TYPE_PULLUP);
    GPIO_setPadConfig(SCI_RX_GPIO, GPIO_PIN_TYPE_PULLUP);

    GPIO_setPinConfig(SCI_TX_GPIO_MUX);
    GPIO_setPinConfig(SCI_RX_GPIO_MUX);
}
void SCI_Init(uint32_t SCIBase,uint32_t baud)
{
	/* SCI RESET ensure SCI is IDLE */
    SCI_reset(SCIBase);

    SCI_setBaud(SCIBase, DEVICE_APBCLK_FREQ, baud);
    SCI_setInitConfig(SCIBase, SCI_CONFIG_PAR_NONE, SCI_STOP_1BIT, SCI_CHAR_8BITS);

    /* SCI clear Reset */
    SCI_ClearReset(SCIBase);

    SCI_enableFIFO(SCIBase);
}
void SCI_Interrupt_Init(uint32_t SCIBase,uint32_t interrupt_numbers)
{
    // Enable receive available interrupt and Receiver Line Status Interrupt
	SCI_enableInterrupt(SCIBase, SCI_TX_EMPTY_INT);
    SCI_setFIFOInterruptLevel(SCIBase, SCI_FIFO_TX0, SCI_FIFO_RX8);
    Interrupt_register(interrupt_numbers, SCIx_INTR_IRQHandler);
    Interrupt_enable(interrupt_numbers);
}


