/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * @example: polling
 * @Language:English
 * @encode:
 * @brief:
 *	This program demonstrates the function of using polling to receive data,
 *	and sets an end character to indicate that data transmission is complete.
 *	End character: 0x55AA
 *
 *	Note:
 *		1. When setting the SCI baud rate, it should be ensured that SCI is in an idle state.
 *			SCI can be made idle through the SCI_deset() function before setting the baud rate.
 * */

/*
 * @example: polling
 * @Language:Chinese
 * @encode:GBK
 * @brief:
 *	ʾʹѯݵĹ,趨ַʾݴϡ ַ0x55AA
 *
 *	ע⣺
 *		1SCIʱӦ֤SCIڿ״̬ͨSCI_reset()ʹSCIУٽвá
 * */

#include "device.h"
#include "sci_ex07_polling.h"


int main(void)
{
	/* initialize the Flash and System Clock, and enable the clocks for all peripherals. */
    Device_init();

    UART_Init(MY_SCI_BASE, 115200);

    UART_writeCharArray(MY_SCI_BASE, "SCI_ex04_polling start \r\n", 25);

    /* Run polling test */
    sci_ex07_polling_Example(MY_SCI_BASE);

    UART_writeCharArray(MY_SCI_BASE, "SCI_ex04_polling end \r\n", 23);

    for(;;);
    return 0;
}




