/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <sci_ex10_MaxBaud_receive.h>

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "string.h"
#include "board_cfg.h"
#include "inc/hw_types.h"


uint32_t intoIrq_count = 0;
uint32_t Interrupt_status = 0;
uint32_t irq_readData_count = 0;


uint8_t send_buff[SEND_DATA_LEN];
uint8_t rcv_buff[RCVE_DATA_LEN];
uint32_t rcv_buff_index = 0;
uint32_t rcvData_righful_flag = 0;


uint32_t CRC16_verify = 0xff;
uint32_t CRC16_error_count = 0;


void UART_Init(uint32_t SCIBase,uint32_t baud)
{
	UART_Clock_Init();
	UART_GPIO_Init();
	SCI_Init(SCIBase,baud);
	SCI_Interrupt_Init(SCIBase,MY_SCI_INTERRUPT_NUM);
}

__INTERRUPT void SCIx_INTR_IRQHandler(void)
{
	SAVE_IRQ_CSR_CONTEXT();

	intoIrq_count++;
	Interrupt_status = SCI_getInterruptStatus(MY_SCI_BASE);
    switch (Interrupt_status) {
		case SCI_CHARACTER_TIMEOUT:
		case SCI_RX_DATA_AVAILABLE:
		{
		    while(SCI_getRxFIFOStatus(MY_SCI_BASE) != SCI_RX_FIFO_0)
		    {
		    	if( SCI_rxDataReady(MY_SCI_BASE) )
		    	{
		    		irq_readData_count++;
		    		rcv_buff[rcv_buff_index++] = SCI_readCharBlockingFIFO(MY_SCI_BASE);
		    	}
		    }

		    /* receive over. */
		    if(rcv_buff_index >= 0x0f)
		    {
		    	rcv_buff_index = 0;
		    	/* CRC calculate */
		    	CRC16_verify = calculate_CRC16(rcv_buff,sizeof(rcv_buff));
			    if(CRC16_verify != 0x0000)
			    {
			        CRC16_error_count++;
			    }
			    rcvData_righful_flag = 1;
		    }

		}
			break;
		default:
	        SCI_clearInterruptStatus(MY_SCI_BASE);
	        return;
			break;
	}

    RESTORE_IRQ_CSR_CONTEXT();
}

void sci_ex10_MaxBaud_Example(uint32_t SCI_BASE)
{
	while(1)
	{
		if(rcvData_righful_flag == 1)
		{
			/* todo processing data
			 *
			 * process_data();
			 *
			 *  */
			rcvData_righful_flag = 0;
		}
	}
}



uint16_t calculate_CRC16(uint8_t *data,uint16_t length)
{
    uint16_t remainder = 0;

    for(int i = 0;i<length;i=i+2)
    {
        remainder = remainder ^ ((data[i]<<8)+data[i+1]);
        for(int j = 0;j<16;j++)
        {
            if(remainder & 0x8000)
            {
                remainder = (remainder<<1) ^ CRC16_POLY;
            }
            else
            {
                remainder <<= 1;
            }
        }
    }
    return remainder;
}



void UART_Clock_Init()
{
	/*
	 * Actual clock initialization is performed in Device_init()
	 * */
}
void UART_GPIO_Init()
{
    GPIO_setPadConfig(SCI_TX_GPIO, GPIO_PIN_TYPE_PULLUP);
    GPIO_setPadConfig(SCI_RX_GPIO, GPIO_PIN_TYPE_PULLUP);

    GPIO_setPinConfig(SCI_TX_GPIO_MUX);
    GPIO_setPinConfig(SCI_RX_GPIO_MUX);
}
void SCI_Init(uint32_t SCIBase,uint32_t baud)
{
	/* SCI RESET ensure SCI is IDLE */
    SCI_reset(SCIBase);

    SCI_setBaud(SCIBase, DEVICE_APBCLK_FREQ, baud);
    SCI_setInitConfig(SCIBase, SCI_CONFIG_PAR_NONE, SCI_STOP_1BIT, SCI_CHAR_8BITS);

    /* SCI clear Reset */
    SCI_ClearReset(SCIBase);

    SCI_enableFIFO(SCIBase);
}
void SCI_Interrupt_Init(uint32_t SCIBase,uint32_t interrupt_numbers)
{
    // Enable receive available interrupt and Receiver Line Status Interrupt
    SCI_enableInterrupt(SCIBase, SCI_RX_DATA_AVAILABLE_INT | SCI_LINE_STATUS_INT);
    SCI_setFIFOInterruptLevel(SCIBase, SCI_FIFO_TX0, SCI_FIFO_RX14);
    Interrupt_register(interrupt_numbers, SCIx_INTR_IRQHandler);
    Interrupt_enable(interrupt_numbers);
}


