/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "string.h"
#include "board_cfg.h"
#include "inc/hw_types.h"
#include "sci_ex10_MaxBaud_send.h"


void UART_Init(uint32_t SCIBase,uint32_t baud)
{
	UART_Clock_Init();
	UART_GPIO_Init();
	SCI_Init(SCIBase,baud);
}

void sci_ex04_rx_irq_TimeOut_Example(uint32_t SCI_BASE)
{

}


uint16_t calculate_CRC16(uint8_t *data,uint16_t length)
{
    uint16_t remainder = 0;

    for(int i = 0;i<length;i=i+2)
    {
        remainder = remainder ^ ((data[i]<<8)+data[i+1]);
        for(int j = 0;j<16;j++)
        {
            if(remainder & 0x8000)
            {
                remainder = (remainder<<1) ^ CRC16_POLY;
            }
            else
            {
                remainder <<= 1;
            }
        }
    }
    return remainder;
}


void UART_Clock_Init()
{
	/*
	 * Actual clock initialization is performed in Device_init()
	 * */
}
void UART_GPIO_Init()
{
    GPIO_setPadConfig(SCI_TX_GPIO, GPIO_PIN_TYPE_PULLUP);
    GPIO_setPadConfig(SCI_RX_GPIO, GPIO_PIN_TYPE_PULLUP);

    GPIO_setPinConfig(SCI_TX_GPIO_MUX);
    GPIO_setPinConfig(SCI_RX_GPIO_MUX);
}
void SCI_Init(uint32_t SCIBase,uint32_t baud)
{
	/* SCI RESET ensure SCI is IDLE */
    SCI_reset(SCIBase);

    SCI_setBaud(SCIBase, DEVICE_APBCLK_FREQ, baud);
    SCI_setInitConfig(SCIBase, SCI_CONFIG_PAR_NONE, SCI_STOP_1BIT, SCI_CHAR_8BITS);

    /* SCI clear Reset */
    SCI_ClearReset(SCIBase);

    SCI_enableFIFO(SCIBase);
}

