//#############################################################################
//
// FILE:   sci_ex3_echoback.c
//
// TITLE:  SCI echoback example.
//
//! \addtogroup driver_example_list
//! <h1>SCI Echoback</h1>
//!
//!  This test receives and echo-backs data through the SCI-A port.
//!
//!  A terminal such as 'putty' can be used to view the data from
//!  the SCI and to send information to the SCI. Characters received
//!  by the SCI port are sent back to the host.
//!
//!  \b Running \b the \b Application
//!  Open a COM port with the following settings using a terminal:
//!  -  Find correct COM port
//!  -  Bits per second = 115200
//!  -  Data Bits = 8
//!  -  Parity = None
//!  -  Stop Bits = 1
//!  -  Hardware Control = None
//!
//!  The program will print out a greeting and then ask you to
//!  enter a character which it will echo back to the terminal.
//!
//!  \b Watch \b Variables \n
//!  - loopCounter - the number of characters sent
//!
//! \b External \b Connections \n
//!  Connect the USB cable from Control card J1:A to PC
//!
//
//#############################################################################
// See LICENSE for license details.

#include "sci_echoback_board.h"

#define my_sci_base   SCIA_BASE

int main(void)
{
	unsigned char *msg;
	uint16_t receivedChar;
    uint16_t rxStatus = 0U;
    uint32_t config = 0;

    /* Initialize device clock and peripherals */
    Device_init();

    uart_pinmux_init(my_sci_base);

    uart_init(my_sci_base, 115200);

#ifdef AUTOBAUD
    //
    // Perform an autobaud lock.
    // SCI expects an 'a' or 'A' to lock the baud rate.
    //
    SCI_lockAutobaud(SCIB_BASE);
#endif

    /* Send starting message. */
    msg = "\r\n\n\nHello World!\0";
    UART_writeCharArray(my_sci_base, msg, 17);

    msg = "\r\nYou will enter a character, and the DSP will echo it back!\n\0";
    UART_writeCharArray(my_sci_base, msg, 62);

    /* Enables CPU interrupts */
    __enable_irq();

    /* IDLE loop. Just sit and loop forever (optional): */
    for(;;)
    {
           msg = "\r\nEnter a character: \0";
           UART_writeCharArray(my_sci_base, msg, 22);
           /* Read a character from the FIFO. */
           receivedChar = SCI_readCharBlockingNonFIFO(my_sci_base);

           /*Check the SCI reception status and
            * determine whether a reception error has occurred.*/
           rxStatus = SCI_getRxStatus(my_sci_base);
           if((rxStatus & SCI_RXSTATUS_ERROR) != 0)
           {
               /*If Execution stops here there is some error
               Analyze SCI_getRxStatus() API return value*/
               ESTOP0;
           }

           /* Echo back the character. */
           msg = "  You sent: \0";
           UART_writeCharArray(my_sci_base, msg, 13);
           UART_writeCharBlockingNonFIFO(my_sci_base, receivedChar);
       }
}
 /* End of file */
