//#############################################################################
//
// FILE:   sci_ex04_interrupts_echoback.c
//
// TITLE:  SCI interrupt echoback example.
//
//! \addtogroup driver_example_list
//! <h1>SCI Interrupt Echoback</h1>
//!
//!  This test receives and echo-backs data through the SCI-A port
//!  via interrupts.
//!
//!  A terminal such as 'putty' can be used to view the data from
//!  the SCI and to send information to the SCI. Characters received
//!  by the SCI port are sent back to the host.
//!
//!  \b Running \b the \b Application
//!  Open a COM port with the following settings using a terminal:
//!  -  Find correct COM port
//!  -  Bits per second = 115200
//!  -  Data Bits = 8
//!  -  Parity = None
//!  -  Stop Bits = 1
//!  -  Hardware Control = None
//!
//!  The program will print out a greeting and then ask you to
//!  enter a character which it will echo back to the terminal.
//!
//!  \b Watch \b Variables \n
//!  - counter - the number of characters sent
//!
//
//###########################################################################
// See LICENSE for license details.
#include "sci_echoback_interrupt_board.h"

/* Defines */
#define SCI_INT_RX    INT_SCIA_RX
#define SCI_INT_TX    INT_SCIA_TX

unsigned char *msg;
uint32_t my_sci_base = SCIA_BASE;

int main(void)
{

    /* Initialize device clock and peripherals*/
    Device_init();

    /*Disable global interrupts.*/
    DINT;

    /* Init the GPIO for SCI */
    uart_pinmux_init(my_sci_base);

    /*Map the ISR to the wake interrupt.*/
   Interrupt_register(SCI_INT_TX, sciaTxISR);
   Interrupt_register(SCI_INT_RX, sciaRxISR);

    uart_init(my_sci_base, 115200);

    /*Send starting message.*/
    msg = "\r\n\n\nHello World!\0";
    UART_writeCharArray(my_sci_base, msg, 17);
    msg = "\r\nYou will enter a character, and the DSP will echo it back!\n\0";
    UART_writeCharArray(my_sci_base, msg, 62);

    /* Enable the interrupts in the PIE: Group 9 interrupts 1 & 2. */
    Interrupt_enable(SCI_INT_RX);
    Interrupt_enable(SCI_INT_TX);

     /* Enables CPU interrupts */
    __enable_irq();

    for(;;)
    {
    }
}
