//#############################################################################
//
// FILE:   sci_ex3_echoback.c
//
// TITLE:  SCI echoback example.
//
//! \addtogroup driver_example_list
//! <h1>SCI Echoback</h1>
//!
//!  This test receives and echo-backs data through the SCI-A port.
//!
//!  A terminal such as 'putty' can be used to view the data from
//!  the SCI and to send information to the SCI. Characters received
//!  by the SCI port are sent back to the host.
//!
//!  \b Running \b the \b Application
//!  Open a COM port with the following settings using a terminal:
//!  -  Find correct COM port
//!  -  Bits per second = 115200
//!  -  Data Bits = 8
//!  -  Parity = None
//!  -  Stop Bits = 1
//!  -  Hardware Control = None
//!
//!  The program will print out a greeting and then ask you to
//!  enter a character which it will echo back to the terminal.
//!
//!  \b Watch \b Variables \n
//!  - loopCounter - the number of characters sent
//!
//! \b External \b Connections \n
//!  Connect the USB cable from Control card J1:A to PC
//!
//
//#############################################################################
// See LICENSE for license details.
#include "sci_nofifo_polling.h"

#define SEND_DATA_LEN   128

uint32_t my_sci_base = SCIA_BASE;

int main(void)
{
	uint8_t i = 0;
	uint8_t flag_end = 0;
	
	uint8_t send_data[SEND_DATA_LEN];
	uint8_t rcv_data[SEND_DATA_LEN] = {0};
	uint16_t rcv_data_count = 0;

    char *prompt_info = "please enter some chars and end with \\n: \r\n";

    /* Initialize device clock and peripherals */
    Device_init();

    uart_pinmux_init(my_sci_base);

	uart_init(my_sci_base, 115200);

    UART_writeCharArray(my_sci_base, prompt_info, strlen(prompt_info));

    /* IDLE loop. Just sit and loop forever (optional): */
    for(;;)
    {

        /*Read a character from the RXBUFF.
    	 Sent content needs to end with a carriage return or \r\n*/
    	if(SCI_isDataAvailableNonFIFO(my_sci_base))
    	{
    		rcv_data[rcv_data_count] = SCI_readCharBlockingNonFIFO(my_sci_base);

    		if(rcv_data[rcv_data_count]=='\n')
    	    {
    	    	flag_end = 1;
    	    }

    		rcv_data_count++;
    	}

        /* Echo back the character. */
    	while(flag_end)
    	{
    	    flag_end = 0;

    	    UART_writeCharArray(my_sci_base, rcv_data, rcv_data_count);

    		for (i = 0; i < rcv_data_count; i++)
    		{
    			rcv_data[i] = 0;
    		}

    	    rcv_data_count = 0;
        }
    }
}

