/*
 * sci_fifo_polling.c
 *
 *  Created on: 2025 May 12
 *      Author: hpec
 */
#include "sci_fifo_polling.h"

void uart_pinmux_init(uint32_t base)
{
	if (base == SCIA_BASE)
	{
		GPIO_setPinConfig(SCIA_TX_PIN);
		GPIO_setPinConfig(SCIA_RX_PIN);

		GPIO_setPadConfig(28, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPadConfig(29, GPIO_PIN_TYPE_PULLUP);
	}
	else if (base == SCIB_BASE)
	{
		GPIO_setPinConfig(SCIB_TX_PIN);
		GPIO_setPinConfig(SCIB_RX_PIN);

		GPIO_setPadConfig(14, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPadConfig(15, GPIO_PIN_TYPE_PULLUP);
	}
}

void uart_init(uint32_t SCI_Base, uint32_t Baud)
{

    /* Initialize SCIB and its FIFO. */
    SCI_performSoftwareReset(SCI_Base);

    /* Configure SCIA for echoback. */
    SCI_setConfig(SCI_Base, DEVICE_APBCLK_FREQ, Baud, (SCI_CONFIG_WLEN_8 |
                                                        SCI_CONFIG_STOP_ONE |
                                                        SCI_CONFIG_PAR_NONE));
    SCI_resetChannels(SCI_Base);
    SCI_resetRxFIFO(SCI_Base);
    SCI_resetTxFIFO(SCI_Base);
    SCI_clearInterruptStatus(SCI_Base, SCI_INT_TXFF | SCI_INT_RXFF);
    SCI_enableFIFO(SCI_Base);
    SCI_setFIFOInterruptLevel(SCI_Base, SCI_FIFO_TX0, SCI_FIFO_RX8);
    SCI_enableModule(SCI_Base);
    SCI_performSoftwareReset(SCI_Base);
}
