// See LICENSE for license details.
#include "sci_txdelay_polling.h"

static uint32_t g_SCI_base = SCIA_BASE;

int main(void)
{
	uint8_t sDatas[5] = {0};
	uint8_t txdly = 0;

    Device_init();

    uart_pinmux_init(g_SCI_base);

    uart_init(g_SCI_base, 115200);

    sDatas[0] = 0x31;
    sDatas[1] = 0x32;
    sDatas[2] = 0x33;
    sDatas[3] = 0x34;
    sDatas[4] = 0x35;

    for (txdly = 0; txdly < 255; txdly++)
    {
    	UART_writeCharArray(g_SCI_base, sDatas, 5);
    	while( (HWREGH(g_SCI_base+SCI_O_CTL2) & SCI_CTL2_TXEMPTY) != SCI_CTL2_TXEMPTY );

    	SCI_resetTxFIFO(g_SCI_base);
    	SCI_setTxFifoTransmitDelay(g_SCI_base, txdly);
    }
    while(1);
    return 0;
}

