/*
 * sci_dma_timeout.c
 *
 *  Created on: 2025 May 13
 *      Author: hpec
 */
#include "sci_dma_timeout.h"

#define DMA_UART_RD_SIZE  128
#define DMA_UART_BUF_SIZE 128

volatile uint32_t g_SCI_base = SCIA_BASE;

volatile uint32_t num2 = 0;
uint16_t Dma_UartTxBuf[DMA_UART_BUF_SIZE];
uint16_t tmpstr[DMA_UART_RD_SIZE] = {0};
uint64_t ctrl = 0,config = 0;


void uart_pinmux_init(uint32_t base)
{
	if (base == SCIA_BASE)
	{
		GPIO_setPinConfig(SCIA_TX_PIN);
		GPIO_setPinConfig(SCIA_RX_PIN);

		GPIO_setPadConfig(28, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPadConfig(29, GPIO_PIN_TYPE_PULLUP);
	}
	else if (base == SCIB_BASE)
	{
		GPIO_setPinConfig(SCIB_TX_PIN);
		GPIO_setPinConfig(SCIB_RX_PIN);

		GPIO_setPadConfig(14, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPadConfig(15, GPIO_PIN_TYPE_PULLUP);
	}
}

void uart_init(uint32_t SCI_Base, uint32_t Baud)
{
	SCI_performSoftwareReset(SCI_Base);
	SCI_setConfig(SCI_Base, DEVICE_APBCLK_FREQ, Baud,(SCI_CONFIG_WLEN_8|SCI_CONFIG_STOP_ONE|SCI_CONFIG_PAR_NONE));
	SCI_resetChannels(SCI_Base);
	SCI_clearInterruptStatus(SCI_Base, SCI_INT_TXFF | SCI_INT_RXFF);

	SCI_disableFIFO(SCI_Base);
	SCI_enableModule(SCI_Base);
	SCI_enableFIFO(g_SCI_base);
	SCI_setFIFOInterruptLevel(SCI_Base, SCI_FIFO_TX8, SCI_FIFO_RX16);
	SCI_enableInterrupt(SCI_Base, SCI_INT_RXTIMEOUT);
    SCI_setRxTimeout(SCI_Base, 50000);
	SCI_performSoftwareReset(SCI_Base);
}

void SCIx_RX_INTR_IRQHandler(void)
{
	uint16_t num = 0;
	uint16_t i;
	char* msg = "\0";
	num = SCI_getRxFIFOStatus(g_SCI_base);
	for(i = num; i > 0;i--)
	{
		tmpstr[128-num] = SCI_readCharBlockingFIFO(g_SCI_base);
		num--;
	}
	for (i = 0; i < 128; ++i) {
		UART_writeCharBlockingFIFO(g_SCI_base, tmpstr[i]);
	}

	num = 0;
	SCI_clearInterruptStatus(g_SCI_base, SCI_INT_RXTIMEOUT);
	SCI_clearInterruptStatus(g_SCI_base, SCI_INT_RXFF);
	SCI_clearOverflowStatus(g_SCI_base);
	SCI_disableInterrupt(g_SCI_base, SCI_INT_RXTIMEOUT);
	printf("\n\r=============================num2 = %d=============================\n\r",num2++);

    __DSB();
}

void uart_dma_tx(void)
{
    uint32_t i;
    DMA_ConfigParams dmaCfg = {0};

    /***********************************************************/
    /* The following test is for UART1 Tx with DMA control */
    /***********************************************************/
    /* Initialize the data to be sent to UART via DMA */
    for(i = 0; i < DMA_UART_BUF_SIZE; i++)
    {
        Dma_UartTxBuf[i] = (0x40+(i%26));
    }

    printf("DMA outputs 128 chars to UART.\r\n");

    /* DMA global enable */
#if ((GS32F00xx == 0x1100 || GS32F00xx == 0x0011) || (GS32F00xx == 0x2000 || GS32F00xx == 0x0020))
    DMA_initController(DMA_BASE);
#else
    DMA_initController(DMA_BASE);
#endif

    /* Stop DMA channel first - why the DMA channel is still pending after reset? */
    DMA_stopChannel(DMA_CH1_BASE);

    dmaCfg.enableInterrupt = 1;
    dmaCfg.srcAddr = (uint32_t)(&Dma_UartTxBuf[0]);
    dmaCfg.destAddr = (g_SCI_base + SCI_O_TXBUF);
    dmaCfg.blockTS = DMA_UART_BUF_SIZE - 1;
    dmaCfg.ttfc    = DMA_TT_FC_1_M2P_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_1;
    dmaCfg.destBtl = DMA_BTL_1;
    dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_2;
    dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_2;
    dmaCfg.srcHkSelect = DMA_HKS_HARDWARE;
    dmaCfg.destHkSelect = DMA_HKS_HARDWARE;
    dmaCfg.destHardInf = DMA_HKS_HARD_INF_0;
    dmaCfg.dmaDstReqId = DMAMUX_ReqId_scia_tx;
    /* Clear INT flag set in previous operation */
    /* Enable the IRQ so that we can poll the Status_Tfr flag */
    DMA_clearInterrupt(DMA_CH1_BASE, DMA_INT_TFR);
    DMA_unMaskInterrupt(DMA_CH1_BASE, DMA_INT_TFR);
    DMA_configChannel(DMA_CH1_BASE, &dmaCfg);

    /* DMA channel enable */
    DMA_startChannel(DMA_CH1_BASE);

    /* poll DMA Ch0 INT flag until Tx completed*/
    while((DMA_getInterruptStatus(DMA_CH1_BASE) & DMA_INT_TFR) == 0);
    printf("DMA controlled UART Tx test done.\r\n");
}

//global rx buff


void uart_dma_rx()
{
    uint32_t i;
    char* msg = "Please input 128 chars...\r\n";
    DMA_ConfigParams dmaCfg = {0};

    /* The following test is for UART1 Rx with DMA control */
    UART_writeCharArray(g_SCI_base, msg, strlen(msg));
    memset(tmpstr, 0, DMA_UART_RD_SIZE);
    /* DMA global enable */
#if ((GS32F00xx == 0x1100 || GS32F00xx == 0x0011) || (GS32F00xx == 0x2000 || GS32F00xx == 0x0020))
    DMA_initController(DMA_BASE);
#else
    DMA_initController(DMA_BASE);
#endif

    /* Stop DMA channel first - why the DMA channel is still pending after reset? */
    DMA_stopChannel(DMA_CH1_BASE);
    dmaCfg.enableInterrupt = 1;
    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_scia_rx;
    dmaCfg.srcAddr = (g_SCI_base + SCI_O_RXBUF);
    dmaCfg.destAddr = (uint32_t)(tmpstr);
    dmaCfg.blockTS = DMA_UART_RD_SIZE;
    dmaCfg.ttfc    = DMA_TT_FC_2_P2M_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_1;
    dmaCfg.destBtl = DMA_BTL_1;
    dmaCfg.srcAddrDirect = DMA_ADDR_NO_CHANGE;
    dmaCfg.destAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_2;
    dmaCfg.destTrWidthBytes=     DMA_TR_WIDTH_BYTE_2;
    dmaCfg.srcHkSelect = DMA_HKS_HARDWARE;
    dmaCfg.destHkSelect = DMA_HKS_HARDWARE;
    dmaCfg.srcHardInf = DMA_HKS_HARD_INF_0;

    DMA_configChannel(DMA_CH1_BASE, &dmaCfg);

    /* Clear INT flag set in previous operation */
    /* Enable the IRQ so that we can poll the Status_Tfr flag */
    DMA_clearInterrupt(DMA_CH1_BASE, DMA_INT_TFR);
    DMA_unMaskInterrupt(DMA_CH1_BASE, DMA_INT_TFR);

    /* DMA channel enable */
    DMA_startChannel(DMA_CH1_BASE);

    /* poll DMA Ch0 INT flag until Tx completed*/
    while((DMA_getRawInterruptStatus(DMA_CH1_BASE) & DMA_INT_TFR) == 0)
    {
        ctrl = DMA_getChannelCTL(DMA_CH1_BASE);
        config = DMA_getChannelCFG(DMA_CH1_BASE);
    }

}
