// See LICENSE for license details.
#include "sci_address_bit_master.h"

extern uint32_t g_SCI_base;
extern uint16_t cnt;
extern uint16_t buff[64];
extern volatile uint8_t flag_n;

int main(void)
{
    uint32_t oldTicks;
    uint32_t tickCnt;
    uint32_t i = 0;

    Device_init();

    uart_pinmux_init(g_SCI_base);

    uart_init(g_SCI_base, 115200);

    Interrupt_register(INT_SCIA_RX, SCIx_RX_INTR_IRQHandler);

	char *prompt_info = "You will enter a character: \r\n";

	UART_writeCharArray(g_SCI_base, prompt_info, strlen(prompt_info));

	DELAY_US(8000);

	SCI_setAddrMultiProcessorMode(g_SCI_base);

	SCI_setWakeFlag(g_SCI_base);

	UART_writeCharBlockingFIFO(g_SCI_base, 'Y');

    Interrupt_enable(INT_SCIA_RX);
    __enable_irq();

    for(;;)
    {
        while(flag_n)
        {
            flag_n=0;
            SCI_setIdleMultiProcessorMode(g_SCI_base);
            HWREGH(g_SCI_base + SCI_O_CTL1) &= ~SCI_CTL1_TXWAKE;
            SCI_writeCharArray(g_SCI_base, buff, cnt);
            for (i = 0; i < cnt; i++)
            {
            	buff[i] = 0;
            }

            SCI_enableSleepMode(g_SCI_base);

            cnt=0;
        }
    }

}

