/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    main.c
*   @brief
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "printf.h"
#include "device.h"
#include"cmpss_ex4_filter_latch_bit.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

//int32_t uart_init(uint32_t baudrate)
//{
//    SCIA->SCI_MCR = 0;
//    SCIA->SCI_LCR = 0x80;
//    SCIA->SCI_DLL_THR = 1 + 20000000 / (baudrate*16);
//    SCIA->SCI_LCR = 0;
//    SCIA->SCI_LCR = 0x3;
//    return 0;
//}
//
//#define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
//PUTCHAR_PROTOTYPE
//{
//	SCIA->SCI_DLL_THR = ch;
//	while (!(SCIA->SCI_LSR & BIT(5)));
//	return ch;
//}
//
//int __io_putchar(int ch){
//	SCIA->SCI_DLL_THR = ch;
//	while (!(SCIA->SCI_LSR & BIT(5)));
//	return ch;
//}


/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/**
  * \brief  Main program
  * \param  None
  * \retval None
  */
void initEPWM1(void);
int main(void)
{
 	   Device_init();


       HWREG(0x400D641C) = 0x01;//cmpss EN





	    Board_init();
	    initEPWM1();
	    EPWM_setHrpwmDllCfg0(myPREEPWM,HRPWM_0CFG_VALUE);

		GPIO_setPinConfig(GPIO_0_EPWM1_A);
		GPIO_setPinConfig(GPIO_1_EPWM1_B);
		DEVICE_DELAY_US(500);
	    // Loop indefinitely
	        while(1)
	    {
	        //
	        // Trip flag is set when CTRIP signal is asserted
	        //
	    	if((EPwm1Regs.TZFLG.bit.OST & EPWM_TZ_FLAG) != 0U)
	    	{
	            // Wait for comparator CTRIP to de-assert
	            while((Cmpss1Regs.COMPSTS.bit.COMPHSTS & CMPSS_STS_HI_FILTOUT) != 0U)
	            {
	            	;
	            }

	            // Clear trip flags
	            EPwm1Regs.TZCLR.bit.INT =  TZCLR_FLAG;
	            EPwm1Regs.TZCLR.bit.OST =  TZCLR_FLAG;
	        }
	    }
  /* We should never get here as control is now taken by the scheduler */
 // for(;;);
}

// initEPWM - Function to configure ePWM7 and the ePWM X-BAR to take CTRIPH as
//            the DC trip input
void initEPWM1(void)
{
    // Sync the ePWM time base clock
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    // Configure TRIP4 to be CTRIP1H using the ePWM X-BAR
    XBAR_setEPWMMuxConfig(XBAR_TRIP4, XBAR_EPWM_MUX00_CMPSS1_CTRIPH);
    XBAR_enableEPWMMux(XBAR_TRIP4, XBAR_MUX00);

	// Set the time base clock prescalers to /1
    EPwm1Regs.TBCTL.bit.CLKDIV = EPWM_CLOCK_DIVIDER_1;
    EPwm1Regs.TBCTL.bit.HSPCLKDIV = EPWM_HSCLOCK_DIVIDER_1;

	// Initializing dummy values for ePWM counter and period
    EPwm1Regs.TBCTR = 0;
    EPwm1Regs.TBPRD = PWM1_TIMER_PERIOD;

	// Set-up compare count A
    EPwm1Regs.CMPA.bit.CMPA = PWM_CMP_VAL;
    EPwm1Regs.CMPCTL.bit.LOADASYNC = 0;
    EPwm1Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
    EPwm1Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;

	// Set-up compare count A
	EPwm1Regs.CMPB.bit.CMPB = PWM_CMP_VBL;
    EPwm1Regs.CMPCTL.bit.LOADBSYNC = 0;
    EPwm1Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;
    EPwm1Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;

	// Set actions
    EPwm1Regs.AQCTLA.bit.ZRO = AQ_CLEAR;
    EPwm1Regs.AQCTLA.bit.PRD = AQ_NO_ACTION;
    EPwm1Regs.AQCTLA.bit.CAU = AQ_SET;
    EPwm1Regs.AQCTLA.bit.CAD = AQ_NO_ACTION;
    EPwm1Regs.AQCTLA.bit.CBU = AQ_NO_ACTION;
    EPwm1Regs.AQCTLA.bit.CBD = AQ_NO_ACTION;

    EPwm1Regs.AQCTLB.bit.ZRO = AQ_CLEAR;
    EPwm1Regs.AQCTLB.bit.PRD = AQ_NO_ACTION;
    EPwm1Regs.AQCTLB.bit.CAU = AQ_NO_ACTION;
    EPwm1Regs.AQCTLB.bit.CAD = AQ_NO_ACTION;
    EPwm1Regs.AQCTLB.bit.CBU = AQ_SET;
    EPwm1Regs.AQCTLB.bit.CBD = AQ_NO_ACTION;

	// Put the time base counter into up-count mode
    EPwm1Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP;

    // Configure ePWM7B to output high on TZB TRIP
    EPwm1Regs.TZCTL.bit.TZB = TZ_FORCE_HI;

    // Trigger event when DCBH is high
    EPwm1Regs.TZDCSEL.bit.DCBEVT1 = TZ_DCBH_HI;

    // Configure DCBH to use TRIP4 as an input
    EPwm1Regs.DCBHTRIPSEL.bit.TRIPINPUT4 = 1U;
    EPwm1Regs.DCTRIPSEL.bit.DCBHCOMPSEL = 0xF;

    // Enable DCB as OST
    EPwm1Regs.TZSEL.bit.DCBEVT1 = TZ_ENABLE;

    // Configure the DCB path to be unfiltered and asynchronous
    EPwm1Regs.DCBCTL.bit.EVT1SRCSEL = 0U;
    EPwm1Regs.DCBCTL.bit.EVT1FRCSYNCSEL = 1U;

    // Clear trip flags
    EPwm1Regs.TZCLR.bit.INT =  TZCLR_FLAG;
    EPwm1Regs.TZCLR.bit.OST =  TZCLR_FLAG;
}
#ifdef __cplusplus
}
#endif

/*****END OF FILE****/
