/*
 * veriable.c
 *
 *  Created on: 2024 Nov 21
 *      Author: hpec8
 */

#include "device.h"
#include "IQMathLib.h"
#include "log.h"


int32_t array_256[256];
int32_t array_512[512];
int32_t array_1024[1024];
int32_t array_2D[4][512];

__attribute__ ((section (".RamFunc")))
void IQmath_test(void)
{
	int32_t input;
	for(uint32_t i = 0 ; i < 256 ; i++ ){
		input = i;
		array_256[i] = _IQ8sinPU ( input );

		array_512[i*2	 ] = _IQ8cosPU ( input * 2 );
		array_512[i *2 +1] = _IQ8cosPU ( input * 2 +1 );

		array_1024[i *4    ] = _IQ16sqrt ( input *4 );
		array_1024[i *4 +1 ] = _IQ16sqrt ( input *4 +1 );
		array_1024[i *4 +2 ] = _IQ16sqrt ( input *4 +2 );
		array_1024[i *4 +3 ] = _IQ16sqrt ( input *4 +3 );

		array_2D[0][i*2		] = _IQ8sinPU ( input * 2 );
		array_2D[0][i *2 +1	] = _IQ8sinPU ( input * 2 +1 );
		array_2D[1][i*2		] = _IQ8cosPU ( input * 2 );
		array_2D[1][i *2 +1	] = _IQ8cosPU ( input * 2 +1 );
		array_2D[2][i*2		] = _IQ6sinPU ( input * 2 );
		array_2D[2][i *2 +1	] = _IQ6sinPU ( input * 2 +1 );
		array_2D[3][i*2		] = _IQ8sqrt ( input * 2 );
		array_2D[3][i *2 +1	] = _IQ8sqrt ( input * 2 +1 );

//		printf("input	: %d	", input);
//		printf("output	: %d\n", IQ_output[i]);
	}
}

