/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "device.h"
#include "can_bus_off.h"
#include "log.h"

CAN_TxMessage_t TxMsgBuf = {0};
extern bool can_disable_flag;

int main(void)
{
	Device_init();

	__disable_irq();

	UartPrint_init(LOG_SCI_BASE, 115200);

	GPIO_setPinConfig(CAN_RX_PIN);
	GPIO_setPinConfig(CAN_TX_PIN);

	can_ctrl_init();

	__enable_irq();

	TxMsgBuf.brs = 1;
	TxMsgBuf.dlc = 8;
	TxMsgBuf.fdf = 1;
	TxMsgBuf.id = 0x8;
	TxMsgBuf.ide = 0;
	TxMsgBuf.rtr = 0;
	for (uint32_t i = 0; i < CAN_getMessageLength(TxMsgBuf.dlc); i++)
		TxMsgBuf.data[i] = i;

	while (1) {
		if (can_disable_flag == false)
			/* Use secondary priority message buffer. */
			while (!CAN_transmitMsg(CAN_BASE, &TxMsgBuf));
		else {
			CAN_setOpMode(CAN_BASE, CAN_OPERATION_MODE_NORMAL);
			can_disable_flag = false;
		}
	}
}
