/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "log.h"
#include "mapping_section.h"
#include "functions.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define LED_GPIO_PIN    GPIO_PIN_LED1
#define LED_GPIO_CFG    GPIO_CFG_LED1

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */


/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */



/*
 * #pragma CODE_SECTION ڽõض
 * #pragma DATA_SECTION ڽõض
 * κεطʹ #pragma CODE_SECTION ָڶ
 * ע⣺ʹ#pragma DATA_SECTION  #pragma CODE_SECTION Ҫڹмϱѡ--gs-pragma-alias
 */

// һȫֱ global_data .IlmData ݶ
#pragma DATA_SECTION(global_data, ".IlmData");
int global_data = 10;

int main(void)
{
    Device_init();

    GPIO_setAnalogMode(20, GPIO_ANALOG_DISABLED);
    GPIO_setPinConfig(LED_GPIO_CFG);     //gpio
    GPIO_enableWritePin(LED_GPIO_PIN);

    UartPrint_init(LOG_SCI_BASE, 115200);

    log_set_level(LOG_DEBUG);

    log_info("Hello #pragma CODE_SECTION & #pragma DATA_SECTION test\r\n");

    core_function();	//ںλʹ #pragma CODE_SECTION
    function1();		//ͷļʹ
    function2();
    function3();

    return 0;
}

