/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    Test_CpuCRC.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "GS32F00xx.h"
#include "CRC_ex01_cpuCRC_board.h"
#include "stdio.h"
#include "crc.h"
#include "interrupt.h"
#include "printf.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

uint32_t CRC_data_in_32bit[CPUDATA_SIZE] = {0x00001111,0x11110000,0x00000000,0x11111111};
uint32_t CRC_data_in_24bit[CPUDATA_SIZE] = {0x00000011,0x00000022,0x00000033,0x00000044};
uint32_t CRC_data_in_16bit[CPUDATA_SIZE] = {0x00001111,0x00002222,0x00003333,0x00004444};
uint32_t CRC_data_in_8bit[CPUDATA_SIZE] = {0x00000011,0x00000022,0x00000033,0x00000044};
uint32_t CRC_data_in_7bit[CPUDATA_SIZE] = {0x11, 0x22, 0x33, 0x44};

uint32_t CRC_result[5] = {0,0,0,0,0};
volatile uint32_t watchResult = 0;
uint16_t crcErr = 0;
uint16_t crcRight = 0;
uint16_t intDoneCnt = 0;
uint16_t intFailCnt = 0;

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


 /**
 * \brief   Test CPUCRC
 * \param   none
 * \retval  None
 */
 void Test_CpuCRC(void)
{
/**********************************************************/
	/* Configuration */
	CRC_ConfigParams crcConfigParams;
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_32BIT;
	crcConfigParams.polyValue = 0x04C11DB8;
	crcConfigParams.dataSize = CPUDATA_SIZE;
	crcConfigParams.goldenValue = 0x6AD86B60;
	CRC_initConfig(CRC_BASE, crcConfigParams);
	/* ENABLE  */
	CRC_startCalculation(CRC_BASE);
	for(int i=0;i<CPUDATA_SIZE;i++)
	{
		/*DR INPUT*/
		CRC_writeData(CRC_BASE,CRC_data_in_32bit[i]);
	}
	CRC_result[0] = CRC_getResult(CRC_BASE);

	/* Check if the result is right */
	if(CRC_result[0] == 0x6AD86B60){/*32poly 04C11DB7*/
		crcRight |= 0x01;
	}
	else{
		crcErr |= 0x01;
	}
/**********************************************************/
	/* CONFIGURATION  */
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_24BIT;
	crcConfigParams.polyValue = 0x864CFB;
	crcConfigParams.dataSize = CPUDATA_SIZE;
	crcConfigParams.goldenValue = 0xC86C58;
	CRC_initConfig(CRC_BASE, crcConfigParams);
	/* ENABLE  */
	CRC_startCalculation(CRC_BASE);
	for(int i=0;i<CPUDATA_SIZE;i++)
	{
		/*DR INPUT*/
		CRC_writeData(CRC_BASE,CRC_data_in_24bit[i]);
	}
	CRC_result[1] = CRC_getResult(CRC_BASE);
	/* Check if the result is right */
	if(CRC_result[1] == 0xC86C58){ /*24poly 864CFB*/
		crcRight |= 0x02;
	}
	else{
		crcErr |= 0x02;
	}
/**********************************************************/
	/* CONFIGURATION  */
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_16BIT;
	crcConfigParams.polyValue = 0x99CA;
	crcConfigParams.dataSize = CPUDATA_SIZE;
	crcConfigParams.goldenValue = 0x9362;
	CRC_initConfig(CRC_BASE, crcConfigParams);
	/* ENABLE  */
	CRC_startCalculation(CRC_BASE);
	for(int i=0;i<CPUDATA_SIZE;i++)
	{
		/*DR INPUT*/
		CRC_writeData(CRC_BASE,CRC_data_in_16bit[i]);
	}
	CRC_result[2] = CRC_getResult(CRC_BASE);
	/* Check if the result is right */
	if(CRC_result[2] == 0x9362){ /*16poly 8005*/
		crcRight |= 0x04;
	}
	else{
		crcErr |= 0x04;
	}
/**********************************************************/
	/* CONFIGURATION  */
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_8BIT;
	crcConfigParams.polyValue = 0x07;
	crcConfigParams.dataSize = CPUDATA_SIZE;
	crcConfigParams.goldenValue = 0xF9;
	CRC_initConfig(CRC_BASE, crcConfigParams);
	/* ENABLE  */
	CRC_startCalculation(CRC_BASE);
	for(int i=0;i<CPUDATA_SIZE;i++)
	{
		/*DR INPUT*/
		CRC_writeData(CRC_BASE,CRC_data_in_8bit[i]);
	}
	CRC_result[3] = CRC_getResult(CRC_BASE);
	
	/* Check if the result is right */
	if(CRC_result[3] == 0xF9){ /*8poly 07*/
		crcRight |= 0x08;
	}
	else{
		crcErr |= 0x08;
	}

/**********************************************************/
	/* CONFIGURATION  */
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_7BIT;
	crcConfigParams.polyValue = 0x09;
	crcConfigParams.dataSize = CPUDATA_SIZE;
	crcConfigParams.goldenValue = 0x48;
	CRC_initConfig(CRC_BASE, crcConfigParams);
	/* ENABLE  */
	CRC_startCalculation(CRC_BASE);

	for(int i = 0; i < CPUDATA_SIZE; i++) {
		/*DR INPUT*/
		CRC_writeData(CRC_BASE,CRC_data_in_7bit[i]);
	}

	CRC_result[4] = CRC_getResult(CRC_BASE);

	/* Check if the result is right */
	if(CRC_result[4] == 0x48){ /*7poly 09*/
		crcRight |= 0x10;
	}
	else{
		crcErr |= 0x10;
	}
}


void delay_us(uint32_t delay_us)
{    
  volatile unsigned int num;
  volatile unsigned int t;
 
  
  for (num = 0; num < delay_us; num++)
  {
    t = 11;
    while (t != 0)
    {
      t--;
    }
  }
}



#ifdef __cplusplus
}
#endif

