/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    dma_ex02_adc_meas_1chn_cvert2tfr_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "dma_ex02_adc_meas_1chn_cvert2tfr_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

__IO Uint16 testADC0DataBuffer[4];

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules. 
// Call this function in your application if you wish to do all module 
// initialization.
// If you wish to not use some of the initializations, instead of the 
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
    EALLOW;    
    PinMux_init();
 
    sAdc_config(testADC_BASE, 
                testADC_CHN1, 
                testADC_SOC_NUMBER1, 
                testADC_TRIGGER, 
                testADC_INT_NUMBER1, 
                testADC_SAMPLEWINDOW);  
    EDIS;
}

// PINMUX Configurations
void PinMux_init()
{
    //
    // EPWM1 -> myEPWM1 Pinmux
    //
    GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);
}

void sAdc_config(uint32_t base, ADC_Channel channel, ADC_SOCNumber socNumber, ADC_Trigger trigger, 
        ADC_IntNumber adcIntNum, uint32_t sampleWindow)
{
    ASysCtl_initConfig();
#if ((GS32F00xx & 0xFF) == 0x0)
    ADC_setVREF(base, ADC_REFERENCE_INTERNAL, ADC_REFERENCE_3_3V);
#endif
    ADC_setINLTrim(base);

    ADC_setPrescaler(base, ADC_CLK_DIV_4_0);
    ADC_setInterruptPulseMode(base, ADC_PULSE_END_OF_CONV);
    ADC_enableConverter(base);    


    //
    // SOC Configuration: Setup ADC EPWM channel and trigger settings
    //
    // Disables SOC burst mode.
    //
    ADC_disableBurstMode(base);
    //
    // Sets the priority mode of the SOCs.
    //
    //ADC_setSOCPriority(base, ADC_PRI_ALL_ROUND_ROBIN);

    ADC_setupSOC(base, socNumber, trigger, channel, 60U);
    ADC_setInterruptSOCTrigger(base, socNumber, ADC_INT_SOC_TRIGGER_NONE);

    //
    // Set SOC0 to set the interrupt 1 flag. Enable the interrupt and make
    // sure its flag is cleared.
    //
    ADC_setInterruptSource(base, adcIntNum, socNumber);
    ADC_enableInterrupt(base, adcIntNum);
    ADC_clearInterruptStatus(base, adcIntNum);
    ADC_enableContinuousMode(base, adcIntNum);    

}

void setupUpCountPWM(Uint32 base, Uint16 pwm_period_ticks,Uint16 Deadtime_RED,Uint16 Deadtime_FED,Uint16 phaseCount)
{
    //
    // Time Base SubModule Registers
    //
    EPWM_setPeriodLoadMode(base, EPWM_PERIOD_SHADOW_LOAD);
    EPWM_setTimeBasePeriod(base, pwm_period_ticks - 1);    
    HRPWM_setTimeBaseCounter(base, 0);
    //if(base == EPWM7_BASE)
    //{
        EPWM_enableSyncOutPulseSource(base, EPWM_SYNC_OUT_PULSE_ON_CNTR_ZERO);
    //}
    //else
    //{
    //    EPWM_enableSyncOutPulseSource(base, EPWM_SYNC_OUT_PULSE_ON_SOFTWARE);
    //}
    HRPWM_setPhaseShift(base, phaseCount);
    HRPWM_enablePhaseShiftLoad(base);


    EPWM_setTimeBaseCounterMode(base, EPWM_COUNTER_MODE_UP);
    //EPWM_setTimeBaseCounterMode(base1, EPWM_COUNTER_MODE_UP_DOWN);

    HRPWM_setClockPrescaler(base, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);

    //EPWM_setSyncInPulseSource(base1,source);

    //
    // Counter Compare Submodule Registers
    // set duty 0% initially
    //
    EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, 0);  
    HRPWM_setCounterCompareShadowLoadMode(base, EPWM_COUNTER_COMPARE_A,
                                         EPWM_COMP_LOAD_ON_CNTR_ZERO);
  

    HWREGH(base + HRPWM_O_AQCTLA) = 0 ;
    HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A ,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
    HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A ,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);

    //
    // DeadTimer
    //
    EPWM_setDeadBandCounterClock(base,EPWM_DB_COUNTER_CLOCK_HALF_CYCLE);
    EPWM_setRisingEdgeDeadBandDelayInput(base,EPWM_DB_INPUT_EPWMA);
    EPWM_setFallingEdgeDeadBandDelayInput(base,EPWM_DB_INPUT_EPWMA);
    EPWM_setDeadBandDelayPolarity(base,EPWM_DB_RED,EPWM_DB_POLARITY_ACTIVE_HIGH);
    EPWM_setDeadBandDelayPolarity(base,EPWM_DB_FED,EPWM_DB_POLARITY_ACTIVE_LOW);
    EPWM_setDeadBandDelayMode(base,EPWM_DB_RED,true);
    EPWM_setDeadBandDelayMode(base,EPWM_DB_FED,true);
    EPWM_setDeadBandOutputSwapMode(base,EPWM_DB_OUTPUT_A,FALSE);
    EPWM_setDeadBandOutputSwapMode(base,EPWM_DB_OUTPUT_B,FALSE);
    EPWM_setRisingEdgeDelayCount(base,Deadtime_RED);
    EPWM_setFallingEdgeDelayCount(base,Deadtime_FED);

#if (defined (ENABLE_TZ) && ENABLE_TZ)
    //TZ
    EPWM_enableTripZoneSignals(base,EPWM_TZ_SIGNAL_OSHT1);
    EPWM_setTripZoneAction(base, EPWM_TZ_ACTION_EVENT_TZA,
                   EPWM_TZ_ACTION_LOW);
    EPWM_setTripZoneAction(base, EPWM_TZ_ACTION_EVENT_TZB,
                   EPWM_TZ_ACTION_LOW);

    EPWM_forceTripZoneEvent(base,EPWM_TZ_FORCE_EVENT_OST);
#endif

    //HR

    HRPWM_setCounterCompareShadowLoadEvent(base, HRPWM_CHANNEL_A, HRPWM_LOAD_ON_CNTR_ZERO);
    HRPWM_setMEPControlMode(base,HRPWM_CHANNEL_A,HRPWM_MEP_DUTY_PERIOD_CTRL);
    HRPWM_setMEPEdgeSelect(base,HRPWM_CHANNEL_A,HRPWM_MEP_CTRL_FALLING_EDGE);

    //    HRPWM_setDeadbandMEPEdgeSelect(base, HRPWM_DB_MEP_CTRL_FED);
    //    HRPWM_setFallingEdgeDelayLoadMode(base, HRPWM_LOAD_ON_CNTR_ZERO);

    HRPWM_setMEPEdgeSelect(base,HRPWM_CHANNEL_B,HRPWM_MEP_CTRL_RISING_EDGE);
    HRPWM_setMEPControlMode(base,HRPWM_CHANNEL_B,HRPWM_MEP_DUTY_PERIOD_CTRL);
    HRPWM_setCounterCompareShadowLoadEvent(base, HRPWM_CHANNEL_B, HRPWM_LOAD_ON_CNTR_ZERO);
}


void configureEPWM(uint32_t epwmBase)
{
#if ENABLE_HRPWM
    EPWM_setHrpwmDllCfg0(PREEPWM_BASE,0x81F1CB83);
    EPWM_setHrpwmDllCfg1(PREEPWM_BASE,0x703);
    EPWM_setEpwmtopHrpwmBypass(PREEPWM_BASE,0);
#endif 

    setupUpCountPWM(epwmBase, cPwmPeriod, cDB_RED_SET,cDB_FED_SET,0);


    EPWM_clearEventTriggerInterruptFlag(epwmBase);

    EPWM_setInterruptSource(epwmBase, EPWM_INT_TBCTR_PERIOD);// phase 0
    EPWM_enableInterrupt(epwmBase);
    EPWM_enableADCTrigger(epwmBase, EPWM_SOC_A);
    EPWM_setADCTriggerSource(epwmBase, EPWM_SOC_A, EPWM_SOC_TBCTR_ZERO);
    EPWM_setADCTriggerEventPrescale(epwmBase, EPWM_SOC_A, 1U);
    EPWM_setInterruptEventCount(epwmBase, cPwmIntEvtCnt);

    //
    // Enable initialization of the SOCA event counter. Since we are
    // disabling the ETSEL.SOCAEN bit, we need a way to reset the SOCACNT.
    // Hence, enable the counter initialize control.
    //
    EPWM_enableADCTriggerEventCountInit(epwmBase, EPWM_SOC_A);
}

volatile uint32_t dlog_addr;
//
// configureDMAChannels - Initialize DMA ch 0 to transfer ADC results
//                        
//
void DMA_CHN_Modeconfig(void)
{
    DMA_ConfigParams dma1Cfg = {0};

    dma1Cfg.enableInterrupt = 1;
    //enable DMA Trigger by DMA MUX
    dma1Cfg.dmaSrcReqId = DMA_CH_TRIGGER;
    dma1Cfg.srcAddr = (Uint32)(&AdccResultRegs.ADCRESULT0);//(Uint32)(ADCCRESULT_BASE);
    dma1Cfg.destAddr = (Uint32)(&testADC0DataBuffer[0]);
    dma1Cfg.blockTS = DMA_TFR_SIZE;
    dma1Cfg.reloadSrc = true;
    dma1Cfg.reloadDst = true; 
    dma1Cfg.ttfc    = DMA_TT_FC_2_P2M_DMAC;
    dma1Cfg.srcBtl  = DMA_BTL_1;   
    dma1Cfg.destBtl = DMA_BTL_1;
    dma1Cfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_2;
    dma1Cfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_2;
    dma1Cfg.srcAddrDirect = DMA_ADDR_NO_CHANGE;
    dma1Cfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
    dma1Cfg.chPriority = DMA_CH_PRIORITY_0;
    
    //dlog_addr = (uint32_t)&AdcaResultRegs.ADCRESULT0;

    DMA_configChannel(DMA_CH1_BASE, &dma1Cfg);
    DMA_clearInterrupt(DMA_CH1_BASE, DMA_INT_BLOCK);
    DMA_unMaskInterrupt(DMA_CH1_BASE, DMA_INT_BLOCK);
}


#ifdef __cplusplus
}
#endif

