/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    ecap_ex03_board.h
*   @brief   
*
*/

#ifndef ECAP_EX03_BOARD_H_
#define ECAP_EX03_BOARD_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "driverlib.h"
#include "device.h"
#include "regs\regs_ecap.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define myECAP1_BASE    ECAP1_BASE
#define myECAP2_BASE    ECAP2_BASE

#define myECAP1_SYNC_IN_OFFSET     SYSCTL_SYNCSEL_ECAP1_SYNCIN

#define myINPUTXBARINPUT0_SOURCE 0
#define myINPUTXBARINPUT0_INPUT XBAR_INPUT7

#define INT_myECAP0 INT_ECAP1

#define ECap1Regs (*(volatile struct ECAP_REGS *) myECAP1_BASE)
#define ECap2Regs (*(volatile struct ECAP_REGS *) myECAP2_BASE)


//
// EPWM1 -> myEPWM1 Pinmux
//
//
// EPWM1_A - GPIO Settings
//
#define GPIO_PIN_EPWM1_A 0
#define myEPWM1_EPWMA_GPIO 0
#define myEPWM1_EPWMA_PIN_CONFIG  GPIO_0_EPWM1_A
//
// EPWM1_B - GPIO Settings
//
#define GPIO_PIN_EPWM1_B 1
#define myEPWM1_EPWMB_GPIO 1
#define myEPWM1_EPWMB_PIN_CONFIG  GPIO_1_EPWM1_B


#define mYGPIO_8_GPIO8  GPIO_8_GPIO8
#define mYGPIO_2_GPIO2  GPIO_2_GPIO2
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/**
 * \brief   "Board Configurations
 *          Initializes the rest of the modules. 
 *          Call this function in your application if you wish to do all module initialization. 
 *          If you wish to not use some of the initializations, instead of the
 *          Board_init use the individual Module_inits" 
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void Board_init(void);

/**
 * \brief   "ECAP Configurations for ECAP1"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void myECAP0_init(void);

/**
 * \brief   "ECAP Configurations"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void ECAP_init(void);

/**
 * \brief   "GPIO Configurations for ECAP1"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void myGPIO0_init(void);

/**
 * \brief   "GPIO Configurations"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void GPIO_init(void);

/**
 * \brief   "INPUTXBAR Configurations for ECAP1"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void myINPUTXBARINPUT0_init(void);

/**
 * \brief   "INPUTXBAR Configurations"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void INPUTXBAR_init(void);

/**
 * \brief   "INTERRUPT Configurations"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void INTERRUPT_init(void);

/**
 * \brief   "PinMux Configurations" 
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void PinMux_init(void);

/**
 * \brief   "Interrupt handling function for ecap" 
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
extern void Ecap_ex03_IrqHandler(void);

/**
 * \brief   "Interrupt unregistering function after Interrupt is handled" 
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
extern void Unregister_ecap_ex03(void);

/**
 * \brief   "add brief description of this function" 
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */


#ifdef __cplusplus
}
#endif


#endif /* ECAP_EX03_BOARD_H_ */
