/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    ecap_ex07_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "ecap_ex07_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

// Board Configurations
void Board_init()
{
	PinMux_init();
	INPUTXBAR_init();
    ECAP_init();
	GPIO_init();
}

// PINMUX Configurations
void PinMux_init()
{
	GPIO_setPinConfig(mYGPIO_2_GPIO2);
	GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(2, GPIO_QUAL_SYNC);
    //
	// PinMux for modules assigned to CPU1
	//

	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);

	GPIO_setLoopBack(myEPWM1_EPWMA_GPIO, 1);
	//GPIO 8
	GPIO_setPinConfig(GPIO_24_OUTPUTXBAR1);
	GPIO_setPinConfig(GPIO_25_OUTPUTXBAR2);

}

// ECAP Configurations
void ECAP_init()
{
    myECAP0_init();
}

// ECAP Configurations for ECAP1
void myECAP0_init()
{
	// Disable ,clear all capture flags and interrupts
	
	ECAP_disableInterrupt(myECAP1_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));
	ECAP_clearInterrupt(myECAP1_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));
    
	// Disables time stamp capture.
	
	ECAP_disableTimeStampCapture(myECAP1_BASE);
	
	// Stops Time stamp counter.
	
	ECAP_stopCounter(myECAP1_BASE);
	
	// Sets eCAP in Capture mode.
	
	ECAP_enableCaptureMode(myECAP1_BASE);
	
	// Sets the capture mode.
	
	ECAP_setCaptureMode(myECAP1_BASE,ECAP_CONTINUOUS_CAPTURE_MODE,ECAP_EVENT_4);
	
	// Sets the Capture event prescaler.
	
	ECAP_setEventPrescaler(myECAP1_BASE, 0U);
	
	// Sets the Capture event polarity.
	
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_1,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_2,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_3,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_4,ECAP_EVENT_RISING_EDGE);
	
	// Configure counter reset on events
	
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_1);
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_2);
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_3);
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_4);
	
	// Select eCAP input.
	
	ECAP_selectECAPInput(myECAP1_BASE, ECAP_INPUT_INPUTXBAR7);
	
	// Sets a phase shift value count.
	
	ECAP_setPhaseShiftCount(myECAP1_BASE,0U);
	
	// Disable counter loading with phase shift value.
	
	ECAP_disableLoadCounter(myECAP1_BASE);
	
	// Configures Sync out signal mode.
	
	ECAP_setSyncOutMode(myECAP1_BASE,ECAP_SYNC_OUT_DISABLED);
	
	// Configures emulation mode.
	
	ECAP_setEmulationMode(myECAP1_BASE,ECAP_EMULATION_STOP);
	
	// Set up the source for sync-in pulse..
	
	// SysCtl_setECAPSyncInPulseSource(myECAP1_SYNC_IN_OFFSET,ECAP_SYNC_IN_PULSE_SRC_SYNCIN_EXT1);
	
	// Starts Time stamp counter for myECAP0.
	
	ECAP_startCounter(myECAP1_BASE);

	// Enables time stamp capture for myECAP0.

	ECAP_enableTimeStampCapture(myECAP1_BASE);

	// DMAжԴ

	ECAP_setDMASource(myECAP1_BASE,ECAP_EVENT_4);

	// Re-arms the eCAP module for myECAP0.

	ECAP_reArm(myECAP1_BASE);
}

// GPIO Configurations
void GPIO_init()
{
	myGPIO0_init();
}

// GPIO Configurations for ECAP1
void myGPIO0_init()
{
    // EPWM1 -> myEPWM1 Pinmux
    GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);
}

// INPUTXBAR Configurations
void INPUTXBAR_init()
{
	myINPUTXBARINPUT0_init();
}

// OUTPUTXBAR Configurations for ECAP1 output
void myINPUTXBARINPUT0_init()
{
	XBAR_setInputPin(INPUTXBAR_BASE,myINPUTXBARINPUT0_INPUT,myINPUTXBARINPUT0_SOURCE);
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/* None */

/**
 * \brief   add brief description of this function
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

#ifdef __cplusplus
}
#endif

