/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
 
 /**
*   @file    eqep_ex2_calculation.c
*   @brief   Position and Speed Measurement Using eQEP (Calculations)
*   @details
*
*/

#ifndef DEVICE_EQEP_EX2_CALCULATION_H_
#define DEVICE_EQEP_EX2_CALCULATION_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

//#include "IQmathLib.h"
#include "driverlib.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

//******** Temporary *****//
typedef   long    _iq;
//******** Temporary *****//

typedef struct {
    int16_t thetaElec;      // Output: Motor electrical angle (Q15)
    int16_t thetaMech;      // Output: Motor mechanical angle (Q15)
    int16_t directionQEP;   // Output: Motor rotation direction (Q0)
    int16_t thetaRaw;       // Variable: Raw angle from timer 2 (Q0)
    int16_t mechScaler;     // Parameter: 0.9999 / total count,
                            //            total count = 4000 (Q26)
    int16_t polePairs;      // Parameter: Number of pole pairs (Q0)
    int16_t calAngle;       // Parameter: Raw angular offset between encoder
                            //            and Phase A (Q0)

    uint32_t speedScaler;   // Parameter: Scaler converting 1/N cycles to a
                            //            GLOBAL_Q speed (Q0) - independently
                            //            with global Q
    _iq speedPR;            // Output: Speed in per-unit
    uint32_t baseRPM;       // Parameter: Scaler converting GLOBAL_Q speed to
                            //            rpm (Q0) speed - independently with
                            //            global Q
    int16_t speedRPMPR;     // Output: Speed in rpm (Q0) - independently with
                            //         global Q

    _iq oldPos;
    _iq speedFR;            // Output: Speed in per-unit
    int16_t speedRPMFR;     // Output: Speed in rpm (Q0) - independently with
                            //         global Q
		_iq newPos;
} PosSpeed_Object;

typedef PosSpeed_Object *PosSpeed_Handle;



/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

void eqep_ex2_PosSpeed_calculate(PosSpeed_Handle, uint32_t*,uint32_t myEQEP0_BASE);



#ifdef __cplusplus
}
#endif


#endif /* DEVICE_EQEP_EX2_CALCULATION_H_ */

