/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*
*  This program is used for the GS32 to act as a master device to conduct I2C
*  communication with the master device.
*  The master and the slave send 0-15 to each other through I2C
*  communication. Users can compare rx_Buffer[] to check the running results.
*
*          Master(gs32)                  Slave
*      (IO0)I2CA_SDA --------------- I2CA_SDA(IO0)
*      (IO1)I2CA_SCL --------------- I2CA_SCL(IO1)
*              GND   ---------------   GND
*
*/

#include "device.h"
#include "master.h"



int main(void)
{
	uint16_t i;
	uint32_t  EEPROM_ADDR = 0x00;

    Device_init();

    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_I2C);

    SysCtl_resetI2c();

    initI2C();

    for (i = 0; i < NUM_BYTES; i++)
    {
        tx_Buffer[i] = i;
        rx_Buffer[i] = 0;
    }

    EEPROM_ADDR = 0x50;


    __enable_irq();

    while (1)
    {
    	I2C_disableModule(I2CB_BASE);
    	I2C_setTargetAddress(I2CB_BASE, I2C_SLAVE_ADDRESS);
    	I2C_enableModule(I2CB_BASE);

        writeData(EEPROM_ADDR, tx_Buffer, NUM_BYTES);
        DEVICE_DELAY_US(7000);
        readData(EEPROM_ADDR, rx_Buffer, NUM_BYTES);
        DEVICE_DELAY_US(7000);

    }

    return 0;
}

