/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"
#include "lin_transfer.h"
#include "dma_controller.h"
#include "inc/hw_lin.h"
#include "inc/hw_memmap.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

uint16_t receivedID = 0xFF;
extern LIN_SlaveDataBuf slaveData;
extern uint16_t done_chanel0;

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

int main(void)
{
	uint32_t status = 0;
	uint8_t identifier = 0;
	uint8_t i = 0;

	__disable_irq();

	Device_init();

	lin_init();

	dma_init(LIN_BASE);

	__enable_irq();

	while(1){

		do{
			LIN_getStatus(LIN_BASE,&status);
		}while((status & LIN_LIN_CHANNEL_LINID) != LIN_LIN_CHANNEL_LINID);

		LIN_LinGetIdentifier(LIN_BASE,&identifier);

#if(LIN_ACTION)
		if (LIN_LinSetNodeAction(LIN_BASE, LIN_LIN_OP_MODE_PUBLISH))
			while (1);
#else
		if (LIN_LinSetNodeAction(LIN_BASE, LIN_LIN_OP_MODE_SUBSCRIBE))
			while (1);
#endif

		DMA_startChannel(DMA1_CH1_BASE);

		while(done_chanel0 == 0);

		LIN_resetTransferStatus(LIN_BASE);

		done_chanel0 = 0;

	}

	return 0;
}




